/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.function.Function;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestHandler;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxRequestTargetListenerCollection;
import org.apache.wicket.coep.CrossOriginEmbedderPolicyConfiguration;
import org.apache.wicket.coep.CrossOriginEmbedderPolicyRequestCycleListener;
import org.apache.wicket.coop.CrossOriginOpenerPolicyConfiguration;
import org.apache.wicket.coop.CrossOriginOpenerPolicyRequestCycleListener;
import org.apache.wicket.core.request.mapper.MountedMapper;
import org.apache.wicket.core.request.mapper.PackageMapper;
import org.apache.wicket.core.request.mapper.ResourceMapper;
import org.apache.wicket.core.util.file.WebApplicationPath;
import org.apache.wicket.core.util.resource.ClassPathResourceFinder;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.AutoLabelResolver;
import org.apache.wicket.markup.html.form.AutoLabelTextResolver;
import org.apache.wicket.markup.html.pages.AccessDeniedPage;
import org.apache.wicket.markup.html.pages.InternalErrorPage;
import org.apache.wicket.markup.html.pages.PageExpiredErrorPage;
import org.apache.wicket.markup.resolver.AutoLinkResolver;
import org.apache.wicket.protocol.http.AjaxEnclosureListener;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.HeaderBufferingWebResponse;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.MultipartFormComponentListener;
import org.apache.wicket.protocol.http.StoredResponsesMap;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.FilterFactoryManager;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebResponse;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.render.WebPageRenderer;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;
import org.apache.wicket.request.mapper.IRequestMapperDelegate;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.ReplacementResourceBundleReference;
import org.apache.wicket.session.HttpSessionStore;
import org.apache.wicket.util.file.FileCleaner;
import org.apache.wicket.util.file.IFileCleaner;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.file.Path;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.PackageName;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebApplication
extends Application {
    private static final Logger log = LoggerFactory.getLogger(WebApplication.class);
    public static final String META_INF_RESOURCES = "META-INF/resources";
    private ServletContext servletContext;
    private final AjaxRequestTargetListenerCollection ajaxRequestTargetListeners;
    private Function<Page, AjaxRequestTarget> ajaxRequestTargetProvider;
    private FilterFactoryManager filterFactoryManager;
    private RuntimeConfigurationType configurationType;
    private ContentSecurityPolicySettings cspSettings;
    private String sessionAttributePrefix;
    private WicketFilter wicketFilter;
    private final StoredResponsesMap storedResponses = new StoredResponsesMap(1000, Duration.ofSeconds(60L));

    public static WebApplication get() {
        Application application = Application.get();
        if (!(application instanceof WebApplication)) {
            throw new WicketRuntimeException("The application attached to the current thread is not a " + WebApplication.class.getSimpleName());
        }
        return (WebApplication)application;
    }

    public WebApplication() {
        this.ajaxRequestTargetListeners = new AjaxRequestTargetListenerCollection();
    }

    @Override
    public final String getApplicationKey() {
        return this.getName();
    }

    public String getInitParameter(String key) {
        if (this.wicketFilter != null) {
            return this.wicketFilter.getFilterConfig().getInitParameter(key);
        }
        throw new IllegalStateException("init parameter '" + key + "' is not set yet. Any code in your Application object that uses the wicketServlet/Filter instance should be put in the init() method instead of your constructor");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            throw new IllegalStateException("servletContext is not set yet. Any code in your Application object that uses the wicket filter instance should be put in the init() method instead of your constructor");
        }
        return this.servletContext;
    }

    public String getSessionAttributePrefix(WebRequest request, String filterName) {
        if (this.sessionAttributePrefix == null) {
            if (filterName == null) {
                filterName = this.getWicketFilter().getFilterConfig().getFilterName();
            }
            String namespace = this.getMapperContext().getNamespace();
            this.sessionAttributePrefix = namespace + ":" + filterName + ":";
        }
        return this.sessionAttributePrefix;
    }

    public final WicketFilter getWicketFilter() {
        return this.wicketFilter;
    }

    @Override
    public void logEventTarget(IRequestHandler target) {
        super.logEventTarget(target);
        IRequestLogger rl = this.getRequestLogger();
        if (rl != null) {
            rl.logEventTarget(target);
        }
    }

    @Override
    public void logResponseTarget(IRequestHandler target) {
        super.logResponseTarget(target);
        IRequestLogger rl = this.getRequestLogger();
        if (rl != null) {
            rl.logResponseTarget(target);
        }
    }

    public void mount(IRequestMapper mapper) {
        Args.notNull((Object)mapper, (String)"mapper");
        this.getRootRequestMapperAsCompound().add(mapper);
    }

    public <T extends Page> MountedMapper mountPage(String path, Class<T> pageClass) {
        MountedMapper mapper = new MountedMapper(path, pageClass);
        this.mount(mapper);
        return mapper;
    }

    public ResourceMapper mountResource(String path, ResourceReference reference) {
        if (reference.canBeRegistered()) {
            this.getResourceReferenceRegistry().registerResourceReference(reference);
        }
        ResourceMapper mapper = new ResourceMapper(path, reference);
        this.mount(mapper);
        return mapper;
    }

    public <P extends Page> PackageMapper mountPackage(String path, Class<P> pageClass) {
        PackageMapper packageMapper = new PackageMapper(path, PackageName.forClass(pageClass));
        this.mount(packageMapper);
        return packageMapper;
    }

    public void unmount(String path) {
        Args.notNull((Object)path, (String)"path");
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        IRequestMapper mapper = this.getRootRequestMapper();
        while (mapper instanceof IRequestMapperDelegate) {
            mapper = ((IRequestMapperDelegate)mapper).getDelegateMapper();
        }
        if (mapper instanceof ICompoundRequestMapper) {
            final Url url = Url.parse((CharSequence)path);
            Request request = new Request(){

                public Url getUrl() {
                    return url;
                }

                public Url getClientUrl() {
                    return url;
                }

                public Locale getLocale() {
                    return null;
                }

                public Charset getCharset() {
                    return null;
                }

                public Object getContainerRequest() {
                    return null;
                }
            };
            this.unmountFromCompound((ICompoundRequestMapper)mapper, request);
        }
    }

    private void unmountFromCompound(ICompoundRequestMapper parent, Request request) {
        LinkedList<IRequestMapper> toRemove = new LinkedList<IRequestMapper>();
        for (IRequestMapper mapper : parent) {
            if (mapper.mapRequest(request) == null) continue;
            IRequestMapper actualMapper = mapper;
            while (actualMapper instanceof IRequestMapperDelegate) {
                actualMapper = ((IRequestMapperDelegate)actualMapper).getDelegateMapper();
            }
            if (actualMapper instanceof ICompoundRequestMapper) {
                this.unmountFromCompound((ICompoundRequestMapper)actualMapper, request);
                continue;
            }
            toRemove.add(mapper);
        }
        for (IRequestMapper mapper : toRemove) {
            parent.remove(mapper);
        }
    }

    public final void addResourceReplacement(JavaScriptResourceReference base, ResourceReference replacement) {
        ReplacementResourceBundleReference bundle = new ReplacementResourceBundleReference(replacement);
        bundle.addProvidedResources(JavaScriptHeaderItem.forReference(base));
        this.getResourceBundles().addBundle(JavaScriptHeaderItem.forReference(bundle));
    }

    public final void addResourceReplacement(CssResourceReference base, ResourceReference replacement) {
        ReplacementResourceBundleReference bundle = new ReplacementResourceBundleReference(replacement);
        bundle.addProvidedResources(CssHeaderItem.forReference(base));
        this.getResourceBundles().addBundle(CssHeaderItem.forReference(bundle));
    }

    public WebRequest newWebRequest(HttpServletRequest servletRequest, String filterPath) {
        return new ServletWebRequest(servletRequest, filterPath);
    }

    WebRequest createWebRequest(HttpServletRequest servletRequest, String filterPath) {
        if (this.hasFilterFactoryManager()) {
            for (AbstractRequestWrapperFactory factory : this.getFilterFactoryManager()) {
                servletRequest = factory.getWrapper(servletRequest);
            }
        }
        WebRequest webRequest = this.newWebRequest(servletRequest, filterPath);
        if (servletRequest.getCharacterEncoding() == null) {
            try {
                if (webRequest.isAjax()) {
                    servletRequest.setCharacterEncoding("UTF-8");
                } else {
                    String requestEncoding = this.getRequestCycleSettings().getResponseRequestEncoding();
                    servletRequest.setCharacterEncoding(requestEncoding);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new WicketRuntimeException(e);
            }
        }
        return webRequest;
    }

    protected WebResponse newWebResponse(WebRequest webRequest, HttpServletResponse httpServletResponse) {
        return new ServletWebResponse((ServletWebRequest)webRequest, httpServletResponse);
    }

    WebResponse createWebResponse(WebRequest webRequest, HttpServletResponse httpServletResponse) {
        WebResponse webResponse = this.newWebResponse(webRequest, httpServletResponse);
        boolean shouldBufferResponse = this.getRequestCycleSettings().getBufferResponse();
        return shouldBufferResponse ? new HeaderBufferingWebResponse(webResponse) : webResponse;
    }

    @Override
    public Session newSession(Request request, Response response) {
        return new WebSession(request);
    }

    @Override
    public void sessionUnbound(String sessionId) {
        super.sessionUnbound(sessionId);
        IRequestLogger logger = this.getRequestLogger();
        if (logger != null) {
            logger.sessionDestroyed(sessionId);
        }
    }

    public final void setWicketFilter(WicketFilter wicketFilter) {
        Args.notNull((Object)wicketFilter, (String)"wicketFilter");
        this.wicketFilter = wicketFilter;
        this.servletContext = wicketFilter.getFilterConfig().getServletContext();
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public void internalDestroy() {
        IFileCleaner fileCleaner;
        IModificationWatcher resourceWatcher = this.getResourceSettings().getResourceWatcher(false);
        if (resourceWatcher != null) {
            resourceWatcher.destroy();
        }
        if ((fileCleaner = this.getResourceSettings().getFileCleaner()) != null) {
            fileCleaner.destroy();
        }
        super.internalDestroy();
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        this.getResourceSettings().getResourceFinders().add(new WebApplicationPath(this.getServletContext(), ""));
        this.getResourceSettings().getResourceFinders().add(new ClassPathResourceFinder(META_INF_RESOURCES));
        this.getApplicationSettings().setPageExpiredErrorPage(PageExpiredErrorPage.class);
        this.getApplicationSettings().setInternalErrorPage(InternalErrorPage.class);
        this.getApplicationSettings().setAccessDeniedPage(AccessDeniedPage.class);
        this.getPageSettings().addComponentResolver(new AutoLinkResolver());
        this.getPageSettings().addComponentResolver(new AutoLabelResolver());
        this.getPageSettings().addComponentResolver(new AutoLabelTextResolver());
        this.getResourceSettings().setFileCleaner((IFileCleaner)new FileCleaner());
        this.setPageRendererProvider(WebPageRenderer::new);
        this.setSessionStoreProvider(HttpSessionStore::new);
        this.setAjaxRequestTargetProvider(AjaxRequestHandler::new);
        AjaxRequestTargetListenerCollection ajaxRequestTargetListeners = this.getAjaxRequestTargetListeners();
        ajaxRequestTargetListeners.add(new AjaxEnclosureListener());
        ajaxRequestTargetListeners.add(new MultipartFormComponentListener());
        this.configure();
        if (this.getConfigurationType() == RuntimeConfigurationType.DEVELOPMENT) {
            String resourceFolder = this.getInitParameter("sourceFolder");
            if (resourceFolder != null) {
                this.getResourceSettings().getResourceFinders().add((IResourceFinder)new Path(resourceFolder));
            }
            this.getCspSettings().blocking().reportBack();
        }
        this.getCspSettings().blocking().strict();
    }

    @Override
    protected void validateInit() {
        CrossOriginEmbedderPolicyConfiguration coepConfig;
        CrossOriginOpenerPolicyConfiguration coopConfig;
        super.validateInit();
        if (this.getCspSettings().isEnabled()) {
            this.getCspSettings().enforce(this);
        }
        if ((coopConfig = this.getSecuritySettings().getCrossOriginOpenerPolicyConfiguration()).isEnabled()) {
            this.getRequestCycleListeners().add(new CrossOriginOpenerPolicyRequestCycleListener(coopConfig));
        }
        if ((coepConfig = this.getSecuritySettings().getCrossOriginEmbedderPolicyConfiguration()).isEnabled()) {
            this.getRequestCycleListeners().add(new CrossOriginEmbedderPolicyRequestCycleListener(coepConfig));
        }
    }

    public Application setConfigurationType(RuntimeConfigurationType configurationType) {
        if (this.configurationType != null) {
            throw new IllegalStateException("Configuration type is write-once. You can not change it. Current value='" + String.valueOf((Object)configurationType) + "'");
        }
        this.configurationType = (RuntimeConfigurationType)((Object)Args.notNull((Object)((Object)configurationType), (String)"configurationType"));
        return this;
    }

    @Override
    public RuntimeConfigurationType getConfigurationType() {
        if (this.configurationType == null) {
            String result = null;
            try {
                result = System.getProperty("wicket.configuration");
            }
            catch (SecurityException e) {
                log.warn("SecurityManager doesn't allow to read the configuration type from the system properties. The configuration type will be read from the web.xml.");
            }
            if (result == null) {
                result = this.getInitParameter("wicket.configuration");
            }
            if (result == null) {
                result = this.getServletContext().getInitParameter("wicket.configuration");
            }
            if (result == null) {
                result = this.getInitParameter("configuration");
            }
            if (result == null) {
                result = this.getServletContext().getInitParameter("configuration");
            }
            if (result != null) {
                try {
                    this.configurationType = RuntimeConfigurationType.valueOf(result.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid configuration type: '" + result + "'.  Must be \"development\" or \"deployment\".");
                }
            }
        }
        if (this.configurationType == null) {
            this.configurationType = RuntimeConfigurationType.DEVELOPMENT;
        }
        return this.configurationType;
    }

    public void renderXmlDecl(WebPage page, boolean insert) {
        if (insert || "application/xhtml+xml".equalsIgnoreCase(page.getMarkupType().getMimeType())) {
            RequestCycle cycle = RequestCycle.get();
            if (!insert) {
                WebRequest request = (WebRequest)cycle.getRequest();
                String accept = request.getHeader("Accept");
                boolean bl = insert = accept == null || accept.indexOf("application/xhtml+xml") != -1;
            }
            if (insert) {
                WebResponse response = (WebResponse)cycle.getResponse();
                response.write((CharSequence)"<?xml version='1.0'");
                String encoding = this.getRequestCycleSettings().getResponseRequestEncoding();
                if (!Strings.isEmpty((String)encoding)) {
                    response.write((CharSequence)" encoding='");
                    response.write((CharSequence)encoding);
                    response.write((CharSequence)"'");
                }
                response.write((CharSequence)" ?>");
            }
        }
    }

    public final AjaxRequestTarget newAjaxRequestTarget(Page page) {
        AjaxRequestTarget target = this.getAjaxRequestTargetProvider().apply(page);
        Iterator iterator = this.ajaxRequestTargetListeners.iterator();
        while (iterator.hasNext()) {
            AjaxRequestTarget.IListener listener = (AjaxRequestTarget.IListener)iterator.next();
            target.addListener(listener);
        }
        return target;
    }

    final void logStarted() {
        if (log.isInfoEnabled()) {
            String version = this.getFrameworkSettings().getVersion();
            StringBuilder b = new StringBuilder();
            b.append("[").append(this.getName()).append("] Started Wicket ");
            if (!"n/a".equals(version)) {
                b.append("version ").append(version).append(" ");
            }
            b.append("in ").append((Object)this.getConfigurationType()).append(" mode");
            log.info(b.toString());
        }
        if (this.usesDevelopmentConfig()) {
            this.outputDevelopmentModeWarning();
        }
    }

    protected void outputDevelopmentModeWarning() {
        System.err.print("********************************************************************\n*** WARNING: Wicket is running in DEVELOPMENT mode.              ***\n***                               ^^^^^^^^^^^                    ***\n*** Do NOT deploy to your live server(s) without changing this.  ***\n*** See Application#getConfigurationType() for more information. ***\n********************************************************************\n");
    }

    public boolean hasBufferedResponse(String sessionId, Url url) {
        String key = sessionId + url.toString();
        return this.storedResponses.containsKey(key);
    }

    public BufferedWebResponse getAndRemoveBufferedResponse(String sessionId, Url url) {
        String key = sessionId + url.toString();
        return this.storedResponses.remove(key);
    }

    public void storeBufferedResponse(String sessionId, Url url, BufferedWebResponse response) {
        if (Strings.isEmpty((String)sessionId)) {
            log.error("storeBufferedResponse needs a valid session id to store the response, but a null one was found. Please report the problem to dev team and try to reproduce it in a quickstart project.");
            return;
        }
        String key = sessionId + url.toString();
        this.storedResponses.put(key, (Object)response);
    }

    @Override
    public String getMimeType(String fileName) {
        String mimeType = this.getServletContext().getMimeType(fileName);
        return mimeType != null ? mimeType : super.getMimeType(fileName);
    }

    public Function<Page, AjaxRequestTarget> getAjaxRequestTargetProvider() {
        return this.ajaxRequestTargetProvider;
    }

    public Application setAjaxRequestTargetProvider(Function<Page, AjaxRequestTarget> ajaxRequestTargetProvider) {
        this.ajaxRequestTargetProvider = ajaxRequestTargetProvider;
        return this;
    }

    public AjaxRequestTargetListenerCollection getAjaxRequestTargetListeners() {
        return this.ajaxRequestTargetListeners;
    }

    public final boolean hasFilterFactoryManager() {
        return this.filterFactoryManager != null;
    }

    public final FilterFactoryManager getFilterFactoryManager() {
        if (this.filterFactoryManager == null) {
            this.filterFactoryManager = new FilterFactoryManager();
        }
        return this.filterFactoryManager;
    }

    public final ContentSecurityPolicySettings getCspSettings() {
        this.checkSettingsAvailable();
        if (this.cspSettings == null) {
            this.cspSettings = new ContentSecurityPolicySettings(this);
        }
        return this.cspSettings;
    }

    public void setCspSettings(ContentSecurityPolicySettings cspSettings) {
        this.cspSettings = cspSettings;
    }
}

