/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell.group;

import java.util.List;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.ManageGroupAction;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.core.shell.completer.AllNodeCompleter;
import org.apache.karaf.cellar.shell.group.GroupSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="group-set", description="Set the target nodes to a cluster group")
@Service
public class GroupSetCommand
extends GroupSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="node", description="The node(s) ID or alias", required=false, multiValued=true)
    @Completion(value=AllNodeCompleter.class)
    List<String> nodes;

    protected Object doExecute() throws Exception {
        Group group = this.groupManager.findGroupByName(this.groupName);
        if (group == null) {
            System.err.println("Cluster group " + this.groupName + " doesn't exist");
            return null;
        }
        return this.doExecute(ManageGroupAction.SET, this.groupName, null, this.nodes, false);
    }
}

