/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.generate;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.VertexFactory;
import org.apache.storm.shade.org.jgrapht.generate.GraphGenerator;
import org.apache.storm.shade.org.jgrapht.generate.LinearGraphGenerator;

public class RingGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int size;

    public RingGraphGenerator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = size;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        if (this.size < 1) {
            return;
        }
        LinearGraphGenerator linearGenerator = new LinearGraphGenerator(this.size);
        HashMap privateMap = new HashMap();
        linearGenerator.generateGraph(target, vertexFactory, privateMap);
        Object startVertex = privateMap.get("Start Vertex");
        Object endVertex = privateMap.get("End Vertex");
        target.addEdge(endVertex, startVertex);
    }
}

