/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;

public final class JavaStructuredNetworkWordCount {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaStructuredNetworkWordCount <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        SparkSession spark = SparkSession.builder().appName("JavaStructuredNetworkWordCount").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).load();
        Dataset words = lines.as(Encoders.STRING()).flatMap((FlatMapFunction & Serializable)x -> Arrays.asList(x.split(" ")).iterator(), Encoders.STRING());
        Dataset wordCounts = words.groupBy("value", new String[0]).count();
        StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").start();
        query.awaitTermination();
    }
}

