/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.OneToOneTTLState;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TTLState;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.ValueStateImplWithTTL$;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.streaming.TTLConfig;
import org.apache.spark.sql.streaming.ValueState;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001\u0002\r\u001a\u0001\u0019B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003T\u0011!a\u0006A!A!\u0002\u0013i\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015DQA\u001c\u0001\u0005\u0002=Dq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010\u0003\u0004~\u0001\u0001\u0006IA\u001f\u0005\u0006}\u0002!Ia \u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!!\u0006\u0001\t\u0003\n9\u0002\u0003\u0004\u0002\u001e\u0001!\te \u0005\t\u0003?\u0001A\u0011A\u000f\u0002\"!A\u0011\u0011\u0006\u0001\u0005\u0002u\tY\u0003\u0003\u0005\u00026\u0001!\t!HA\u001c\u000f%\tY$GA\u0001\u0012\u0003\tiD\u0002\u0005\u00193\u0005\u0005\t\u0012AA \u0011\u0019qG\u0003\"\u0001\u0002X!I\u0011\u0011\f\u000b\u0012\u0002\u0013\u0005\u00111\f\u0005\n\u0003k\"\u0012\u0011!C\u0005\u0003o\u0012QCV1mk\u0016\u001cF/\u0019;f\u00136\u0004HnV5uQR#FJ\u0003\u0002\u001b7\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00039u\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005yy\u0012aA:rY*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u00199bG\",'\"\u0001\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005\u001d\u001a4c\u0001\u0001)YA\u0011\u0011FK\u0007\u00023%\u00111&\u0007\u0002\u0011\u001f:,Gk\\(oKR#Fj\u0015;bi\u0016\u00042!L\u00182\u001b\u0005q#B\u0001\u000e\u001e\u0013\t\u0001dF\u0001\u0006WC2,Xm\u0015;bi\u0016\u0004\"AM\u001a\r\u0001\u0011)A\u0007\u0001b\u0001k\t\t1+\u0005\u00027yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9aj\u001c;iS:<\u0007CA\u001c>\u0013\tq\u0004HA\u0002B]f\fQa\u001d;pe\u0016\u0004\"!\u0011#\u000e\u0003\tS!aQ\r\u0002\u000bM$\u0018\r^3\n\u0005\u0015\u0013%AC*uCR,7\u000b^8sK\u0006I1\u000f^1uK:\u000bW.\u001a\t\u0003\u0011>s!!S'\u0011\u0005)CT\"A&\u000b\u00051+\u0013A\u0002\u001fs_>$h(\u0003\u0002Oq\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0005(\u0001\u0006lKf,\u0005\u0010\u001d:F]\u000e\u00042\u0001V-=\u001b\u0005)&B\u0001,X\u0003!)gnY8eKJ\u001c(B\u0001-\u001e\u0003!\u0019\u0017\r^1msN$\u0018B\u0001.V\u0005E)\u0005\u0010\u001d:fgNLwN\\#oG>$WM]\u0001\u000bm\u0006dWI\\2pI\u0016\u0014\u0018!\u0003;uY\u000e{gNZ5h!\tic,\u0003\u0002`]\tIA\u000b\u0016'D_:4\u0017nZ\u0001\u0011E\u0006$8\r\u001b+j[\u0016\u001cH/Y7q\u001bN\u0004\"a\u000e2\n\u0005\rD$\u0001\u0002'p]\u001e\fq!\\3ue&\u001c7\u000f\u0005\u0003IM\u001eC\u0017BA4R\u0005\ri\u0015\r\u001d\t\u0003S2l\u0011A\u001b\u0006\u0003Wn\ta!\\3ue&\u001c\u0017BA7k\u0005%\u0019\u0016\u000bT'fiJL7-\u0001\u0004=S:LGO\u0010\u000b\taF\u00148\u000f^;woB\u0019\u0011\u0006A\u0019\t\u000b}B\u0001\u0019\u0001!\t\u000b\u0019C\u0001\u0019A$\t\u000bIC\u0001\u0019A*\t\u000bmC\u0001\u0019A*\t\u000bqC\u0001\u0019A/\t\u000b\u0001D\u0001\u0019A1\t\u000f\u0011D\u0001\u0013!a\u0001K\u0006\t2\u000f^1uKRK\b/Z:F]\u000e|G-\u001a:\u0016\u0003i\u00042!K>=\u0013\ta\u0018DA\tTi\u0006$X\rV=qKN,enY8eKJ\f!c\u001d;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3sA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0005\u0005\u0005\u0001cA\u001c\u0002\u0004%\u0019\u0011Q\u0001\u001d\u0003\tUs\u0017\u000e^\u0001\u0007KbL7\u000f^:\u0015\u0005\u0005-\u0001cA\u001c\u0002\u000e%\u0019\u0011q\u0002\u001d\u0003\u000f\t{w\u000e\\3b]\u0006\u0019q-\u001a;\u0015\u0003E\na!\u001e9eCR,G\u0003BA\u0001\u00033Aa!a\u0007\u000f\u0001\u0004\t\u0014\u0001\u00038foN#\u0018\r^3\u0002\u000b\rdW-\u0019:\u0002-\u001d,GoV5uQ>,H/\u00128g_J\u001c\u0017N\\4U)2#\"!a\t\u0011\t]\n)#M\u0005\u0004\u0003OA$AB(qi&|g.A\u0006hKR$F\u000b\u0014,bYV,GCAA\u0017!\u00159\u0014QEA\u0018!\u00159\u0014\u0011G\u0019b\u0013\r\t\u0019\u0004\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0002%\u001d,GOV1mk\u0016Le\u000e\u0016+M'R\fG/\u001a\u000b\u0003\u0003s\u0001BaNA\u0013C\u0006)b+\u00197vKN#\u0018\r^3J[Bdw+\u001b;i)Rc\u0005CA\u0015\u0015'\u0015!\u0012\u0011IA$!\r9\u00141I\u0005\u0004\u0003\u000bB$AB!osJ+g\r\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\u0005%|'BAA)\u0003\u0011Q\u0017M^1\n\t\u0005U\u00131\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003{\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:T\u0003BA/\u0003g*\"!a\u0018+\u0007\u0015\f\tg\u000b\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!C;oG\",7m[3e\u0015\r\ti\u0007O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA9\u0003O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015!dC1\u00016\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tI\b\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\u0011\ty(a\u0014\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\u000biH\u0001\u0004PE*,7\r\u001e")
public class ValueStateImplWithTTL<S>
extends OneToOneTTLState
implements ValueState<S> {
    private final StateStore store;
    private final String stateName;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final ExpressionEncoder<Object> valEncoder;
    private final TTLConfig ttlConfig;
    private final long batchTimestampMs;
    private final StateTypesEncoder<Object> stateTypesEncoder;

    public static <S> Map<String, SQLMetric> $lessinit$greater$default$7() {
        return ValueStateImplWithTTL$.MODULE$.$lessinit$greater$default$7();
    }

    private StateTypesEncoder<Object> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    private void initialize() {
        this.store.createColFamilyIfAbsent(this.stateName, this.keyExprEnc.schema(), TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(this.valEncoder.schema(), true), new NoPrefixKeyStateEncoderSpec(this.keyExprEnc.schema()), this.store.createColFamilyIfAbsent$default$5(), this.store.createColFamilyIfAbsent$default$6());
    }

    public boolean exists() {
        return this.get() != null;
    }

    public S get() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Object resState = this.stateTypesEncoder().decodeValue(retRow);
            if (!this.stateTypesEncoder().isExpired(retRow, this.batchTimestampMs)) {
                return (S)resState;
            }
            return null;
        }
        return null;
    }

    public void update(S newState) {
        UnsafeRow encodedKey = this.stateTypesEncoder().encodeGroupingKey();
        long ttlExpirationMs = StateTTL$.MODULE$.calculateExpirationTimeForDuration(this.ttlConfig.ttlDuration(), this.batchTimestampMs);
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(newState, ttlExpirationMs);
        this.updatePrimaryAndSecondaryIndices(encodedKey, encodedValue, ttlExpirationMs);
    }

    public void clear() {
        UnsafeRow groupingKey = this.stateTypesEncoder().encodeGroupingKey();
        this.clearAllStateForElementKey(groupingKey);
    }

    public Option<S> getWithoutEnforcingTTL() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Object resState = this.stateTypesEncoder().decodeValue(retRow);
            return new Some(resState);
        }
        return None$.MODULE$;
    }

    public Option<Tuple2<S, Object>> getTTLValue() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        UnsafeRow retRow = this.store.get(encodedGroupingKey, this.stateName);
        if (retRow != null) {
            Option<Object> ttlExpiration = this.stateTypesEncoder().decodeTtlExpirationMs(retRow);
            return ttlExpiration.map((Function1 & Serializable)expiration -> ValueStateImplWithTTL.$anonfun$getTTLValue$1(this, retRow, BoxesRunTime.unboxToLong((Object)expiration)));
        }
        return None$.MODULE$;
    }

    public Option<Object> getValueInTTLState() {
        UnsafeRow groupingKey = this.stateTypesEncoder().encodeGroupingKey();
        Seq ttlRowsForGroupingKey = this.getTTLRows().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ValueStateImplWithTTL.$anonfun$getValueInTTLState$1(groupingKey, x$1))).toSeq();
        Predef$.MODULE$.assert(ttlRowsForGroupingKey.size() <= 1, (Function0 & Serializable)() -> "Multiple TTLRows found for grouping key " + groupingKey + ". Expected at most 1. Found: " + ttlRowsForGroupingKey.mkString(", ") + ".");
        return ttlRowsForGroupingKey.headOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.expirationMs()));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getTTLValue$1(ValueStateImplWithTTL $this, UnsafeRow retRow$1, long expiration) {
        return new Tuple2($this.stateTypesEncoder().decodeValue(retRow$1), (Object)BoxesRunTime.boxToLong((long)expiration));
    }

    public static final /* synthetic */ boolean $anonfun$getValueInTTLState$1(UnsafeRow groupingKey$1, TTLState.TTLRow x$1) {
        UnsafeRow unsafeRow = x$1.elementKey();
        UnsafeRow unsafeRow2 = groupingKey$1;
        return !(unsafeRow != null ? !unsafeRow.equals(unsafeRow2) : unsafeRow2 != null);
    }

    public ValueStateImplWithTTL(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, ExpressionEncoder<Object> valEncoder, TTLConfig ttlConfig, long batchTimestampMs, Map<String, SQLMetric> metrics) {
        this.store = store;
        this.stateName = stateName;
        this.keyExprEnc = keyExprEnc;
        this.valEncoder = valEncoder;
        this.ttlConfig = ttlConfig;
        this.batchTimestampMs = batchTimestampMs;
        super(stateName, store, keyExprEnc.schema(), ttlConfig, batchTimestampMs, metrics);
        this.stateTypesEncoder = StateTypesEncoder$.MODULE$.apply(keyExprEnc, valEncoder, stateName, true);
        this.initialize();
    }
}

