/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.sightly.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.sling.ide.eclipse.sightly.ui.internal.SharedImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractNewSightlyFileWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected WizardNewFileCreationPage fileCreationPage;
    private String pageTitle;
    private String wizardDescription;

    public AbstractNewSightlyFileWizard(String pageTitle, String wizardDescription) {
        this.pageTitle = pageTitle;
        this.wizardDescription = wizardDescription;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.fileCreationPage = new WizardNewFileCreationPage(this.pageTitle, selection){

            protected InputStream getInitialContents() {
                String contents = AbstractNewSightlyFileWizard.this.getInitialContents();
                return new ByteArrayInputStream(contents.getBytes());
            }

            protected boolean validatePage() {
                return super.validatePage() && AbstractNewSightlyFileWizard.this.validateFileToBeCreated();
            }
        };
        if (this.getInitialFileName() != null) {
            this.fileCreationPage.setFileName(this.getInitialFileName());
        }
        this.fileCreationPage.setTitle("Sightly");
        this.fileCreationPage.setDescription(this.wizardDescription);
        this.fileCreationPage.setImageDescriptor(SharedImages.SIGHTLY_WIZARD_BANNER);
        this.setWindowTitle(this.pageTitle);
        this.addPage((IWizardPage)this.fileCreationPage);
    }

    public boolean performFinish() {
        if (!this.fileCreationPage.isPageComplete()) {
            return false;
        }
        IFile file = this.fileCreationPage.createNewFile();
        IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.apache.sling.ide.eclipse-sightly-ui", "Failed opening " + String.valueOf(file) + " in an editor", (Throwable)e), 3);
        }
        return true;
    }

    protected abstract String getInitialContents();

    protected boolean validateFileToBeCreated() {
        return true;
    }

    protected String getInitialFileName() {
        return null;
    }
}

