/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.OverrideCallable;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.loader.InterceptorInstanceLoader;
import org.apache.skywalking.apm.agent.core.so11y.AgentSo11y;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Morph;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;

public class StaticMethodsInterWithOverrideArgs {
    private static final ILog LOGGER = LogManager.getLogger(StaticMethodsInterWithOverrideArgs.class);
    private static final String INTERCEPTOR_TYPE = "static";
    private String pluginName;
    private String staticMethodsAroundInterceptorClassName;

    public StaticMethodsInterWithOverrideArgs(String pluginName, String staticMethodsAroundInterceptorClassName) {
        this.pluginName = pluginName;
        this.staticMethodsAroundInterceptorClassName = staticMethodsAroundInterceptorClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @Morph OverrideCallable zuper) throws Throwable {
        StaticMethodsAroundInterceptor interceptor = (StaticMethodsAroundInterceptor)InterceptorInstanceLoader.load(this.staticMethodsAroundInterceptorClassName, clazz.getClassLoader());
        long interceptorTimeCost = 0L;
        long startTimeOfMethodBeforeInter = System.nanoTime();
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            interceptor.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), result);
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] before static method[{}] intercept failure", clazz, method.getName());
            AgentSo11y.errorOfPlugin(this.pluginName, INTERCEPTOR_TYPE);
        }
        interceptorTimeCost += System.nanoTime() - startTimeOfMethodBeforeInter;
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call(allArguments);
        }
        catch (Throwable t) {
            try {
                long startTimeOfMethodHandleExceptionInter = System.nanoTime();
                try {
                    interceptor.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t);
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] handle static method[{}] exception failure", clazz, method.getName(), t2.getMessage());
                    AgentSo11y.errorOfPlugin(this.pluginName, INTERCEPTOR_TYPE);
                }
                interceptorTimeCost += System.nanoTime() - startTimeOfMethodHandleExceptionInter;
                throw t;
            }
            catch (Throwable throwable) {
                long startTimeOfMethodAfterInter2 = System.nanoTime();
                try {
                    ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
                }
                catch (Throwable t2) {
                    LOGGER.error(t2, "class[{}] after static method[{}] intercept failure:{}", clazz, method.getName(), t2.getMessage());
                    AgentSo11y.errorOfPlugin(this.pluginName, INTERCEPTOR_TYPE);
                }
                interceptorTimeCost += System.nanoTime() - startTimeOfMethodAfterInter2;
                throw throwable;
            }
        }
        long startTimeOfMethodAfterInter = System.nanoTime();
        try {
            ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
        }
        catch (Throwable t) {
            LOGGER.error(t, "class[{}] after static method[{}] intercept failure:{}", clazz, method.getName(), t.getMessage());
            AgentSo11y.errorOfPlugin(this.pluginName, INTERCEPTOR_TYPE);
        }
        AgentSo11y.durationOfInterceptor(interceptorTimeCost += System.nanoTime() - startTimeOfMethodAfterInter);
        return ret;
    }
}

