/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.directives;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.directives.QueryAppliedDirectiveArgument;
import graphql.language.Directive;
import graphql.schema.GraphqlTypeBuilder;
import graphql.util.FpKit;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class QueryAppliedDirective {
    private final String name;
    private final ImmutableList<QueryAppliedDirectiveArgument> arguments;
    private final Directive definition;

    private QueryAppliedDirective(String name, Directive definition, Collection<QueryAppliedDirectiveArgument> arguments) {
        Assert.assertValidName(name);
        Assert.assertNotNull(arguments, () -> "arguments can't be null");
        this.name = name;
        this.arguments = ImmutableList.copyOf(arguments);
        this.definition = definition;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public List<QueryAppliedDirectiveArgument> getArguments() {
        return this.arguments;
    }

    @Nullable
    public QueryAppliedDirectiveArgument getArgument(String name) {
        for (QueryAppliedDirectiveArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    @Nullable
    public Directive getDefinition() {
        return this.definition;
    }

    public String toString() {
        return new StringJoiner(", ", QueryAppliedDirective.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("arguments=" + this.arguments).add("definition=" + this.definition).toString();
    }

    public QueryAppliedDirective transform(Consumer<Builder> builderConsumer) {
        Builder builder = QueryAppliedDirective.newDirective(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public static Builder newDirective(QueryAppliedDirective existing) {
        return new Builder(existing);
    }

    public static class Builder
    extends GraphqlTypeBuilder<Builder> {
        private final Map<String, QueryAppliedDirectiveArgument> arguments = new LinkedHashMap<String, QueryAppliedDirectiveArgument>();
        private Directive definition;

        public Builder() {
        }

        public Builder(QueryAppliedDirective existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.arguments.putAll(FpKit.getByName(existing.getArguments(), QueryAppliedDirectiveArgument::getName));
        }

        public Builder argument(QueryAppliedDirectiveArgument argument) {
            Assert.assertNotNull(argument, () -> "argument must not be null");
            this.arguments.put(argument.getName(), argument);
            return this;
        }

        public Builder replaceArguments(List<QueryAppliedDirectiveArgument> arguments) {
            Assert.assertNotNull(arguments, () -> "arguments must not be null");
            this.arguments.clear();
            for (QueryAppliedDirectiveArgument argument : arguments) {
                this.arguments.put(argument.getName(), argument);
            }
            return this;
        }

        public Builder argument(UnaryOperator<QueryAppliedDirectiveArgument.Builder> builderFunction) {
            QueryAppliedDirectiveArgument.Builder builder = QueryAppliedDirectiveArgument.newArgument();
            builder = (QueryAppliedDirectiveArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(QueryAppliedDirectiveArgument.Builder builder) {
            return this.argument(builder.build());
        }

        public Builder clearArguments() {
            this.arguments.clear();
            return this;
        }

        public Builder definition(Directive definition) {
            this.definition = definition;
            return this;
        }

        public QueryAppliedDirective build() {
            return new QueryAppliedDirective(this.name, this.definition, this.arguments.values());
        }
    }
}

