/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

abstract class Transferer {
    private static final int BUFFER_SIZE = 65536;
    protected final Raster source;
    protected final WritableRaster target;
    protected final Rectangle region;
    protected int band;

    protected Transferer(Raster source, WritableRaster target, Rectangle aoi) {
        this.source = source;
        this.target = target;
        this.region = aoi;
    }

    int prepareTransferRegion() {
        return Math.addExact(this.region.y, this.region.height);
    }

    static int prepareTransferRegion(Rectangle bounds, int dataType) {
        int size;
        if (bounds.isEmpty()) {
            throw new RasterFormatException(Resources.format((short)20));
        }
        int afterLastRow = Math.addExact(bounds.y, bounds.height);
        try {
            size = DataBuffer.getDataTypeSize(dataType);
        }
        catch (IllegalArgumentException e) {
            size = 16;
        }
        bounds.height = Math.max(1, Math.min(65536 / (size * bounds.width), bounds.height));
        return afterLastRow;
    }

    public final void compute(MathTransform1D[] converters) throws TransformException {
        assert (this.source.getBounds().contains(this.region)) : this.region;
        assert (this.target.getBounds().contains(this.region)) : this.region;
        int afterLastRow = this.prepareTransferRegion();
        int ymin = this.region.y;
        int maxHeight = this.region.height;
        this.band = 0;
        while (this.band < converters.length) {
            MathTransform1D converter = converters[this.band];
            this.region.y = ymin;
            do {
                this.region.height = Math.min(maxHeight, afterLastRow - this.region.y);
                this.computeStrip(converter);
            } while ((this.region.y += this.region.height) < afterLastRow);
            ++this.band;
        }
    }

    abstract void computeStrip(MathTransform1D var1) throws TransformException;

    final int length() {
        return Math.multiplyExact(this.region.width, this.region.height);
    }

    static Transferer create(RenderedImage source, WritableRaster target) {
        int tileX = ImageUtilities.pixelToTileX(source, target.getMinX());
        int tileY = ImageUtilities.pixelToTileY(source, target.getMinY());
        return Transferer.create(source.getTile(tileX, tileY), target, target.getBounds());
    }

    static Transferer create(Raster source, WritableRaster target, Rectangle aoi) {
        switch (DataType.forBands(target.getSampleModel()).toDataBufferType()) {
            case 5: {
                if (!Transferer.isDirect(target, aoi)) break;
                return new DoubleToDirect(source, target, aoi);
            }
            case 4: {
                switch (DataType.forBands(source.getSampleModel()).toDataBufferType()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: {
                        if (Transferer.isDirect(target, aoi)) {
                            return new FloatToDirect(source, target, aoi);
                        }
                        return new FloatToFloat(source, target, aoi);
                    }
                }
                break;
            }
            case 3: {
                return Transferer.singlePrecision(source) ? new FloatToInteger(source, target, aoi) : new DoubleToInteger(source, target, aoi);
            }
            case 1: {
                return Transferer.singlePrecision(source) ? new FloatToUShort(source, target, aoi) : new DoubleToUShort(source, target, aoi);
            }
            case 2: {
                return Transferer.singlePrecision(source) ? new FloatToShort(source, target, aoi) : new DoubleToShort(source, target, aoi);
            }
            case 0: {
                return Transferer.singlePrecision(source) ? new FloatToByte(source, target, aoi) : new DoubleToByte(source, target, aoi);
            }
        }
        return new DoubleToDouble(source, target, aoi);
    }

    private static boolean singlePrecision(Raster source) {
        switch (DataType.forBands(source.getSampleModel()).toDataBufferType()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDirect(Raster target, Rectangle aoi) {
        ComponentSampleModel cm;
        SampleModel sm;
        if (target.getMinX() == aoi.x && target.getWidth() == aoi.width && (sm = target.getSampleModel()) instanceof ComponentSampleModel && (cm = (ComponentSampleModel)sm).getPixelStride() == 1 && cm.getScanlineStride() == target.getWidth()) {
            for (int offset : target.getDataBuffer().getOffsets()) {
                if (offset == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static final class DoubleToDirect
    extends Transferer {
        private final DataBufferDouble buffer;

        DoubleToDirect(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
            this.buffer = (DataBufferDouble)target.getDataBuffer();
        }

        @Override
        void computeStrip(MathTransform1D converter) throws TransformException {
            double[] data = this.buffer.getData(this.band);
            data = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, data);
            converter.transform(data, 0, data, 0, this.length());
        }
    }

    private static final class FloatToDirect
    extends Transferer {
        private final DataBufferFloat buffer;

        FloatToDirect(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
            this.buffer = (DataBufferFloat)target.getDataBuffer();
        }

        @Override
        void computeStrip(MathTransform1D converter) throws TransformException {
            float[] data = this.buffer.getData(this.band);
            data = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, data);
            converter.transform(data, 0, data, 0, this.length());
        }
    }

    private static final class FloatToFloat
    extends Transferer {
        private float[] buffer;

        FloatToFloat(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        int prepareTransferRegion() {
            return FloatToFloat.prepareTransferRegion(this.region, 4);
        }

        @Override
        void computeStrip(MathTransform1D converter) throws TransformException {
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            converter.transform(this.buffer, 0, this.buffer, 0, this.length());
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
        }
    }

    private static class FloatToInteger
    extends Transferer {
        protected float[] buffer;
        protected int[] transfer;

        FloatToInteger(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        final int prepareTransferRegion() {
            return FloatToInteger.prepareTransferRegion(this.region, 4);
        }

        @Override
        final void computeStrip(MathTransform1D converter) throws TransformException {
            int length = this.length();
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            converter.transform(this.buffer, 0, this.buffer, 0, length);
            if (this.transfer == null) {
                this.transfer = new int[length];
            }
            this.clamp(length);
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.transfer);
        }

        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = Math.round(this.buffer[i]);
            }
        }
    }

    private static class DoubleToInteger
    extends Transferer {
        protected double[] buffer;
        protected int[] transfer;

        DoubleToInteger(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        final int prepareTransferRegion() {
            return DoubleToInteger.prepareTransferRegion(this.region, 5);
        }

        @Override
        final void computeStrip(MathTransform1D converter) throws TransformException {
            int length = this.length();
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            converter.transform(this.buffer, 0, this.buffer, 0, length);
            if (this.transfer == null) {
                this.transfer = new int[length];
            }
            this.clamp(length);
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.transfer);
        }

        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = Numerics.clamp((long)Math.round(this.buffer[i]));
            }
        }
    }

    private static final class FloatToUShort
    extends FloatToInteger {
        FloatToUShort(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = Math.max(0, Math.min(65535, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToUShort
    extends DoubleToInteger {
        DoubleToUShort(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = (int)Math.max(0L, Math.min(65535L, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class FloatToShort
    extends FloatToInteger {
        FloatToShort(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToShort
    extends DoubleToInteger {
        DoubleToShort(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = (int)Math.max(-32768L, Math.min(32767L, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class FloatToByte
    extends FloatToInteger {
        FloatToByte(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = Math.max(0, Math.min(255, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToByte
    extends DoubleToInteger {
        DoubleToByte(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        void clamp(int length) {
            for (int i = 0; i < length; ++i) {
                this.transfer[i] = (int)Math.max(0L, Math.min(255L, Math.round(this.buffer[i])));
            }
        }
    }

    private static final class DoubleToDouble
    extends Transferer {
        private double[] buffer;

        DoubleToDouble(Raster source, WritableRaster target, Rectangle aoi) {
            super(source, target, aoi);
        }

        @Override
        int prepareTransferRegion() {
            return DoubleToDouble.prepareTransferRegion(this.region, 5);
        }

        @Override
        void computeStrip(MathTransform1D converter) throws TransformException {
            this.buffer = this.source.getSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
            converter.transform(this.buffer, 0, this.buffer, 0, this.length());
            this.target.setSamples(this.region.x, this.region.y, this.region.width, this.region.height, this.band, this.buffer);
        }
    }
}

