/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public class PriorityPropertyType<T> {
    private final Type type;
    private final T invalidValue;
    private final T defaultValue;
    private final String[] priorityKeys;

    public PriorityPropertyType(Type type, T invalidValue, T defaultValue, String ... priorityKeys) {
        this.type = type;
        this.invalidValue = invalidValue;
        this.defaultValue = defaultValue;
        this.priorityKeys = priorityKeys;
    }

    public Type getType() {
        return this.type;
    }

    public T getInvalidValue() {
        return this.invalidValue;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getPriorityKeys() {
        return this.priorityKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriorityPropertyType that = (PriorityPropertyType)o;
        return this.type.equals(that.type) && Objects.equals(this.invalidValue, that.invalidValue) && Objects.equals(this.defaultValue, that.defaultValue) && Arrays.equals(this.priorityKeys, that.priorityKeys);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.invalidValue, this.defaultValue);
        result = 31 * result + Arrays.hashCode(this.priorityKeys);
        return result;
    }
}

