/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.filter.config.AbstractFilterChainsConfig;
import org.springframework.util.CollectionUtils;

public class InvocationFilterChainsConfig
extends AbstractFilterChainsConfig {
    private final String policiesRoot;
    private final List<String> frameworkChain;
    private final List<String> defaultChain;
    private final Map<String, List<String>> microserviceChains = new HashMap<String, List<String>>();

    public InvocationFilterChainsConfig(String root) {
        this.frameworkChain = ConfigUtil.getStringList((Configuration)this.config, (String)(root + ".framework"));
        this.defaultChain = this.loadDefaultChain(root);
        this.policiesRoot = root + ".policies";
        this.loadKeys(this.policiesRoot, this::loadPolicies);
    }

    private List<String> loadDefaultChain(String root) {
        String defaultChainKey = root + ".default";
        List<String> defaultChain = ConfigUtil.getStringList((Configuration)this.config, (String)defaultChainKey);
        if (CollectionUtils.isEmpty((Collection)defaultChain) && this.config.getProperty(defaultChainKey) == null) {
            defaultChain = this.frameworkChain;
        }
        return defaultChain;
    }

    private void loadPolicies(String qualifiedKey) {
        String microserviceName = qualifiedKey.substring(this.policiesRoot.length() + 1);
        this.microserviceChains.put(microserviceName, ConfigUtil.getStringList((Configuration)this.config, (String)qualifiedKey));
    }

    public List<String> getFrameworkChain() {
        return this.frameworkChain;
    }

    public List<String> getDefaultChain() {
        return this.defaultChain;
    }

    public Map<String, List<String>> getMicroserviceChains() {
        return this.microserviceChains;
    }
}

