/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.plugins;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.server.user.connection.limits.config.Rule;
import org.apache.qpid.server.user.connection.limits.plugins.ConnectionLimitRule;

class ConnectionLimitRuleImpl
implements ConnectionLimitRule {
    private final Rule _rule;

    ConnectionLimitRuleImpl(Rule rule) {
        this._rule = Objects.requireNonNull(rule);
    }

    @Override
    public String getPort() {
        return this._rule.getPort();
    }

    @Override
    public String getIdentity() {
        return this._rule.getIdentity();
    }

    @Override
    public Boolean getBlocked() {
        return this._rule.isUserBlocked();
    }

    @Override
    public Integer getCountLimit() {
        if (!this._rule.isUserBlocked()) {
            return this._rule.getCountLimit();
        }
        return null;
    }

    @Override
    public Integer getFrequencyLimit() {
        if (!this._rule.isUserBlocked()) {
            return this._rule.getFrequencyLimit();
        }
        return null;
    }

    @Override
    public Long getFrequencyPeriod() {
        if (!this._rule.isUserBlocked() && this._rule.getFrequencyLimit() != null) {
            return Optional.ofNullable(this._rule.getFrequencyPeriod()).map(Duration::toMillis).orElse(null);
        }
        return null;
    }
}

