/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.search.entry;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeType
extends GrammarAction<LdapMessageContainer<SearchResultEntry>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddAttributeType.class);

    public AddAttributeType() {
        super("Store the AttributeType");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultEntry> container) throws DecoderException {
        SearchResultEntry searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05147_NULL_ATTRIBUTE_TYPE, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        try {
            DefaultAttribute attribute = new DefaultAttribute(tlv.getValue().getData());
            container.setCurrentAttribute(attribute);
            searchResultEntry.getEntry().put(attribute);
        }
        catch (LdapException ine) {
            String type = Strings.utf8ToString(tlv.getValue().getData());
            String msg = I18n.err(I18n.ERR_05156_INVALID_ATTRIBUTE_TYPE, type, ine.getMessage());
            LOG.error(I18n.err(I18n.ERR_05114_ERROR_MESSAGE, msg, ine.getMessage()));
            throw new DecoderException(msg, ine);
        }
        if (LOG.isDebugEnabled()) {
            String type = Strings.utf8ToString(tlv.getValue().getData());
            LOG.debug(I18n.msg(I18n.MSG_05179_ATTRIBUTE_TYPE, type));
        }
    }
}

