import java.io.*;

import org.apache.maven.plugin.*;

/**
 * @goal touch
 */
public class TouchMojo
    extends AbstractMojo
{

    /**
     * @parameter default-value="target/touch.txt"
     */
    private File outputFile;

    public void execute()
        throws MojoExecutionException
    {
        try
        {
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( "Failed to create touch file " + outputFile + ": " + e.getMessage(), e );
        }
    }

}
