/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Dependency
implements Serializable {
    final String groupId;
    final String artifactId;
    final String version;
    final String type;

    protected Dependency(Builder builder) {
        String string = builder.groupId != null ? builder.groupId : (this.groupId = builder.base != null ? builder.base.groupId : null);
        String string2 = builder.artifactId != null ? builder.artifactId : (this.artifactId = builder.base != null ? builder.base.artifactId : null);
        String string3 = builder.version != null ? builder.version : (this.version = builder.base != null ? builder.base.version : null);
        this.type = builder.type != null ? builder.type : (builder.base != null ? builder.base.type : null);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    @Nonnull
    public Builder with() {
        return Dependency.newBuilder(this);
    }

    @Nonnull
    public Dependency withGroupId(String groupId) {
        return Dependency.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Dependency withArtifactId(String artifactId) {
        return Dependency.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Dependency withVersion(String version) {
        return Dependency.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Dependency withType(String type) {
        return Dependency.newBuilder(this, true).type(type).build();
    }

    @Nonnull
    public static Dependency newInstance() {
        return Dependency.newInstance(true);
    }

    @Nonnull
    public static Dependency newInstance(boolean withDefaults) {
        return Dependency.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Dependency.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Dependency from) {
        return Dependency.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Dependency from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Dependency base;
        String groupId;
        String artifactId;
        String version;
        String type;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.type = "jar";
            }
        }

        protected Builder(Dependency base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.type = base.type;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Dependency build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.type != null && this.type != this.base.type)) {
                return this.base;
            }
            return new Dependency(this);
        }
    }
}

