/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.filter;

import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.identityasserter.common.filter.AbstractIdentityAsserterDeploymentContributor;
import org.apache.knox.gateway.identityasserter.filter.IdentityAsserterFilter;
import org.apache.knox.gateway.topology.Provider;

public class IdentityAsserterDeploymentContributor
extends AbstractIdentityAsserterDeploymentContributor {
    private static final String FILTER_CLASSNAME = IdentityAsserterFilter.class.getName();
    private static final String PRINCIPAL_MAPPING_PARAM_NAME = "principal.mapping";
    private static final String GROUP_PRINCIPAL_MAPPING_PARAM_NAME = "group.principal.mapping";

    public String getName() {
        return "Pseudo";
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        super.contributeProvider(context, provider);
        String mappings = (String)provider.getParams().get(PRINCIPAL_MAPPING_PARAM_NAME);
        String groupMappings = (String)provider.getParams().get(GROUP_PRINCIPAL_MAPPING_PARAM_NAME);
        context.getWebAppDescriptor().createContextParam().paramName(PRINCIPAL_MAPPING_PARAM_NAME).paramValue(mappings);
        context.getWebAppDescriptor().createContextParam().paramName(GROUP_PRINCIPAL_MAPPING_PARAM_NAME).paramValue(groupMappings);
        provider.getParamsList().stream().filter(each -> each.getName().startsWith("group.mapping.")).forEach(each -> context.getWebAppDescriptor().createContextParam().paramName(each.getName()).paramValue(each.getValue()));
    }

    protected String getFilterClassname() {
        return FILTER_CLASSNAME;
    }
}

