/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.version.MavenVersion;
import java.util.Objects;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public interface MavenCapability
extends Capability {
    public static final String MAVEN_NAMESPACE = "bnd.maven";
    public static final String CAPABILITY_GROUPID_ATTRIBUTE = "maven-groupId";
    public static final String CAPABILITY_ARTIFACTID_ATTRIBUTE = "maven-artifactId";
    public static final String CAPABILITY_VERSION_ATTRIBUTE = "maven-version";
    public static final String CAPABILITY_CLASSIFIER_ATTRIBUTE = "maven-classifier";
    public static final String CAPABILITY_EXTENSION_ATTRIBUTE = "maven-extension";
    public static final String CAPABILITY_REPOSITORY_ATTRIBUTE = "maven-repository";

    public String maven_groupId();

    public String maven_artifactId();

    public MavenVersion maven_version();

    public String maven_classifier();

    public String maven_extension();

    public String maven_repository();

    public static void addMavenCapability(ResourceBuilder rb, String groupId, String artifactId, MavenVersion version, String extension, String classifier, String repository) {
        try {
            CapabilityBuilder c = new CapabilityBuilder(MAVEN_NAMESPACE);
            c.addAttribute(CAPABILITY_GROUPID_ATTRIBUTE, Objects.requireNonNull(groupId));
            c.addAttribute(CAPABILITY_ARTIFACTID_ATTRIBUTE, Objects.requireNonNull(artifactId));
            c.addAttribute(CAPABILITY_VERSION_ATTRIBUTE, Objects.requireNonNull(version));
            if (classifier != null) {
                c.addAttribute(CAPABILITY_CLASSIFIER_ATTRIBUTE, classifier);
            }
            if (extension != null) {
                c.addAttribute(CAPABILITY_EXTENSION_ATTRIBUTE, extension);
            }
            if (repository != null) {
                c.addAttribute(CAPABILITY_REPOSITORY_ATTRIBUTE, repository);
            }
            rb.addCapability(c);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public static MavenCapability getMavenCapability(Resource resource) {
        return ResourceUtils.capabilityStream(resource, MAVEN_NAMESPACE, MavenCapability.class).findFirst().orElse(null);
    }
}

