/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Graph;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.compact.SHACLC;
import org.apache.jena.shacl.compact.reader.ShaclcParseException;
import org.apache.jena.shacl.compact.reader.parser.ParseException;
import org.apache.jena.shacl.compact.reader.parser.ShaclCompactParserJJ;
import org.apache.jena.shacl.compact.reader.parser.TokenMgrError;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.Context;

public class ShaclcParser {
    public static Shapes parse(String filename) {
        return ShaclcParser.parse(filename, null);
    }

    public static Shapes parse(String filename, String baseURI) {
        InputStream input = IO.openFile(filename);
        return ShaclcParser.parse(input, baseURI);
    }

    public static Shapes parse(InputStream input, String baseURI) {
        Graph graph = GraphFactory.createDefaultGraph();
        StreamRDF dest = StreamRDFLib.graph(graph);
        ShaclcParser.parseSHACLC(input, baseURI, dest, null);
        return Shapes.parse(graph);
    }

    public static void parseSHACLC(InputStream input, StreamRDF stream) {
        ShaclcParser.parseSHACLC(input, null, stream, null);
    }

    public static void parseSHACLC(InputStream input, String baseURI, StreamRDF stream, Context context2) {
        ShaclCompactParserJJ parser = new ShaclCompactParserJJ(input, StandardCharsets.UTF_8.name());
        ShaclcParser.parse$(parser, stream, baseURI, context2);
    }

    public static void parseSHACLC(Reader reader, String baseURI, StreamRDF stream, Context context2) {
        ShaclCompactParserJJ parser = new ShaclCompactParserJJ(reader);
        ShaclcParser.parse$(parser, stream, baseURI, context2);
    }

    private static void parse$(ShaclCompactParserJJ parser, StreamRDF stream, String baseURI, Context context2) {
        ParserProfileStd profile = new ParserProfileStd(RiotLib.factoryRDF(), ErrorHandlerFactory.errorHandlerStd, IRIxResolver.create(baseURI).build(), PrefixMapFactory.create(), context2, false, false);
        SHACLC.addStandardPrefixes(profile.getPrefixMap());
        stream.start();
        parser.setDest(stream);
        parser.setProfile(profile);
        parser.start();
        try {
            parser.Unit();
        }
        catch (ParseException ex) {
            throw new ShaclcParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new ShaclcParseException(tErr.getMessage(), line, col);
        }
        parser.finish();
        stream.finish();
    }
}

