/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedView;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedViewPrimaryKey;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedViewSelection;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedViewSelectionWithColumns;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedViewStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedViewWhere;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedViewWhereStart;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.internal.querybuilder.schema.OptionsUtils;
import com.datastax.oss.driver.internal.querybuilder.schema.Utils;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateMaterializedView
implements CreateMaterializedViewStart,
CreateMaterializedViewSelectionWithColumns,
CreateMaterializedViewWhere,
CreateMaterializedViewPrimaryKey,
CreateMaterializedView {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier viewName;
    private final boolean ifNotExists;
    private final CqlIdentifier baseTableKeyspace;
    private final CqlIdentifier baseTable;
    private final ImmutableList<Selector> selectors;
    private final ImmutableList<Relation> whereRelations;
    private final ImmutableSet<CqlIdentifier> partitionKeyColumns;
    private final ImmutableSet<CqlIdentifier> clusteringKeyColumns;
    private final ImmutableMap<CqlIdentifier, ClusteringOrder> orderings;
    private final ImmutableMap<String, Object> options;

    public DefaultCreateMaterializedView(@NonNull CqlIdentifier viewName) {
        this(null, viewName);
    }

    public DefaultCreateMaterializedView(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier viewName) {
        this(keyspace, viewName, false, null, null, (ImmutableList<Selector>)ImmutableList.of(), (ImmutableList<Relation>)ImmutableList.of(), (ImmutableSet<CqlIdentifier>)ImmutableSet.of(), (ImmutableSet<CqlIdentifier>)ImmutableSet.of(), (ImmutableMap<CqlIdentifier, ClusteringOrder>)ImmutableMap.of(), (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public DefaultCreateMaterializedView(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier viewName, boolean ifNotExists, @Nullable CqlIdentifier baseTableKeyspace, @Nullable CqlIdentifier baseTable, @NonNull ImmutableList<Selector> selectors, @NonNull ImmutableList<Relation> whereRelations, @NonNull ImmutableSet<CqlIdentifier> partitionKeyColumns, @NonNull ImmutableSet<CqlIdentifier> clusteringKeyColumns, @NonNull ImmutableMap<CqlIdentifier, ClusteringOrder> orderings, @NonNull ImmutableMap<String, Object> options) {
        this.keyspace = keyspace;
        this.viewName = viewName;
        this.ifNotExists = ifNotExists;
        this.baseTableKeyspace = baseTableKeyspace;
        this.baseTable = baseTable;
        this.selectors = selectors;
        this.whereRelations = whereRelations;
        this.partitionKeyColumns = partitionKeyColumns;
        this.clusteringKeyColumns = clusteringKeyColumns;
        this.orderings = orderings;
        this.options = options;
    }

    @Override
    @NonNull
    public CreateMaterializedViewWhereStart all() {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, ImmutableCollections.append(this.selectors, Selector.all()), this.whereRelations, this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewSelectionWithColumns column(@NonNull CqlIdentifier columnName) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, ImmutableCollections.append(this.selectors, Selector.column(columnName)), this.whereRelations, this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewSelectionWithColumns columnsIds(@NonNull Iterable<CqlIdentifier> columnIds) {
        ImmutableList.Builder columnSelectors = ImmutableList.builder();
        for (CqlIdentifier column : columnIds) {
            columnSelectors.add((Object)Selector.column(column));
        }
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, ImmutableCollections.concat(this.selectors, columnSelectors.build()), this.whereRelations, this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewWhere where(@NonNull Relation relation) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, this.selectors, ImmutableCollections.append(this.whereRelations, relation), this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewWhere where(@NonNull Iterable<Relation> additionalRelations) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, this.selectors, ImmutableCollections.concat(this.whereRelations, additionalRelations), this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewPrimaryKey withPartitionKey(@NonNull CqlIdentifier columnName) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, this.selectors, this.whereRelations, Utils.appendSet(this.partitionKeyColumns, columnName), this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewPrimaryKey withClusteringColumn(@NonNull CqlIdentifier columnName) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, this.selectors, this.whereRelations, this.partitionKeyColumns, Utils.appendSet(this.clusteringKeyColumns, columnName), this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewStart ifNotExists() {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, true, this.baseTableKeyspace, this.baseTable, this.selectors, this.whereRelations, this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedViewSelection asSelectFrom(@NonNull CqlIdentifier table) {
        return this.asSelectFrom(null, table);
    }

    @Override
    @NonNull
    public CreateMaterializedViewSelection asSelectFrom(CqlIdentifier baseTableKeyspace, @NonNull CqlIdentifier baseTable) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, baseTableKeyspace, baseTable, this.selectors, this.whereRelations, this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedView withClusteringOrderByIds(@NonNull Map<CqlIdentifier, ClusteringOrder> orderings) {
        return this.withClusteringOrders(ImmutableCollections.concat(this.orderings, orderings));
    }

    @Override
    @NonNull
    public CreateMaterializedView withClusteringOrder(@NonNull CqlIdentifier columnName, @NonNull ClusteringOrder order) {
        return this.withClusteringOrders(ImmutableCollections.append(this.orderings, columnName, order));
    }

    @NonNull
    public CreateMaterializedView withClusteringOrders(@NonNull ImmutableMap<CqlIdentifier, ClusteringOrder> orderings) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, this.selectors, this.whereRelations, this.partitionKeyColumns, this.clusteringKeyColumns, orderings, this.options);
    }

    @Override
    @NonNull
    public CreateMaterializedView withOption(@NonNull String name, @NonNull Object value) {
        return new DefaultCreateMaterializedView(this.keyspace, this.viewName, this.ifNotExists, this.baseTableKeyspace, this.baseTable, this.selectors, this.whereRelations, this.partitionKeyColumns, this.clusteringKeyColumns, this.orderings, ImmutableCollections.append(this.options, name, value));
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("CREATE MATERIALIZED VIEW ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.viewName, builder);
        if (this.selectors.isEmpty()) {
            return builder.toString();
        }
        CqlHelper.append(this.selectors, builder, " AS SELECT ", ",", " FROM ");
        if (this.baseTable == null) {
            return builder.toString();
        }
        CqlHelper.qualify(this.baseTableKeyspace, this.baseTable, builder);
        if (this.whereRelations.isEmpty()) {
            return builder.toString();
        }
        CqlHelper.append(this.whereRelations, builder, " WHERE ", " AND ", " ");
        CqlHelper.buildPrimaryKey(this.partitionKeyColumns, this.clusteringKeyColumns, builder);
        if (!this.orderings.isEmpty() || !this.options.isEmpty()) {
            boolean firstOption = true;
            if (!this.orderings.isEmpty()) {
                builder.append(" WITH ");
                firstOption = false;
                builder.append("CLUSTERING ORDER BY (");
                boolean firstClustering = true;
                for (Map.Entry ordering : this.orderings.entrySet()) {
                    if (firstClustering) {
                        firstClustering = false;
                    } else {
                        builder.append(',');
                    }
                    builder.append(((CqlIdentifier)ordering.getKey()).asCql(true)).append(' ').append(((ClusteringOrder)ordering.getValue()).toString());
                }
                builder.append(')');
            }
            builder.append(OptionsUtils.buildOptions(this.options, firstOption));
        }
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Override
    @NonNull
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getMaterializedView() {
        return this.viewName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Nullable
    public CqlIdentifier getBaseTableKeyspace() {
        return this.baseTableKeyspace;
    }

    @Nullable
    public CqlIdentifier getBaseTable() {
        return this.baseTable;
    }

    @NonNull
    public ImmutableList<Selector> getSelectors() {
        return this.selectors;
    }

    @NonNull
    public ImmutableList<Relation> getWhereRelations() {
        return this.whereRelations;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getPartitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    @NonNull
    public ImmutableSet<CqlIdentifier> getClusteringKeyColumns() {
        return this.clusteringKeyColumns;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, ClusteringOrder> getOrderings() {
        return this.orderings;
    }
}

