/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.mailbox.tools.indexer.ReIndexerPerformer;
import org.apache.mailbox.tools.indexer.ReIndexingContext;
import org.apache.mailbox.tools.indexer.SingleMessageReindexingTaskDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SingleMessageReindexingTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleMessageReindexingTask.class);
    public static final TaskType MESSAGE_RE_INDEXING = TaskType.of((String)"message-reindexing");
    private final ReIndexerPerformer reIndexerPerformer;
    private final MailboxId mailboxId;
    private final MessageUid uid;

    @Inject
    SingleMessageReindexingTask(ReIndexerPerformer reIndexerPerformer, MailboxId mailboxId, MessageUid uid) {
        this.reIndexerPerformer = reIndexerPerformer;
        this.mailboxId = mailboxId;
        this.uid = uid;
    }

    public Task.Result run() {
        return (Task.Result)this.reIndexerPerformer.reIndexSingleMessage(this.mailboxId, this.uid, new ReIndexingContext()).onErrorResume(e -> {
            LOGGER.warn("Error encountered while reindexing {} : {}", new Object[]{this.mailboxId, this.uid, e});
            return Mono.just((Object)Task.Result.PARTIAL);
        }).block();
    }

    MailboxId getMailboxId() {
        return this.mailboxId;
    }

    MessageUid getUid() {
        return this.uid;
    }

    public TaskType type() {
        return MESSAGE_RE_INDEXING;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.mailboxId, this.uid, Clock.systemUTC().instant()));
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailboxId mailboxId;
        private final MessageUid uid;
        private final Instant timestamp;

        AdditionalInformation(MailboxId mailboxId, MessageUid uid, Instant timestamp) {
            this.mailboxId = mailboxId;
            this.uid = uid;
            this.timestamp = timestamp;
        }

        public String getMailboxId() {
            return this.mailboxId.serialize();
        }

        public long getUid() {
            return this.uid.asLong();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class Factory {
        private final ReIndexerPerformer reIndexerPerformer;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(ReIndexerPerformer reIndexerPerformer, MailboxId.Factory mailboxIdFactory) {
            this.reIndexerPerformer = reIndexerPerformer;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public SingleMessageReindexingTask create(SingleMessageReindexingTaskDTO dto) {
            MailboxId mailboxId = this.mailboxIdFactory.fromString(dto.getMailboxId());
            MessageUid uid = MessageUid.of((long)dto.getUid());
            return new SingleMessageReindexingTask(this.reIndexerPerformer, mailboxId, uid);
        }
    }
}

