/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import jakarta.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxSubscriptionListener
implements EventListener.ReactiveGroupEventListener {
    public static final Group GROUP = new MailboxSubscriptionListenerGroup();
    private final SubscriptionManager subscriptionManager;
    private final SessionProvider sessionProvider;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;

    @Inject
    public MailboxSubscriptionListener(SubscriptionManager subscriptionManager, SessionProvider sessionProvider, MailboxSessionMapperFactory mailboxSessionMapperFactory) {
        this.subscriptionManager = subscriptionManager;
        this.sessionProvider = sessionProvider;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxSubscribedEvent || event instanceof MailboxEvents.MailboxUnsubscribedEvent;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.MailboxSubscribedEvent) {
            return this.propagateSubscriptionToParentMailboxes(event);
        }
        if (event instanceof MailboxEvents.MailboxUnsubscribedEvent) {
            return this.propagateUnsubscriptionToChildrenMailboxes(event);
        }
        return Mono.empty();
    }

    private Mono<Void> propagateUnsubscriptionToChildrenMailboxes(Event event) {
        MailboxEvents.MailboxUnsubscribedEvent mailboxUnsubscribedEvent = (MailboxEvents.MailboxUnsubscribedEvent)event;
        MailboxSession mailboxSession = this.sessionProvider.createSystemSession(event.getUsername());
        MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession);
        MailboxQuery.UserBound findSubMailboxesQuery = MailboxQuery.builder().userAndNamespaceFrom(mailboxUnsubscribedEvent.getMailboxPath()).expression((MailboxNameExpression)new PrefixedWildcard(mailboxUnsubscribedEvent.getMailboxPath().getName() + mailboxSession.getPathDelimiter())).build().asUserBound();
        return mailboxMapper.findMailboxWithPathLike(findSubMailboxesQuery).flatMap(subMailbox -> this.subscriptionManager.unsubscribeReactive(subMailbox.generateAssociatedPath(), mailboxSession), 16).then();
    }

    private Mono<Void> propagateSubscriptionToParentMailboxes(Event event) {
        MailboxEvents.MailboxSubscribedEvent mailboxSubscribedEvent = (MailboxEvents.MailboxSubscribedEvent)event;
        MailboxSession mailboxSession = this.sessionProvider.createSystemSession(event.getUsername());
        return Flux.fromIterable((Iterable)mailboxSubscribedEvent.getMailboxPath().getParents(mailboxSession.getPathDelimiter())).flatMap(parentMailbox -> this.subscriptionManager.subscribeReactive(parentMailbox, mailboxSession), 16).then();
    }

    public static final class MailboxSubscriptionListenerGroup
    extends Group {
    }
}

