/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractBinaryCodec<T>
extends AbstractCodec<T>
implements ArrayCodecDelegate<T> {
    private static final Pattern BLOB_PATTERN = Pattern.compile("\\\\x([\\p{XDigit}]+)?");
    private final ByteBufAllocator byteBufAllocator;

    AbstractBinaryCodec(Class<T> type, ByteBufAllocator byteBufAllocator) {
        super(type);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public EncodedParameter encodeNull() {
        return AbstractBinaryCodec.createNull(Format.FORMAT_TEXT, PostgresqlObjectId.BYTEA);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return PostgresqlObjectId.BYTEA == type;
    }

    @Override
    EncodedParameter doEncode(T value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.doEncode(value, PostgresqlObjectId.BYTEA);
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.BYTEA_ARRAY;
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return Collections.singleton(PostgresqlObjectId.BYTEA);
    }

    byte[] decode(Format format, ByteBuf byteBuf) {
        if (format == Format.FORMAT_TEXT) {
            return AbstractBinaryCodec.decodeFromHex(byteBuf);
        }
        byte[] decoded = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(decoded);
        return decoded;
    }

    ByteBuf encodeToHex(ByteBuf value) {
        return AbstractBinaryCodec.encodeToHex(value, this.byteBufAllocator);
    }

    static ByteBuf encodeToHex(ByteBuf value, ByteBufAllocator byteBufAllocator) {
        int blobSize = value.readableBytes();
        ByteBuf buf = byteBufAllocator.buffer(2 + blobSize * 2);
        buf.writeByte(92).writeByte(120);
        int chunkSize = 1024;
        while (value.isReadable()) {
            chunkSize = Math.min(chunkSize, value.readableBytes());
            buf.writeCharSequence((CharSequence)ByteBufUtil.hexDump((ByteBuf)value, (int)value.readerIndex(), (int)chunkSize), StandardCharsets.US_ASCII);
            value.skipBytes(chunkSize);
        }
        value.release();
        return buf;
    }

    static byte[] decodeFromHex(ByteBuf byteBuf) {
        Matcher matcher = BLOB_PATTERN.matcher(ByteBufUtils.decode(byteBuf));
        if (!matcher.find()) {
            throw new IllegalStateException("ByteBuf does not contain BYTEA hex format");
        }
        String bytesHex = Objects.toString(matcher.group(1), "");
        return ByteBufUtil.decodeHexDump((CharSequence)bytesHex);
    }
}

