/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.opensearch._types.analysis.IcuNormalizationMode;
import org.opensearch.client.opensearch._types.analysis.IcuNormalizationType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IcuAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final IcuNormalizationType method;
    private final IcuNormalizationMode mode;
    public static final JsonpDeserializer<IcuAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuAnalyzer::setupIcuAnalyzerDeserializer);

    private IcuAnalyzer(Builder builder) {
        this.method = ApiTypeHelper.requireNonNull(builder.method, this, "method");
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
    }

    public static IcuAnalyzer of(Function<Builder, ObjectBuilder<IcuAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.IcuAnalyzer;
    }

    public final IcuNormalizationType method() {
        return this.method;
    }

    public final IcuNormalizationMode mode() {
        return this.mode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_analyzer");
        generator.writeKey("method");
        this.method.serialize(generator, mapper);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
    }

    protected static void setupIcuAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::method, IcuNormalizationType._DESERIALIZER, "method");
        op.add(Builder::mode, IcuNormalizationMode._DESERIALIZER, "mode");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IcuAnalyzer> {
        private IcuNormalizationType method;
        private IcuNormalizationMode mode;

        public final Builder method(IcuNormalizationType value) {
            this.method = value;
            return this;
        }

        public final Builder mode(IcuNormalizationMode value) {
            this.mode = value;
            return this;
        }

        @Override
        public IcuAnalyzer build() {
            this._checkSingleUse();
            return new IcuAnalyzer(this);
        }
    }
}

