/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.message;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.common.pojo.sort.dataflow.deserialization.DeserializationConfig;
import org.apache.inlong.common.pojo.sort.dataflow.deserialization.InlongMsgPbDeserialiationConfig;
import org.apache.inlong.common.util.Utils;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.QueryMessageRequest;
import org.apache.inlong.manager.service.datatype.DataTypeOperator;
import org.apache.inlong.manager.service.datatype.DataTypeOperatorFactory;
import org.apache.inlong.manager.service.message.DeserializeOperator;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sort.configuration.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PbMsgDeserializeOperator
implements DeserializeOperator {
    private static final Logger log = LoggerFactory.getLogger(PbMsgDeserializeOperator.class);
    @Autowired
    public DataTypeOperatorFactory dataTypeOperatorFactory;

    @Override
    public boolean accept(MessageWrapType type) {
        return MessageWrapType.INLONG_MSG_V1.equals((Object)type);
    }

    @Override
    public List<BriefMQMessage> decodeMsg(InlongStreamInfo streamInfo, List<BriefMQMessage> briefMQMessages, byte[] msgBytes, Map<String, String> headers, int index, QueryMessageRequest request) throws Exception {
        int compressType = Integer.parseInt(headers.getOrDefault("compressType", "0"));
        byte[] values = msgBytes;
        switch (compressType) {
            case 0: {
                break;
            }
            case 1: {
                values = Utils.gzipDecompress((byte[])msgBytes, (int)0, (int)msgBytes.length);
                break;
            }
            case 2: {
                values = Utils.snappyDecompress((byte[])msgBytes, (int)0, (int)msgBytes.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compress type:" + compressType);
            }
        }
        briefMQMessages.addAll(this.transformMessageObjs(ProxySdk.MessageObjs.parseFrom((byte[])values), streamInfo, index, request));
        return briefMQMessages;
    }

    private List<BriefMQMessage> transformMessageObjs(ProxySdk.MessageObjs messageObjs, InlongStreamInfo streamInfo, int index, QueryMessageRequest request) {
        if (null == messageObjs) {
            return null;
        }
        ArrayList<BriefMQMessage> messageList = new ArrayList<BriefMQMessage>();
        for (ProxySdk.MessageObj messageObj : messageObjs.getMsgsList()) {
            List mapFieldEntries = messageObj.getParamsList();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (ProxySdk.MapFieldEntry mapFieldEntry : mapFieldEntries) {
                headers.put(mapFieldEntry.getKey(), mapFieldEntry.getValue());
            }
            try {
                String body = new String(messageObj.getBody().toByteArray(), Charset.forName(streamInfo.getDataEncoding()));
                DataTypeOperator dataTypeOperator = this.dataTypeOperatorFactory.getInstance(DataTypeEnum.forType((String)streamInfo.getDataType()));
                List<BriefMQMessage.FieldInfo> streamFieldList = dataTypeOperator.parseFields(body, streamInfo);
                if (this.checkIfFilter(request, streamFieldList).booleanValue()) continue;
                BriefMQMessage message = BriefMQMessage.builder().id(Integer.valueOf(index)).inlongGroupId((String)headers.get("groupId")).inlongStreamId((String)headers.get("streamId")).dt(Long.valueOf(messageObj.getMsgTime())).clientIp((String)headers.get("clientIp")).body(body).headers(headers).fieldList(streamFieldList).build();
                messageList.add(message);
            }
            catch (Exception e) {
                String errMsg = String.format("decode msg failed for groupId=%s, streamId=%s", streamInfo.getInlongGroupId(), streamInfo.getInlongStreamId());
                log.error(errMsg, (Throwable)e);
                throw new BusinessException(errMsg);
            }
        }
        return messageList;
    }

    @Override
    public DeserializationConfig getDeserializationConfig(InlongStreamInfo streamInfo) {
        InlongMsgPbDeserialiationConfig inlongMsgPbDeserialiationConfig = new InlongMsgPbDeserialiationConfig();
        inlongMsgPbDeserialiationConfig.setCompressionType(Constants.CompressionType.GZIP.name());
        return inlongMsgPbDeserialiationConfig;
    }
}

