/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.schedule;

import java.util.List;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.schedule.ScheduleOperator;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.ScheduleOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupScheduleResourceListener
implements ScheduleOperateListener {
    private static final Logger log = LoggerFactory.getLogger(GroupScheduleResourceListener.class);
    @Autowired
    private ScheduleOperator scheduleOperator;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            log.info("not add schedule group listener, not groupResourceProcessForm for groupId [{}]", (Object)groupId);
            return false;
        }
        GroupResourceProcessForm groupProcessForm = (GroupResourceProcessForm)processForm;
        if (groupProcessForm.getGroupOperateType() != GroupOperateType.INIT) {
            log.info("not add schedule group listener, as the operate was not INIT for groupId [{}]", (Object)groupId);
            return false;
        }
        log.info("add group schedule resource listener for groupId [{}]", (Object)groupId);
        return InlongConstants.DATASYNC_OFFLINE_MODE.equals(groupProcessForm.getGroupInfo().getInlongGroupMode());
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        InlongGroupInfo groupInfo = form.getGroupInfo();
        String groupId = groupInfo.getInlongGroupId();
        log.info("begin to process schedule resource for groupId={}", (Object)groupId);
        this.scheduleOperator.handleGroupApprove(groupId);
        this.saveInfo(groupInfo, "register.schedule.status", "registered", groupInfo.getExtList());
        log.info("success to process schedule resource for group={}", (Object)groupId);
        return ListenerResult.success();
    }

    private void saveInfo(InlongGroupInfo streamInfo, String keyName, String keyValue, List<InlongGroupExtInfo> extInfoList) {
        InlongGroupExtInfo extInfo = new InlongGroupExtInfo();
        extInfo.setInlongGroupId(streamInfo.getInlongGroupId());
        extInfo.setKeyName(keyName);
        extInfo.setKeyValue(keyValue);
        extInfoList.add(extInfo);
    }
}

