/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferChunk
extends DiskRangeList {
    private static final Logger LOG = LoggerFactory.getLogger(BufferChunk.class);
    final ByteBuffer chunk;

    public BufferChunk(ByteBuffer chunk, long offset) {
        super(offset, offset + (long)chunk.remaining());
        this.chunk = chunk;
    }

    public ByteBuffer getChunk() {
        return this.chunk;
    }

    @Override
    public boolean hasData() {
        return this.chunk != null;
    }

    @Override
    public final String toString() {
        boolean makesSense = (long)this.chunk.remaining() == this.end - this.offset;
        return "data range [" + this.offset + ", " + this.end + "), size: " + this.chunk.remaining() + (makesSense ? "" : "(!)") + " type: " + (this.chunk.isDirect() ? "direct" : "array-backed");
    }

    @Override
    public DiskRange sliceAndShift(long offset, long end, long shiftBy) {
        assert (offset <= end && offset >= this.offset && end <= this.end);
        assert (offset + shiftBy >= 0L);
        ByteBuffer sliceBuf = this.chunk.slice();
        int newPos = (int)(offset - this.offset);
        int newLimit = newPos + (int)(end - offset);
        try {
            sliceBuf.position(newPos);
            sliceBuf.limit(newLimit);
        }
        catch (Throwable t2) {
            LOG.error("Failed to slice buffer chunk with range [" + this.offset + ", " + this.end + "), position: " + this.chunk.position() + " limit: " + this.chunk.limit() + ", " + (this.chunk.isDirect() ? "direct" : "array") + "; to [" + offset + ", " + end + ") " + t2.getClass());
            throw new RuntimeException(t2);
        }
        return new BufferChunk(sliceBuf, offset + shiftBy);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        BufferChunk ob = (BufferChunk)other;
        return this.chunk.equals(ob.chunk);
    }

    @Override
    public int hashCode() {
        return this.chunk.hashCode();
    }

    @Override
    public ByteBuffer getData() {
        return this.chunk;
    }
}

