/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.formats.parquet.ParquetBuilder;
import org.apache.flink.formats.parquet.ParquetBulkWriter;
import org.apache.flink.formats.parquet.StreamOutputFile;
import org.apache.parquet.hadoop.ParquetWriter;

@PublicEvolving
public class ParquetWriterFactory<T>
implements BulkWriter.Factory<T> {
    private static final long serialVersionUID = 1L;
    private final ParquetBuilder<T> writerBuilder;

    public ParquetWriterFactory(ParquetBuilder<T> writerBuilder) {
        this.writerBuilder = writerBuilder;
    }

    public BulkWriter<T> create(FSDataOutputStream stream) throws IOException {
        StreamOutputFile out = new StreamOutputFile(stream);
        ParquetWriter<T> writer = this.writerBuilder.createWriter(out);
        return new ParquetBulkWriter<T>(writer);
    }
}

