/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.OptionalInt;
import java.util.Set;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;

public class UnattachedState
implements EpochState {
    private final int epoch;
    private final Set<Integer> voters;
    private final long electionTimeoutMs;
    private final Timer electionTimer;

    public UnattachedState(Time time, int epoch, Set<Integer> voters, long electionTimeoutMs) {
        this.epoch = epoch;
        this.voters = voters;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer(electionTimeoutMs);
    }

    @Override
    public ElectionState election() {
        return new ElectionState(this.epoch, OptionalInt.empty(), OptionalInt.empty(), this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public String name() {
        return "Unattached";
    }

    public long electionTimeoutMs() {
        return this.electionTimeoutMs;
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    public String toString() {
        return "Unattached(epoch=" + this.epoch + ", voters=" + this.voters + ", electionTimeoutMs=" + this.electionTimeoutMs + ')';
    }
}

