/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot.dump;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.dump.DumpEntry;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIODecorator;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIO;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.DumpEntrySerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class Dump
implements AutoCloseable {
    private final List<SnapshotMetadata> metadata;
    private final File dumpDir;
    @Nullable
    private final String consistentId;
    private final GridKernalContext cctx;
    private final boolean keepBinary;
    private final boolean raw;
    @Nullable
    private final EncryptionSpi encSpi;
    private final ConcurrentMap<Long, ByteBuffer> thLocBufs = new ConcurrentHashMap<Long, ByteBuffer>();
    private final boolean comprParts;

    public Dump(File dumpDir, boolean keepBinary, boolean raw, IgniteLogger log) {
        this(dumpDir, null, keepBinary, raw, null, log);
    }

    public Dump(File dumpDir, @Nullable String consistentId, boolean keepBinary, boolean raw, @Nullable EncryptionSpi encSpi, IgniteLogger log) {
        A.ensure(dumpDir != null, "dump directory is null");
        A.ensure(dumpDir.exists(), "dump directory not exists");
        this.dumpDir = dumpDir;
        this.consistentId = consistentId == null ? null : U.maskForFileName(consistentId);
        this.metadata = Dump.metadata(dumpDir, this.consistentId);
        this.keepBinary = keepBinary;
        this.cctx = this.standaloneKernalContext(dumpDir, log);
        this.raw = raw;
        this.encSpi = encSpi;
        this.comprParts = this.metadata.get(0).compressPartitions();
        for (SnapshotMetadata meta : this.metadata) {
            if (meta.encryptionKey() == null || encSpi != null) continue;
            throw new IllegalArgumentException("Encryption SPI required to read encrypted dump");
        }
    }

    private GridKernalContext standaloneKernalContext(File dumpDir, IgniteLogger log) {
        File binaryMeta = CacheObjectBinaryProcessorImpl.binaryWorkDir(dumpDir.getAbsolutePath(), F.first(this.metadata).folderName());
        File marshaller = new File(dumpDir, "db/marshaller");
        A.ensure(binaryMeta.exists(), "binary metadata directory not exists");
        A.ensure(marshaller.exists(), "marshaller directory not exists");
        try {
            StandaloneGridKernalContext kctx = new StandaloneGridKernalContext(log, binaryMeta, marshaller);
            StandaloneGridKernalContext.startAllComponents(kctx);
            return kctx;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    public Iterator<BinaryType> types() {
        return this.cctx.cacheObjects().metadata().iterator();
    }

    public List<String> nodesDirectories() {
        File[] dirs = new File(this.dumpDir, "db").listFiles(f -> f.isDirectory() && !f.getAbsolutePath().endsWith("db/binary_meta") && !f.getAbsolutePath().endsWith("db/marshaller") && (this.consistentId == null || U.maskForFileName(f.getName()).contains(this.consistentId)));
        if (dirs == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(dirs).map(File::getName).collect(Collectors.toList());
    }

    public List<SnapshotMetadata> metadata() {
        return Collections.unmodifiableList(this.metadata);
    }

    private static List<SnapshotMetadata> metadata(File dumpDir, @Nullable String consistentId) {
        JdkMarshaller marsh = new JdkMarshaller();
        ClassLoader clsLdr = U.resolveClassLoader(new IgniteConfiguration());
        File[] files = dumpDir.listFiles(f -> f.getName().endsWith(".smf") && (consistentId == null || f.getName().startsWith(consistentId)));
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(meta -> {
            SnapshotMetadata snapshotMetadata;
            BufferedInputStream in = new BufferedInputStream(Files.newInputStream(meta.toPath(), new OpenOption[0]));
            try {
                snapshotMetadata = (SnapshotMetadata)marsh.unmarshal(in, clsLdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
            ((InputStream)in).close();
            return snapshotMetadata;
        }).filter(SnapshotMetadata::dump).collect(Collectors.toList());
    }

    public List<StoredCacheData> configs(String node, int grp) {
        JdkMarshaller marsh = this.cctx.marshallerContext().jdkMarshaller();
        return Arrays.stream(FilePageStoreManager.cacheDataFiles(this.dumpGroupDirectory(node, grp))).map(f -> {
            try {
                return GridLocalConfigManager.readCacheData(f, marsh, this.cctx.config());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<Integer> partitions(String node, int grp) {
        String suffix = this.comprParts ? ".dump.zip" : ".dump";
        File[] parts = this.dumpGroupDirectory(node, grp).listFiles(f -> f.getName().startsWith("part-") && f.getName().endsWith(suffix));
        if (parts == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(parts).map(partFile -> Integer.parseInt(partFile.getName().replace("part-", "").replace(suffix, ""))).collect(Collectors.toList());
    }

    public DumpedPartitionIterator iterator(String node, final int grp, final int part) {
        boolean encrypted;
        FileIO dumpFile;
        FileIOFactory ioFactory = this.comprParts ? (file, modes) -> new ReadOnlyUnzipFileIO(file) : (file, modes) -> new ReadOnlyBufferedFileIO(file);
        try {
            dumpFile = ioFactory.create(new File(this.dumpGroupDirectory(node, grp), Dump.dumpPartFileName(part, this.comprParts)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SnapshotMetadata meta = this.metadata.stream().filter(m -> Objects.equals(m.folderName(), node)).findFirst().orElseGet(null);
        boolean bl = encrypted = meta.encryptionKey() != null;
        if (encrypted && !Arrays.equals(meta.masterKeyDigest(), this.encSpi.masterKeyDigest())) {
            throw new IllegalStateException("Dump '" + meta.snapshotName() + "' has different master key digest. To restore this dump, provide the same master key.");
        }
        final DumpEntrySerializer serializer = new DumpEntrySerializer(this.thLocBufs, encrypted ? new ConcurrentHashMap<Long, ByteBuffer>() : null, encrypted ? this.encSpi.decryptKey(meta.encryptionKey()) : null, this.encSpi);
        serializer.kernalContext(this.cctx);
        serializer.keepBinary(this.keepBinary);
        serializer.raw(this.raw);
        return new DumpedPartitionIterator(){
            DumpEntry next;

            @Override
            public boolean hasNext() {
                this.advance();
                return this.next != null;
            }

            @Override
            public DumpEntry next() {
                this.advance();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                DumpEntry next0 = this.next;
                this.next = null;
                return next0;
            }

            private void advance() {
                if (this.next != null) {
                    return;
                }
                try {
                    this.next = serializer.read(dumpFile, grp, part);
                }
                catch (IOException | IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }

            @Override
            public void close() {
                U.closeQuiet(dumpFile);
            }
        };
    }

    public static String dumpPartFileName(int part, boolean compressed) {
        return "part-" + part + ".dump" + (compressed ? ".zip" : "");
    }

    public File dumpDirectory() {
        return this.dumpDir;
    }

    private File dumpGroupDirectory(String node, int grpId) {
        File nodeDir = Paths.get(this.dumpDir.getAbsolutePath(), "db", node).toFile();
        assert (nodeDir.exists() && nodeDir.isDirectory());
        File[] grpDirs = nodeDir.listFiles(f -> {
            if (!f.isDirectory() || !f.getName().startsWith("cache-") && !f.getName().startsWith("cacheGroup-")) {
                return false;
            }
            String grpName = f.getName().startsWith("cache-") ? f.getName().replaceFirst("cache-", "") : f.getName().replaceFirst("cacheGroup-", "");
            return grpId == CU.cacheId(grpName);
        });
        if (grpDirs.length != 1) {
            throw new IgniteException("Wrong number of group directories: " + grpDirs.length);
        }
        return grpDirs[0];
    }

    public GridKernalContext context() {
        return this.cctx;
    }

    @Override
    public void close() throws Exception {
        StandaloneGridKernalContext.closeAllComponents(this.cctx);
        if (this.encSpi != null) {
            this.encSpi.spiStop();
        }
    }

    private static class ReadOnlyUnzipFileIO
    extends ReadOnlyBufferedFileIO {
        private final ZipInputStream zis = new ZipInputStream(new InputStream(){

            @Override
            public int read(byte[] arr, int off, int len) throws IOException {
                return ReadOnlyUnzipFileIO.super.readFully(ByteBuffer.wrap(arr, off, len));
            }

            @Override
            public int read() throws IOException {
                throw new IOException();
            }
        });

        ReadOnlyUnzipFileIO(File file) throws IOException {
            super(file);
            this.zis.getNextEntry();
        }

        @Override
        public int readFully(ByteBuffer dst) throws IOException {
            int bytesRead;
            int totalRead = 0;
            while (dst.hasRemaining() && (bytesRead = this.zis.read(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining())) != -1) {
                dst.position(dst.position() + bytesRead);
                totalRead += bytesRead;
            }
            return totalRead;
        }

        @Override
        public void close() throws IOException {
            this.zis.close();
        }
    }

    private static class ReadOnlyBufferedFileIO
    extends FileIODecorator {
        private static final int DEFAULT_BLOCK_SIZE = 4096;
        private final ByteBuffer buf;
        private long pos;

        ReadOnlyBufferedFileIO(File file) throws IOException {
            super(new RandomAccessFileIO(file, StandardOpenOption.READ));
            int blockSize = this.getFileSystemBlockSize();
            if (blockSize <= 0) {
                blockSize = 4096;
            }
            this.buf = ByteBuffer.allocateDirect(blockSize);
            this.buf.position(this.buf.limit());
        }

        @Override
        public int readFully(ByteBuffer dst) throws IOException {
            int totalRead = 0;
            while (dst.hasRemaining()) {
                if (!this.buf.hasRemaining()) {
                    if (this.buf.limit() < this.buf.capacity()) break;
                    this.buf.clear();
                    this.pos += (long)this.delegate.readFully(this.buf, this.pos);
                    this.buf.flip();
                }
                int len = Math.min(this.buf.remaining(), dst.remaining());
                int limit = this.buf.limit();
                this.buf.limit(this.buf.position() + len);
                dst.put(this.buf);
                this.buf.limit(limit);
                totalRead += len;
            }
            return totalRead;
        }
    }

    public static interface DumpedPartitionIterator
    extends Iterator<DumpEntry>,
    AutoCloseable {
    }
}

