/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.management.cache.CacheFilterEnum;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheIdleVerifyCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(optional=true, example="cacheName1,...,cacheNameN")
    private String[] caches;
    @Argument(optional=true)
    private boolean skipZeros;
    @Argument(description="check the CRC-sum of pages stored on disk before verifying data consistency in partitions between primary and backup nodes", optional=true)
    private boolean checkCrc;
    @Argument(optional=true, example="cacheName1,...,cacheNameN")
    private String[] excludeCaches;
    @Argument(optional=true, description="Type of cache(s)")
    @EnumDescription(names={"DEFAULT", "SYSTEM", "PERSISTENT", "NOT_PERSISTENT", "USER", "ALL"}, descriptions={"Default - user only, or all caches specified by name", "System", "Persistent", "Not persistent", "User", "All"})
    private CacheFilterEnum cacheFilter = CacheFilterEnum.DEFAULT;

    private void validateRegexes(String[] string) {
        for (String s : string) {
            try {
                Pattern.compile(s);
            }
            catch (PatternSyntaxException e) {
                throw new IgniteException(String.format("Invalid cache name regexp '%s': %s", s, e.getMessage()));
            }
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeArray(out, this.caches);
        out.writeBoolean(this.skipZeros);
        out.writeBoolean(this.checkCrc);
        U.writeArray(out, this.excludeCaches);
        U.writeEnum(out, this.cacheFilter);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.caches = U.readArray(in, String.class);
        this.skipZeros = in.readBoolean();
        this.checkCrc = in.readBoolean();
        this.excludeCaches = U.readArray(in, String.class);
        this.cacheFilter = U.readEnum(in, CacheFilterEnum.class);
    }

    public String[] caches() {
        return this.caches;
    }

    public void caches(String[] caches) {
        this.caches = caches;
    }

    public boolean skipZeros() {
        return this.skipZeros;
    }

    public void skipZeros(boolean skipZeros) {
        this.skipZeros = skipZeros;
    }

    public String[] excludeCaches() {
        return this.excludeCaches;
    }

    public void excludeCaches(String[] excludeCaches) {
        this.excludeCaches = excludeCaches;
        this.validateRegexes(excludeCaches);
    }

    public boolean checkCrc() {
        return this.checkCrc;
    }

    public void checkCrc(boolean checkCrc) {
        this.checkCrc = checkCrc;
    }

    public CacheFilterEnum cacheFilter() {
        return this.cacheFilter;
    }

    public void cacheFilter(CacheFilterEnum cacheFilter) {
        this.cacheFilter = cacheFilter;
    }
}

