/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class MapSqlType
extends AbstractSqlType {
    private final RelDataType keyType;
    private final RelDataType valueType;

    public MapSqlType(RelDataType keyType, RelDataType valueType, boolean isNullable) {
        super(SqlTypeName.MAP, isNullable, null);
        this.keyType = Objects.requireNonNull(keyType, "keyType");
        this.valueType = Objects.requireNonNull(valueType, "valueType");
        this.computeDigest();
    }

    @Override
    public RelDataType getValueType() {
        return this.valueType;
    }

    @Override
    public RelDataType getKeyType() {
        return this.keyType;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("(").append(withDetail ? this.keyType.getFullTypeString() : this.keyType.toString()).append(", ").append(withDetail ? this.valueType.getFullTypeString() : this.valueType.toString()).append(") MAP");
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }
}

