/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;

class LockTableConstantAction
implements ConstantAction {
    private final String fullTableName;
    private final long conglomerateNumber;
    private final boolean exclusiveMode;

    LockTableConstantAction(String string, long l, boolean bl) {
        this.fullTableName = string;
        this.conglomerateNumber = l;
        this.exclusiveMode = bl;
    }

    public String toString() {
        return "LOCK TABLE " + this.fullTableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TransactionController transactionController = activation.getTransactionController();
        try {
            ConglomerateController conglomerateController = transactionController.openConglomerate(this.conglomerateNumber, false, this.exclusiveMode ? 68 : 64, 7, 5);
            conglomerateController.close();
        }
        catch (StandardException standardException) {
            StandardException standardException2;
            String string = standardException.getMessageId();
            if (standardException.isLockTimeoutOrDeadlock()) {
                String string2 = this.exclusiveMode ? "EXCLUSIVE" : "SHARE";
                standardException2 = StandardException.newException("X0X02.S", standardException, this.fullTableName, string2);
            }
            throw standardException2;
        }
    }
}

