/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.AbortCompactResponse;
import org.apache.hadoop.hive.metastore.api.AbortCompactionRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdRequest;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchCompactionException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.SeedTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.SeedTxnIdRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.DefaultTxnLockManager;
import org.apache.hadoop.hive.metastore.txn.TransactionalRetryProxy;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnLockManager;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnStoreMutex;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionState;
import org.apache.hadoop.hive.metastore.txn.entities.LockInfo;
import org.apache.hadoop.hive.metastore.txn.entities.MetricsInfo;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.entities.TxnWriteDetails;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.NoPoolConnectionPool;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.AddWriteIdsToMinHistoryCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.DeleteInvalidOpenTxnsCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.InsertCompactionRequestCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.InsertTxnComponentsCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveTxnsFromMinHistoryLevelCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortCompactionFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AllocateTableWriteIdsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.CleanupRecordsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.CommitTxnFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.CompactFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.EnsureValidTxnFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GenerateCompactionQueueIdFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GetMaterializationInvalidationInfoFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.GetValidWriteIdsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.HeartbeatLockFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.HeartbeatTxnFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.HeartbeatTxnRangeFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.LockMaterializationRebuildFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.MinOpenTxnIdWaterMarkFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.OnRenameFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.OpenTxnsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.PerformTimeoutsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.ReleaseMaterializationRebuildLocks;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.ReplTableWriteIdStateFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.CountOpenTxnsHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetHighWaterMarkHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetLatestCommittedCompactionInfoHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetLocksByLockId;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetMaxAllocatedTableWriteIdHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetOpenTxnTypeAndLockHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetOpenTxnsListHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetTargetTxnIdListForPolicyHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetTxnDbsUpdatedHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetWriteIdsForTxnIDHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.LatestTxnIdInConflictHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.MetricsInfoHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.ShowCompactHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.TablesWithAbortedTxnsHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.TargetTxnIdListHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.TxnIdForWriteIdHandler;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryCallProperties;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryException;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryHandler;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class TxnHandler
implements TxnStore,
TxnStore.MutexAPI {
    private static final Logger LOG = LoggerFactory.getLogger((String)TxnHandler.class.getName());
    public static final ConfVars ConfVars = new ConfVars();
    private static volatile int maxOpenTxns = 0;
    private static volatile boolean tooManyOpenTxns = false;
    private static AtomicInteger numOpenTxns;
    private static volatile boolean initialized;
    private static DataSource connPool;
    private static DataSource connPoolMutex;
    protected static DataSource connPoolCompactor;
    protected static DatabaseProduct dbProduct;
    protected static SQLGenerator sqlGenerator;
    protected static long openTxnTimeOutMillis;
    protected Configuration conf;
    protected List<TransactionalMetaStoreEventListener> transactionalListeners;
    private long timeout;
    private long replicationTxnTimeout;
    private TxnStore.MutexAPI mutexAPI;
    private TxnLockManager txnLockManager;
    private SqlRetryHandler sqlRetryHandler;
    protected MultiDataSourceJdbcResource jdbcResource;
    private static final String hostname;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setConf(Configuration conf) {
        String msg;
        this.conf = conf;
        if (!initialized) {
            Class<TxnHandler> clazz = TxnHandler.class;
            // MONITORENTER : org.apache.hadoop.hive.metastore.txn.TxnHandler.class
            if (!initialized) {
                try (DataSourceProvider.DataSourceNameConfigurator configurator = new DataSourceProvider.DataSourceNameConfigurator(conf, "txnhandler");){
                    int maxPoolSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS);
                    if (connPool == null) {
                        connPool = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize);
                    }
                    if (connPoolMutex == null) {
                        configurator.resetName("mutex");
                        connPoolMutex = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize);
                    }
                    if (connPoolCompactor == null) {
                        configurator.resetName("compactor");
                        connPoolCompactor = TxnHandler.setupJdbcConnectionPool(conf, MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CONNECTION_POOLING_MAX_CONNECTIONS));
                    }
                }
                if (dbProduct == null && (dbProduct = DatabaseProduct.determineDatabaseProduct(connPool, conf)).isUNDEFINED()) {
                    msg = "Unrecognized database product name <" + dbProduct.getProductName() + ">";
                    throw new IllegalStateException(msg);
                }
                if (sqlGenerator == null) {
                    sqlGenerator = new SQLGenerator(dbProduct, conf);
                }
                this.initJdbcResource();
                try {
                    ConfVars.init(this::checkIfTableIsUsable, conf);
                }
                catch (Exception e) {
                    String msg2 = "Error during TxnHandler initialization, " + e.getMessage();
                    LOG.error(msg2);
                    throw e;
                }
                initialized = true;
            }
            // MONITOREXIT : clazz
        }
        this.initJdbcResource();
        this.mutexAPI = new TxnStoreMutex(sqlGenerator, this.jdbcResource);
        numOpenTxns = Metrics.getOrCreateGauge("num_open_transactions");
        this.timeout = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        this.replicationTxnTimeout = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.REPL_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        maxOpenTxns = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MAX_OPEN_TXNS);
        openTxnTimeOutMillis = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_OPENTXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            this.transactionalListeners = MetaStoreServerUtils.getMetaStoreListeners(TransactionalMetaStoreEventListener.class, conf, MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS));
        }
        catch (MetaException e) {
            msg = "Unable to get transaction listeners, " + e.getMessage();
            LOG.error(msg);
            throw new RuntimeException(e);
        }
        this.sqlRetryHandler = new SqlRetryHandler(conf, this.jdbcResource.getDatabaseProduct());
        this.txnLockManager = TransactionalRetryProxy.getProxy(this.sqlRetryHandler, this.jdbcResource, new DefaultTxnLockManager(this.jdbcResource));
    }

    @Override
    public SqlRetryHandler getRetryHandler() {
        return this.sqlRetryHandler;
    }

    @Override
    public MultiDataSourceJdbcResource getJdbcResourceHolder() {
        return this.jdbcResource;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException {
        return this.jdbcResource.execute(new GetOpenTxnsListHandler(true, openTxnTimeOutMillis)).toOpenTxnsInfoResponse();
    }

    @Override
    public GetOpenTxnsResponse getOpenTxns() throws MetaException {
        return this.jdbcResource.execute(new GetOpenTxnsListHandler(false, openTxnTimeOutMillis)).toOpenTxnsResponse(Collections.singletonList(TxnType.READ_ONLY));
    }

    @Override
    public GetOpenTxnsResponse getOpenTxns(List<TxnType> excludeTxnTypes) throws MetaException {
        return this.jdbcResource.execute(new GetOpenTxnsListHandler(false, openTxnTimeOutMillis)).toOpenTxnsResponse(excludeTxnTypes);
    }

    @Override
    public List<Long> getOpenTxnForPolicy(List<Long> openTxnList, String replPolicy) {
        if (openTxnList.isEmpty()) {
            return Collections.emptyList();
        }
        List<Long> targetTxnIds = null;
        try {
            targetTxnIds = this.jdbcResource.execute(new GetTargetTxnIdListForPolicyHandler(replPolicy, openTxnList));
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
        if (targetTxnIds.isEmpty()) {
            LOG.info("There are no Repl Created open transactions on DR side.");
        }
        return targetTxnIds;
    }

    @Override
    public OpenTxnsResponse openTxns(OpenTxnRequest rqst) throws MetaException {
        TxnType txnType;
        int numTxns;
        if (!tooManyOpenTxns && numOpenTxns.get() >= maxOpenTxns) {
            tooManyOpenTxns = true;
        }
        if (tooManyOpenTxns) {
            if ((double)numOpenTxns.get() < (double)maxOpenTxns * 0.9) {
                tooManyOpenTxns = false;
            } else {
                LOG.warn("Maximum allowed number of open transactions ({}) has been reached. Current number of open transactions: {}", (Object)maxOpenTxns, (Object)numOpenTxns);
                throw new MetaException("Maximum allowed number of open transactions has been reached. See hive.max.open.txns.");
            }
        }
        if ((numTxns = rqst.getNum_txns()) <= 0) {
            throw new MetaException("Invalid input for number of txns: " + numTxns);
        }
        this.acquireTxnLock(true);
        StopWatch generateTransactionWatch = new StopWatch();
        generateTransactionWatch.start();
        Object txnIds = new OpenTxnsFunction(rqst, openTxnTimeOutMillis, this.transactionalListeners).execute(this.jdbcResource);
        LOG.debug("Going to commit");
        this.jdbcResource.getTransactionManager().getActiveTransaction().createSavepoint();
        generateTransactionWatch.stop();
        long elapsedMillis = generateTransactionWatch.getTime(TimeUnit.MILLISECONDS);
        TxnType txnType2 = txnType = rqst.isSetTxn_type() ? rqst.getTxn_type() : TxnType.DEFAULT;
        if (txnType != TxnType.READ_ONLY && elapsedMillis >= openTxnTimeOutMillis) {
            LOG.error("OpenTxnTimeOut exceeded commit duration {}, deleting transactionIds: {}", (Object)elapsedMillis, txnIds);
            if (!txnIds.isEmpty()) {
                this.deleteInvalidOpenTransactions((List<Long>)txnIds);
            }
            throw new SqlRetryException("OpenTxnTimeOut exceeded");
        }
        return new OpenTxnsResponse((List)txnIds);
    }

    @Override
    public long getOpenTxnTimeOutMillis() {
        return openTxnTimeOutMillis;
    }

    @Override
    public void setOpenTxnTimeOutMillis(long openTxnTimeOutMillis) {
        TxnHandler.openTxnTimeOutMillis = openTxnTimeOutMillis;
    }

    @Override
    public long getTargetTxnId(String replPolicy, long sourceTxnId) throws MetaException {
        List<Long> targetTxnIds = this.jdbcResource.execute(new TargetTxnIdListHandler(replPolicy, Collections.singletonList(sourceTxnId)));
        if (targetTxnIds.isEmpty()) {
            LOG.info("Txn {} not present for repl policy {}", (Object)sourceTxnId, (Object)replPolicy);
            return -1L;
        }
        assert (targetTxnIds.size() == 1);
        return targetTxnIds.get(0);
    }

    @Override
    public void abortTxn(AbortTxnRequest rqst) throws NoSuchTxnException, MetaException, TxnAbortedException {
        TxnType txnType;
        ArrayList<TxnWriteDetails> txnWriteDetails = new ArrayList();
        if (this.transactionalListeners != null) {
            txnWriteDetails = this.getWriteIdsForTxnID(rqst.getTxnid());
        }
        if (!((txnType = new AbortTxnFunction(rqst).execute(this.jdbcResource)) == null || this.transactionalListeners == null || rqst.isSetReplPolicy() && TxnType.DEFAULT.equals((Object)rqst.getTxn_type()))) {
            TxnHandler.notifyCommitOrAbortEvent(rqst.getTxnid(), EventMessage.EventType.ABORT_TXN, txnType, this.jdbcResource.getConnection(), txnWriteDetails, this.transactionalListeners);
        }
    }

    public static void notifyCommitOrAbortEvent(long txnId, EventMessage.EventType eventType, TxnType txnType, Connection dbConn, List<TxnWriteDetails> txnWriteDetails, List<TransactionalMetaStoreEventListener> transactionalListeners) throws MetaException {
        List<Long> writeIds = txnWriteDetails.stream().map(TxnWriteDetails::getWriteId).collect(Collectors.toList());
        List<String> databases = txnWriteDetails.stream().map(TxnWriteDetails::getDbName).collect(Collectors.toList());
        ListenerEvent txnEvent = eventType.equals((Object)EventMessage.EventType.ABORT_TXN) ? new AbortTxnEvent(txnId, txnType, null, databases, writeIds) : new CommitTxnEvent(txnId, txnType, null, databases, writeIds);
        MetaStoreListenerNotifier.notifyEventWithDirectSql(transactionalListeners, eventType, txnEvent, dbConn, sqlGenerator);
    }

    @Override
    public void abortTxns(AbortTxnsRequest rqst) throws MetaException {
        List txnIds = rqst.getTxn_ids();
        TxnErrorMsg txnErrorMsg = TxnErrorMsg.NONE;
        if (rqst.isSetErrorCode()) {
            txnErrorMsg = TxnErrorMsg.getTxnErrorMsg(rqst.getErrorCode());
        }
        HashMap<Long, List<TxnWriteDetails>> txnWriteDetailsMap = new HashMap<Long, List<TxnWriteDetails>>();
        if (this.transactionalListeners != null) {
            for (Long txnId : txnIds) {
                txnWriteDetailsMap.put(txnId, this.getWriteIdsForTxnID(txnId));
            }
        }
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder("SELECT \"TXN_ID\", \"TXN_TYPE\" from \"TXNS\" where \"TXN_STATE\" = ").append((Object)TxnStatus.OPEN).append(" and \"TXN_TYPE\" != ").append(TxnType.READ_ONLY.getValue()).append(" and ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
        Connection dbConn = this.jdbcResource.getConnection();
        try {
            HashMap<Long, TxnType> nonReadOnlyTxns = new HashMap<Long, TxnType>();
            for (String query : queries) {
                LOG.debug("Going to execute query <{}>", (Object)query);
                Statement stmt = dbConn.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));
                    try {
                        while (rs.next()) {
                            TxnType txnType = TxnType.findByValue((int)rs.getInt(2));
                            nonReadOnlyTxns.put(rs.getLong(1), txnType);
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            int numAborted = new AbortTxnsFunction(txnIds, false, false, false, txnErrorMsg).execute(this.jdbcResource);
            if (numAborted != txnIds.size()) {
                LOG.warn("Abort Transactions command only aborted {} out of {} transactions. It's possible that the other {} transactions have been aborted or committed, or the transaction ids are invalid.", new Object[]{numAborted, txnIds.size(), txnIds.size() - numAborted});
            }
            if (this.transactionalListeners != null) {
                for (Long txnId : txnIds) {
                    TxnHandler.notifyCommitOrAbortEvent(txnId, EventMessage.EventType.ABORT_TXN, nonReadOnlyTxns.getOrDefault(txnId, TxnType.READ_ONLY), dbConn, (List)txnWriteDetailsMap.get(txnId), this.transactionalListeners);
                }
            }
        }
        catch (SQLException e) {
            throw new UncategorizedSQLException(null, null, e);
        }
    }

    @Override
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        new CommitTxnFunction(rqst, this.transactionalListeners).execute(this.jdbcResource);
    }

    @Override
    public long getLatestTxnIdInConflict(long txnid) throws MetaException {
        return this.jdbcResource.execute(new LatestTxnIdInConflictHandler(txnid));
    }

    @Override
    public void replTableWriteIdState(ReplTblWriteIdStateRequest rqst) throws MetaException {
        new ReplTableWriteIdStateFunction(rqst, this.mutexAPI, this.transactionalListeners).execute(this.jdbcResource);
    }

    @Override
    public GetValidWriteIdsResponse getValidWriteIds(GetValidWriteIdsRequest rqst) throws MetaException {
        return new GetValidWriteIdsFunction(rqst, openTxnTimeOutMillis).execute(this.jdbcResource);
    }

    @Override
    public AllocateTableWriteIdsResponse allocateTableWriteIds(AllocateTableWriteIdsRequest rqst) throws MetaException {
        return new AllocateTableWriteIdsFunction(rqst, this.transactionalListeners).execute(this.jdbcResource);
    }

    @Override
    public MaxAllocatedTableWriteIdResponse getMaxAllocatedTableWrited(MaxAllocatedTableWriteIdRequest rqst) throws MetaException {
        return this.jdbcResource.execute(new GetMaxAllocatedTableWriteIdHandler(rqst));
    }

    @Override
    public void seedWriteId(SeedTableWriteIdsRequest rqst) throws MetaException {
        this.jdbcResource.getJdbcTemplate().update("INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (:db, :table, :writeId)", (SqlParameterSource)new MapSqlParameterSource().addValue("db", (Object)rqst.getDbName()).addValue("table", (Object)rqst.getTableName()).addValue("writeId", (Object)(rqst.getSeedWriteId() + 1L)));
    }

    @Override
    public void seedTxnId(SeedTxnIdRequest rqst) throws MetaException {
        this.acquireTxnLock(false);
        long highWaterMark = this.jdbcResource.execute(new GetHighWaterMarkHandler());
        if (highWaterMark >= rqst.getSeedTxnId()) {
            throw new MetaException(MessageFormat.format("Invalid txnId seed {}, the highWaterMark is {}", rqst.getSeedTxnId(), highWaterMark));
        }
        this.jdbcResource.getJdbcTemplate().getJdbcTemplate().execute(stmt -> stmt.execute(dbProduct.getTxnSeedFn(rqst.getSeedTxnId())));
    }

    @Override
    public void addWriteNotificationLog(ListenerEvent acidWriteEvent) throws MetaException {
        MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, acidWriteEvent instanceof AcidWriteEvent ? EventMessage.EventType.ACID_WRITE : EventMessage.EventType.BATCH_ACID_WRITE, acidWriteEvent, this.jdbcResource.getConnection(), sqlGenerator);
    }

    @Override
    public void performWriteSetGC() throws MetaException {
        long commitHighWaterMark = new MinOpenTxnIdWaterMarkFunction(openTxnTimeOutMillis).execute(this.jdbcResource);
        this.jdbcResource.getJdbcTemplate().update("DELETE FROM \"WRITE_SET\" WHERE \"WS_COMMIT_ID\" < :hwm", (SqlParameterSource)new MapSqlParameterSource().addValue("hwm", (Object)commitHighWaterMark));
    }

    @Override
    public void updateTransactionStatistics(UpdateTransactionalStatsRequest req) throws MetaException {
        this.jdbcResource.execute("UPDATE \"MV_TABLES_USED\" SET \"INSERTED_COUNT\"=\"INSERTED_COUNT\"+ :insertCount,\"UPDATED_COUNT\"=\"UPDATED_COUNT\"+ :updateCount,\"DELETED_COUNT\"=\"DELETED_COUNT\"+ :deleteCount WHERE \"TBL_ID\"= :tableId", (SqlParameterSource)new MapSqlParameterSource().addValue("insertCount", (Object)req.getInsertCount()).addValue("updateCount", (Object)req.getUpdatedCount()).addValue("deleteCount", (Object)req.getDeletedCount()).addValue("tableId", (Object)req.getTableId()), null);
    }

    @Override
    public Materialization getMaterializationInvalidationInfo(CreationMetadata creationMetadata, String validTxnListStr) throws MetaException {
        return new GetMaterializationInvalidationInfoFunction(creationMetadata, validTxnListStr).execute(this.jdbcResource);
    }

    @Override
    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        return new LockMaterializationRebuildFunction(dbName, tableName, txnId, this.mutexAPI).execute(this.jdbcResource);
    }

    @Override
    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        int result = this.jdbcResource.execute("UPDATE \"MATERIALIZATION_REBUILD_LOCKS\" SET \"MRL_LAST_HEARTBEAT\" = :lastHeartbeat WHERE \"MRL_TXN_ID\" = :txnId AND \"MRL_DB_NAME\" = :dbName AND \"MRL_TBL_NAME\" = :tblName", (SqlParameterSource)new MapSqlParameterSource().addValue("lastHeartbeat", (Object)Instant.now().toEpochMilli()).addValue("txnId", (Object)txnId).addValue("dbName", (Object)dbName).addValue("tblName", (Object)tableName), ParameterizedCommand.AT_LEAST_ONE_ROW);
        return result >= 1;
    }

    @Override
    public long cleanupMaterializationRebuildLocks(ValidTxnList validTxnList, long timeout) throws MetaException {
        return new ReleaseMaterializationRebuildLocks(validTxnList, timeout).execute(this.jdbcResource);
    }

    @Override
    public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        long lockId = this.txnLockManager.enqueueLock(rqst);
        try {
            return this.txnLockManager.checkLock(lockId, rqst.getTxnid(), rqst.isZeroWaitReadEnabled(), rqst.isExclusiveCTAS());
        }
        catch (NoSuchLockException e) {
            throw new MetaException("Couldn't find a lock we just created! " + e.getMessage());
        }
    }

    @Override
    public LockResponse checkLock(CheckLockRequest rqst) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        long extLockId = rqst.getLockid();
        List<LockInfo> lockInfos = this.jdbcResource.execute(new GetLocksByLockId(extLockId, 1, sqlGenerator));
        if (CollectionUtils.isEmpty(lockInfos)) {
            throw new NoSuchLockException("No such lock " + JavaUtils.lockIdToString((long)extLockId));
        }
        LockInfo lockInfo = lockInfos.get(0);
        if (lockInfo.getTxnId() > 0L) {
            new HeartbeatTxnFunction(lockInfo.getTxnId()).execute(this.jdbcResource);
        } else {
            new HeartbeatLockFunction(rqst.getLockid()).execute(this.jdbcResource);
        }
        return this.txnLockManager.checkLock(extLockId, lockInfo.getTxnId(), false, false);
    }

    @Override
    public void unlock(UnlockRequest rqst) throws TxnOpenException, MetaException {
        this.txnLockManager.unlock(rqst);
    }

    @Override
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        return this.txnLockManager.showLocks(rqst);
    }

    @Override
    public void heartbeat(HeartbeatRequest ids) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        new HeartbeatTxnFunction(ids.getTxnid()).execute(this.jdbcResource);
        new HeartbeatLockFunction(ids.getLockid()).execute(this.jdbcResource);
    }

    @Override
    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest rqst) throws MetaException {
        return new HeartbeatTxnRangeFunction(rqst).execute(this.jdbcResource);
    }

    @Override
    public long getTxnIdForWriteId(String dbName, String tblName, long writeId) throws MetaException {
        return this.jdbcResource.execute(new TxnIdForWriteIdHandler(writeId, dbName, tblName));
    }

    @Override
    public CompactionResponse compact(CompactionRequest rqst) throws MetaException {
        return new CompactFunction(rqst, openTxnTimeOutMillis, this.getMutexAPI()).execute(this.jdbcResource);
    }

    @Override
    public boolean submitForCleanup(CompactionRequest rqst, long highestWriteId, long txnId) throws MetaException {
        long id = new GenerateCompactionQueueIdFunction().execute(this.jdbcResource);
        this.jdbcResource.execute(new InsertCompactionRequestCommand(id, CompactionState.READY_FOR_CLEANING, rqst).withTxnDetails(highestWriteId, txnId));
        return true;
    }

    @Override
    public ShowCompactResponse showCompact(ShowCompactRequest rqst) throws MetaException {
        return this.jdbcResource.execute(new ShowCompactHandler(rqst, sqlGenerator));
    }

    @Override
    public GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfo(GetLatestCommittedCompactionInfoRequest rqst) throws MetaException {
        return this.jdbcResource.execute(new GetLatestCommittedCompactionInfoHandler(rqst));
    }

    @Override
    public MetricsInfo getMetricsInfo() throws MetaException {
        int threshold = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_TABLES_WITH_ABORTED_TXNS_THRESHOLD);
        MetricsInfo metrics = this.jdbcResource.execute(MetricsInfoHandler.INSTANCE);
        Set<String> resourceNames = this.jdbcResource.execute(new TablesWithAbortedTxnsHandler(threshold));
        metrics.setTablesWithXAbortedTxnsCount(resourceNames.size());
        metrics.setTablesWithXAbortedTxns(resourceNames);
        return metrics;
    }

    @Override
    public void addDynamicPartitions(AddDynamicPartitions rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        TxnType txnType = this.jdbcResource.execute(new GetOpenTxnTypeAndLockHandler(sqlGenerator, rqst.getTxnid()));
        if (txnType == null) {
            new EnsureValidTxnFunction(rqst.getTxnid()).execute(this.jdbcResource);
            TxnHandler.shouldNeverHappen(rqst.getTxnid());
        }
        this.jdbcResource.execute(new InsertTxnComponentsCommand(rqst));
        this.jdbcResource.getJdbcTemplate().update("DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = :txnId AND \"TC_DATABASE\" = :dbName AND \"TC_TABLE\" = :tableName AND \"TC_PARTITION\" IS NULL", (SqlParameterSource)new MapSqlParameterSource().addValue("txnId", (Object)rqst.getTxnid()).addValue("dbName", (Object)org.apache.commons.lang3.StringUtils.lowerCase((String)rqst.getDbname())).addValue("tableName", (Object)org.apache.commons.lang3.StringUtils.lowerCase((String)rqst.getTablename())));
    }

    @Override
    public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator, boolean keepTxnToWriteIdMetaData) throws MetaException {
        new CleanupRecordsFunction(type, db, table, partitionIterator, MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), keepTxnToWriteIdMetaData, null).execute(this.jdbcResource);
    }

    @Override
    public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator, long txnId) throws MetaException {
        new CleanupRecordsFunction(type, db, table, partitionIterator, MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), false, txnId).execute(this.jdbcResource);
    }

    @Override
    public void onRename(String oldCatName, String oldDbName, String oldTabName, String oldPartName, String newCatName, String newDbName, String newTabName, String newPartName) throws MetaException {
        new OnRenameFunction(oldCatName, oldDbName, oldTabName, oldPartName, newCatName, newDbName, newTabName, newPartName).execute(this.jdbcResource);
    }

    @Override
    @VisibleForTesting
    public int getNumLocks() {
        return Objects.requireNonNull((Integer)this.jdbcResource.getJdbcTemplate().queryForObject("SELECT COUNT(*) FROM \"HIVE_LOCKS\"", (SqlParameterSource)new MapSqlParameterSource(), Integer.TYPE), "This never should be null, it's just to suppress warnings");
    }

    @Override
    @VisibleForTesting
    public long setTimeout(long milliseconds) {
        long previous_timeout = this.timeout;
        this.timeout = milliseconds;
        return previous_timeout;
    }

    protected Connection getDbConn(int isolationLevel, DataSource connPool) throws SQLException {
        Connection dbConn = null;
        try {
            dbConn = connPool.getConnection();
            dbConn.setAutoCommit(false);
            dbConn.setTransactionIsolation(isolationLevel);
            return dbConn;
        }
        catch (SQLException e) {
            if (dbConn != null) {
                dbConn.close();
            }
            throw e;
        }
    }

    @Override
    public void performTimeOuts() {
        new PerformTimeoutsFunction(this.timeout, this.replicationTxnTimeout, this.transactionalListeners).execute(this.jdbcResource);
    }

    @Override
    public void countOpenTxns() throws MetaException {
        int openTxns = this.jdbcResource.execute(new CountOpenTxnsHandler());
        if (openTxns > -1) {
            numOpenTxns.set(openTxns);
        }
    }

    @Override
    public void addWriteIdsToMinHistory(long txnid, Map<String, Long> minOpenWriteIds) throws MetaException {
        this.jdbcResource.execute(new AddWriteIdsToMinHistoryCommand(txnid, minOpenWriteIds));
    }

    protected static synchronized DataSource setupJdbcConnectionPool(Configuration conf, int maxPoolSize) {
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull(conf);
        if (dsp != null) {
            try {
                return dsp.create(conf, maxPoolSize);
            }
            catch (SQLException e) {
                LOG.error("Unable to instantiate JDBC connection pooling", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        String connectionPooler = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE).toLowerCase();
        if ("none".equals(connectionPooler)) {
            LOG.info("Choosing not to pool JDBC connections");
            return new NoPoolConnectionPool(conf, dbProduct);
        }
        throw new RuntimeException("Unknown JDBC connection pooling " + connectionPooler);
    }

    @Override
    public TxnStore.MutexAPI getMutexAPI() {
        return this.mutexAPI;
    }

    @Override
    public TxnStore.MutexAPI.LockHandle acquireLock(String key) throws MetaException {
        return this.mutexAPI.acquireLock(key);
    }

    @Override
    public void acquireLock(String key, TxnStore.MutexAPI.LockHandle handle) throws MetaException {
        this.mutexAPI.acquireLock(key, handle);
    }

    @Override
    public AbortCompactResponse abortCompactions(AbortCompactionRequest reqst) throws MetaException, NoSuchCompactionException {
        if (reqst.getCompactionIds().isEmpty()) {
            LOG.info("Compaction ids are missing in request. No compactions to abort");
            throw new NoSuchCompactionException("Compaction ids missing in request. No compactions to abort");
        }
        return new AbortCompactionFunction(reqst, this.sqlRetryHandler).execute(this.jdbcResource);
    }

    private static void shouldNeverHappen(long txnid) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString((long)txnid));
    }

    private void deleteInvalidOpenTransactions(List<Long> txnIds) throws MetaException {
        try {
            this.sqlRetryHandler.executeWithRetry(new SqlRetryCallProperties().withCallerId("deleteInvalidOpenTransactions"), () -> {
                this.jdbcResource.execute(new DeleteInvalidOpenTxnsCommand(txnIds));
                LOG.info("Removed transactions: ({}) from TXNS", (Object)txnIds);
                this.jdbcResource.execute(new RemoveTxnsFromMinHistoryLevelCommand(txnIds));
                return null;
            });
        }
        catch (TException e) {
            throw new MetaException(e.getMessage());
        }
    }

    private void acquireTxnLock(boolean shared) throws MetaException {
        String sqlStmt = sqlGenerator.createTxnLockStatement(shared);
        this.jdbcResource.getJdbcTemplate().getJdbcTemplate().execute(stmt -> {
            stmt.execute(sqlStmt);
            return null;
        });
        LOG.debug("TXN lock locked by '{}' in mode {}", (Object)hostname, (Object)shared);
    }

    protected Timestamp getDbTime() throws MetaException {
        return (Timestamp)this.jdbcResource.getJdbcTemplate().queryForObject(dbProduct.getDBTime(), (SqlParameterSource)new MapSqlParameterSource(), (rs, rowNum) -> rs.getTimestamp(1));
    }

    private void initJdbcResource() {
        if (this.jdbcResource == null) {
            this.jdbcResource = new MultiDataSourceJdbcResource(dbProduct, this.conf, sqlGenerator);
            this.jdbcResource.registerDataSource("txnhandler", connPool);
            this.jdbcResource.registerDataSource("mutex", connPoolMutex);
            this.jdbcResource.registerDataSource("compactor", connPoolCompactor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfTableIsUsable(String tableName, boolean configValue) {
        if (!configValue) {
            return false;
        }
        this.jdbcResource.bindDataSource("txnhandler");
        try {
            this.jdbcResource.getJdbcTemplate().query("SELECT 1 FROM \"" + tableName + "\"", (SqlParameterSource)new MapSqlParameterSource(), ResultSet::next);
        }
        catch (DataAccessException e) {
            LOG.debug("Catching sql exception in " + tableName + " check", (Throwable)e);
            if (e.getCause() instanceof SQLException) {
                if (dbProduct.isTableNotExistsError(e)) {
                    boolean bl = false;
                    return bl;
                }
                throw new RuntimeException("Unable to select from transaction database: " + SqlRetryHandler.getMessage((Exception)((Object)e)) + StringUtils.stringifyException((Throwable)e));
            }
        }
        finally {
            this.jdbcResource.unbindDataSource();
        }
        return true;
    }

    private List<String> getTxnDbsUpdated(long txnId) throws MetaException {
        try {
            return this.sqlRetryHandler.executeWithRetry(new SqlRetryCallProperties().withCallerId("GetTxnDbsUpdatedHandler"), () -> this.jdbcResource.execute(new GetTxnDbsUpdatedHandler(txnId)));
        }
        catch (MetaException e) {
            throw e;
        }
        catch (TException e) {
            throw new MetaException(e.getMessage());
        }
    }

    public List<TxnWriteDetails> getWriteIdsForTxnID(long txnId) throws MetaException {
        try {
            return this.sqlRetryHandler.executeWithRetry(new SqlRetryCallProperties().withCallerId("GetWriteIdsForTxnIDHandler"), () -> this.jdbcResource.execute(new GetWriteIdsForTxnIDHandler(txnId)));
        }
        catch (MetaException e) {
            throw e;
        }
        catch (TException e) {
            throw new MetaException(e.getMessage());
        }
    }

    static {
        initialized = false;
        hostname = JavaUtils.hostname();
    }

    public static final class ConfVars {
        private boolean useMinHistoryLevel;
        private boolean useMinHistoryWriteId;

        private ConfVars() {
        }

        public boolean useMinHistoryLevel() {
            return this.useMinHistoryLevel;
        }

        public void setUseMinHistoryLevel(boolean useMinHistoryLevel) {
            this.useMinHistoryLevel = useMinHistoryLevel;
        }

        public boolean useMinHistoryWriteId() {
            return this.useMinHistoryWriteId;
        }

        public void setUseMinHistoryWriteId(boolean useMinHistoryWriteId) {
            this.useMinHistoryWriteId = useMinHistoryWriteId;
        }

        public void init(BiPredicate<String, Boolean> tableCheck, Configuration conf) {
            this.useMinHistoryWriteId = tableCheck.test("MIN_HISTORY_WRITE_ID", MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_WRITE_ID));
            this.useMinHistoryLevel = tableCheck.test("MIN_HISTORY_LEVEL", MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_LEVEL));
        }
    }
}

