/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaToolTaskMergeCatalog
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaToolTaskMergeCatalog.class.getName());
    private String fromCatalog;
    private String toCatalog;
    private static final String DB_CONFLICTS_STMT = "SELECT d.<q>NAME<q> as DB, d.<q>CTLG_NAME<q>, d2.<q>CTLG_NAME<q> FROM <q>DBS<q> d, <q>DBS<q> d2 WHERE d.<q>NAME<q> = d2.<q>NAME<q> AND d.<q>CTLG_NAME<q> = '%s' AND d2.<q>CTLG_NAME<q> = '%s'";
    private static final String MERGE_CATALOG_STMT = "UPDATE <q>DBS<q>  SET <q>CTLG_NAME<q> = '%s'  WHERE <q>CTLG_NAME<q> = '%s'";
    private static final String CONVERT_TABLE_TO_EXTERNAL = "update <q>TBLS<q> set <q>TBL_TYPE<q> = '%s' where <q>TBL_ID<q> in (select tid from (select <q>TBL_ID<q> as tid from <q>TBLS<q> t2, <q>DBS<q> d where t2.<q>TBL_TYPE<q> = '%s' and t2.<q>DB_ID<q> = d.<q>DB_ID<q> and d.<q>CTLG_NAME<q> = '%s') c) ";
    private static final String UPDATE_CTLG_NAME_ON_DBS = "update <q>DBS<q> d set d.<q>CTLG_NAME<q> = '%s' WHERE d.<q>CTLG_NAME<q> = '%s' ";
    private static final String ADD_PARAM_TO_TABLE = "INSERT INTO <q>TABLE_PARAMS<q> (<q>TBL_ID<q>, <q>PARAM_KEY<q>, <q>PARAM_VALUE<q>) select <q>TBL_ID<q>, '%s', '%s' from <q>TBLS<q> where <q>TBL_TYPE<q> = '%s' ";
    private static final String ADD_AUTOPURGE_TO_TABLE = "INSERT INTO <q>TABLE_PARAMS<q> (<q>TBL_ID<q>, <q>PARAM_KEY<q>, <q>PARAM_VALUE<q>) select <q>TBL_ID<q>, '%s', '%s' from <q>TBLS<q> t, <q>DBS<q> d, <q>CTLGS<q> c where <q>TBL_TYPE<q> = '%s' and t.<q>DB_ID<q> = d.<q>DB_ID<q> and d.<q>CTLG_NAME<q> = c.<q>NAME<q> and c.<q>NAME<q> = '%s' ";

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        this.fromCatalog = StringUtils.normalizeIdentifier((String)cl.getOptionValue("mergeCatalog"));
        this.toCatalog = cl.getOptionValue("toCatalog");
    }

    @Override
    void execute() throws HiveMetaException {
        if (this.fromCatalog == null || this.toCatalog == null) {
            throw new HiveMetaException("Merge catalog requires --mergeCatalog and --toCatalog arguments");
        }
        System.out.println("Merging databases from " + this.fromCatalog + " to " + this.toCatalog);
        Connection conn = this.schemaTool.getConnectionToMetastore(true);
        boolean success = false;
        try (Statement stmt = conn.createStatement();){
            long initTime = System.currentTimeMillis();
            String conflicts = String.format(this.schemaTool.quote(DB_CONFLICTS_STMT), this.fromCatalog, this.toCatalog);
            System.out.println("Determining name conflicts between databases across catalogs");
            LOG.info("[DB Conflicts] Executing SQL:" + conflicts);
            ResultSet rs = stmt.executeQuery(conflicts);
            boolean cleanMerge = true;
            while (rs.next()) {
                cleanMerge = false;
                System.out.println("Name conflict(s) between merging catalogs, database " + rs.getString(1) + " exists in catalogs " + rs.getString(2) + " and " + rs.getString(3));
            }
            if (!cleanMerge) {
                System.out.println("[ERROR] Please resolve the database name conflicts shown above manually and retry the mergeCatalog operation.");
                System.exit(1);
            }
            conn.setAutoCommit(false);
            String insert = String.format(this.schemaTool.quote(ADD_AUTOPURGE_TO_TABLE), "EXTERNAL", "TRUE", "MANAGED_TABLE", this.fromCatalog);
            System.out.println("Setting external=true on all MANAGED tables in catalog " + this.fromCatalog);
            LOG.debug("[external table property] Executing SQL:" + insert);
            long prevTime = System.currentTimeMillis();
            int count = stmt.executeUpdate(insert);
            long curTime = System.currentTimeMillis();
            System.out.println("Set external.table.purge on " + count + " tables, time taken (ms):" + (curTime - prevTime));
            insert = String.format(this.schemaTool.quote(ADD_AUTOPURGE_TO_TABLE), "external.table.purge", "true", "MANAGED_TABLE", this.fromCatalog);
            System.out.println("Setting external.table.purge=true on all MANAGED tables in catalog " + this.fromCatalog);
            LOG.debug("[external.table.purge] Executing SQL:" + insert);
            prevTime = curTime;
            count = stmt.executeUpdate(insert);
            curTime = System.currentTimeMillis();
            System.out.println("Set external.table.purge on " + count + " tables, time taken (ms):" + (curTime - prevTime));
            String update = String.format(this.schemaTool.quote(CONVERT_TABLE_TO_EXTERNAL), "EXTERNAL_TABLE", "MANAGED_TABLE", this.fromCatalog);
            System.out.println("Setting tableType to EXTERNAL on all MANAGED tables in catalog " + this.fromCatalog);
            LOG.debug("[tableType=EXTERNAL_TABLE] Executing SQL:" + update);
            prevTime = curTime;
            count = stmt.executeUpdate(update);
            curTime = System.currentTimeMillis();
            System.out.println("Set tableType=EXTERNAL_TABLE on " + count + " tables, time taken (ms):" + (curTime - prevTime));
            String merge = String.format(this.schemaTool.quote(MERGE_CATALOG_STMT), this.toCatalog, this.fromCatalog);
            System.out.println("Setting catalog names on all databases in catalog " + this.fromCatalog);
            LOG.debug("[catalog name] Executing SQL:" + merge);
            prevTime = curTime;
            count = stmt.executeUpdate(merge);
            curTime = System.currentTimeMillis();
            System.out.println("Changed catalog names on " + count + " databases, time taken (ms):" + (curTime - prevTime));
            if (count == 0) {
                LOG.info(count + " databases have been merged from catalog " + this.fromCatalog + " into " + this.toCatalog);
            }
            if (this.schemaTool.isDryRun()) {
                conn.rollback();
                success = true;
            } else {
                conn.commit();
                System.out.println("Committed the changes. Total time taken (ms):" + (curTime - initTime));
                success = true;
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to merge catalog", (Throwable)e);
        }
        finally {
            try {
                if (!success) {
                    System.out.println("Rolling back transaction");
                    conn.rollback();
                }
                conn.close();
            }
            catch (SQLException e) {
                LOG.error("Failed to rollback, everything will probably go bad from here.", (Throwable)e);
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOG.warn("Failed to close connection.", (Throwable)ex);
                }
            }
        }
    }
}

