/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.jwt;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBasedJWKSProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)URLBasedJWKSProvider.class.getName());
    private final Configuration conf;
    private List<JWKSet> jwkSets = new ArrayList<JWKSet>();

    public URLBasedJWKSProvider(Configuration conf) throws IOException, ParseException {
        this.conf = conf;
        this.loadJWKSets();
    }

    private void loadJWKSets() throws IOException, ParseException {
        String[] jwksURLs;
        String jwksURL = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL);
        if (jwksURL == null || jwksURL.isEmpty()) {
            throw new IOException("Invalid value of property: " + MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL.getHiveName());
        }
        for (String urlString : jwksURLs = jwksURL.split(",")) {
            URL url = new URL(urlString);
            this.jwkSets.add(JWKSet.load((URL)url));
            LOG.info("Loaded JWKS from " + urlString);
        }
    }

    public List<JWK> getJWKs(JWSHeader header) throws AuthenticationException {
        JWKMatcher matcher = JWKMatcher.forJWSHeader((JWSHeader)header);
        if (matcher == null) {
            throw new AuthenticationException("Unsupported algorithm: " + header.getAlgorithm());
        }
        ArrayList<JWK> jwks = new ArrayList<JWK>();
        JWKSelector selector = new JWKSelector(matcher);
        for (JWKSet jwkSet : this.jwkSets) {
            jwks.addAll(selector.select(jwkSet));
        }
        return jwks;
    }
}

