/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.github.benmanes.caffeine.cache.Ticker;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;

public class HMSCachingCatalog<CATALOG extends Catalog & SupportsNamespaces>
extends CachingCatalog
implements SupportsNamespaces {
    protected final CATALOG nsCatalog;

    public HMSCachingCatalog(CATALOG catalog, long expiration) {
        super(catalog, true, expiration, Ticker.systemTicker());
        this.nsCatalog = catalog;
    }

    public CATALOG hmsUnwrap() {
        return this.nsCatalog;
    }

    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return this.nsCatalog.buildTable(identifier, schema);
    }

    public void createNamespace(Namespace nmspc, Map<String, String> map) {
        ((SupportsNamespaces)this.nsCatalog).createNamespace(nmspc, map);
    }

    public List<Namespace> listNamespaces(Namespace nmspc) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.nsCatalog).listNamespaces(nmspc);
    }

    public Map<String, String> loadNamespaceMetadata(Namespace nmspc) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.nsCatalog).loadNamespaceMetadata(nmspc);
    }

    public boolean dropNamespace(Namespace nmspc) throws NamespaceNotEmptyException {
        List tables = this.listTables(nmspc);
        for (TableIdentifier ident : tables) {
            this.invalidateTable(ident);
        }
        return ((SupportsNamespaces)this.nsCatalog).dropNamespace(nmspc);
    }

    public boolean setProperties(Namespace nmspc, Map<String, String> map) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.nsCatalog).setProperties(nmspc, map);
    }

    public boolean removeProperties(Namespace nmspc, Set<String> set) throws NoSuchNamespaceException {
        return ((SupportsNamespaces)this.nsCatalog).removeProperties(nmspc, set);
    }
}

