/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergSplit
extends InputSplit
implements IcebergSplitContainer {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergSplit.class);
    public static final String[] ANYWHERE = new String[]{"*"};
    private ScanTaskGroup<FileScanTask> taskGroup;
    private transient String[] locations;
    private transient Configuration conf;

    public IcebergSplit() {
    }

    IcebergSplit(Configuration conf, ScanTaskGroup<FileScanTask> taskGroup) {
        this.taskGroup = taskGroup;
        this.conf = conf;
    }

    public ScanTaskGroup<FileScanTask> taskGroup() {
        return this.taskGroup;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this;
    }

    public long getLength() {
        return this.taskGroup.tasks().stream().mapToLong(ContentScanTask::length).sum();
    }

    public String[] getLocations() {
        boolean localityPreferred;
        this.locations = this.locations == null && this.conf != null ? ((localityPreferred = this.conf.getBoolean("iceberg.mr.locality", false)) ? IcebergSplit.blockLocations(this.taskGroup, this.conf) : ANYWHERE) : ANYWHERE;
        return this.locations;
    }

    private static String[] blockLocations(ScanTaskGroup<FileScanTask> task, Configuration conf) {
        HashSet locationSets = Sets.newHashSet();
        task.tasks().forEach(fileScanTask -> {
            Path path = new Path(((DataFile)fileScanTask.file()).path().toString());
            try {
                FileSystem fs = path.getFileSystem(conf);
                for (BlockLocation location : fs.getFileBlockLocations(path, fileScanTask.start(), fileScanTask.length())) {
                    locationSets.addAll(Arrays.asList(location.getHosts()));
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to get block locations for path {}", (Object)path, (Object)e);
            }
        });
        return locationSets.toArray(new String[0]);
    }

    public void write(DataOutput out) throws IOException {
        byte[] data = SerializationUtil.serializeToBytes(this.taskGroup);
        out.writeInt(data.length);
        out.write(data);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        this.taskGroup = (ScanTaskGroup)SerializationUtil.deserializeFromBytes(data);
    }
}

