/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.udf;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;

@Description(name="iceberg_bucket", value="_FUNC_(value, bucketCount) - Returns the bucket value calculated by Iceberg bucket transform function ", extended="Example:\n  > SELECT _FUNC_('A bucket full of ice!', 5);\n  4")
public class GenericUDFIcebergBucket
extends GenericUDF {
    private final IntWritable result = new IntWritable();
    private int numBuckets = -1;
    private transient PrimitiveObjectInspector argumentOI;
    private transient ObjectInspectorConverters.Converter converter;
    private transient UDFEvalFunction<GenericUDF.DeferredObject> evaluator;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("ICEBERG_BUCKET requires 2 arguments (value, bucketCount), but got " + arguments.length);
        }
        this.numBuckets = GenericUDFIcebergBucket.getNumBuckets(arguments[1]);
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("ICEBERG_BUCKET first argument takes primitive types, got " + this.argumentOI.getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        PrimitiveObjectInspector.PrimitiveCategory inputType = this.argumentOI.getPrimitiveCategory();
        switch (inputType) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.converter = new PrimitiveObjectInspectorConverter.StringConverter(this.argumentOI);
                SerializableFunction stringTransform = Transforms.bucket(this.numBuckets).bind(Types.StringType.get());
                this.evaluator = arg -> {
                    String val = (String)this.converter.convert(arg.get());
                    this.result.set(((Integer)stringTransform.apply((Integer)((Object)val))).intValue());
                };
                break;
            }
            case BINARY: {
                this.converter = new PrimitiveObjectInspectorConverter.BinaryConverter(this.argumentOI, (SettableBinaryObjectInspector)PrimitiveObjectInspectorFactory.writableBinaryObjectInspector);
                SerializableFunction byteBufferTransform = Transforms.bucket(this.numBuckets).bind(Types.BinaryType.get());
                this.evaluator = arg -> {
                    BytesWritable val = (BytesWritable)this.converter.convert(arg.get());
                    ByteBuffer byteBuffer = ByteBuffer.wrap(val.getBytes(), 0, val.getLength());
                    this.result.set(((Integer)byteBufferTransform.apply((Integer)((Object)byteBuffer))).intValue());
                };
                break;
            }
            case INT: {
                this.converter = new PrimitiveObjectInspectorConverter.IntConverter(this.argumentOI, (SettableIntObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                SerializableFunction intTransform = Transforms.bucket(this.numBuckets).bind(Types.IntegerType.get());
                this.evaluator = arg -> {
                    IntWritable val = (IntWritable)this.converter.convert(arg.get());
                    this.result.set(((Integer)intTransform.apply(val.get())).intValue());
                };
                break;
            }
            case LONG: {
                this.converter = new PrimitiveObjectInspectorConverter.LongConverter(this.argumentOI, (SettableLongObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                SerializableFunction longTransform = Transforms.bucket(this.numBuckets).bind(Types.LongType.get());
                this.evaluator = arg -> {
                    LongWritable val = (LongWritable)this.converter.convert(arg.get());
                    this.result.set(((Integer)longTransform.apply((Integer)val.get())).intValue());
                };
                break;
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.argumentOI);
                Types.DecimalType decimalIcebergType = Types.DecimalType.of(decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
                this.converter = new PrimitiveObjectInspectorConverter.HiveDecimalConverter(this.argumentOI, (SettableHiveDecimalObjectInspector)new WritableHiveDecimalObjectInspector(decimalTypeInfo));
                SerializableFunction bigDecimalTransform = Transforms.bucket(this.numBuckets).bind(decimalIcebergType);
                this.evaluator = arg -> {
                    HiveDecimalWritable val = (HiveDecimalWritable)this.converter.convert(arg.get());
                    this.result.set(((Integer)bigDecimalTransform.apply((Integer)((Object)val.getHiveDecimal().bigDecimalValue()))).intValue());
                };
                break;
            }
            case FLOAT: {
                this.converter = new PrimitiveObjectInspectorConverter.FloatConverter(this.argumentOI, (SettableFloatObjectInspector)PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
                SerializableFunction floatTransform = Transforms.bucket(this.numBuckets).bind(Types.FloatType.get());
                this.evaluator = arg -> {
                    FloatWritable val = (FloatWritable)this.converter.convert(arg.get());
                    this.result.set(((Integer)floatTransform.apply((Integer)((Object)Float.valueOf(val.get())))).intValue());
                };
                break;
            }
            case DOUBLE: {
                this.converter = new PrimitiveObjectInspectorConverter.DoubleConverter(this.argumentOI, (SettableDoubleObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                SerializableFunction doubleTransform = Transforms.bucket(this.numBuckets).bind(Types.DoubleType.get());
                this.evaluator = arg -> {
                    DoubleWritable val = (DoubleWritable)this.converter.convert(arg.get());
                    this.result.set(((Integer)doubleTransform.apply((Integer)val.get())).intValue());
                };
                break;
            }
            case DATE: {
                this.converter = new PrimitiveObjectInspectorConverter.DateConverter(this.argumentOI, (SettableDateObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                SerializableFunction dateTransform = Transforms.bucket(this.numBuckets).bind(Types.DateType.get());
                this.evaluator = arg -> {
                    DateWritableV2 val = (DateWritableV2)this.converter.convert(arg.get());
                    this.result.set(((Integer)dateTransform.apply(val.getDays())).intValue());
                };
                break;
            }
            default: {
                throw new UDFArgumentException(" ICEBERG_BUCKET() only takes STRING/CHAR/VARCHAR/BINARY/INT/LONG/DECIMAL/FLOAT/DOUBLE/DATE types as first argument, got " + inputType);
            }
        }
        WritableIntObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    private static int getNumBuckets(ObjectInspector arg) throws UDFArgumentException {
        UDFArgumentException udfArgumentException = new UDFArgumentException("ICEBERG_BUCKET() second argument can only take an int type, but got " + arg.getTypeName());
        if (arg.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw udfArgumentException;
        }
        PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arg).getPrimitiveCategory();
        if (inputType != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw udfArgumentException;
        }
        return ((WritableConstantIntObjectInspector)arg).getWritableConstantValue().get();
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        GenericUDF.DeferredObject argument = arguments[0];
        if (argument == null || argument.get() == null) {
            return null;
        }
        this.evaluator.apply(argument);
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("iceberg_bucket", children);
    }

    @FunctionalInterface
    private static interface UDFEvalFunction<T> {
        public void apply(T var1) throws HiveException;
    }
}

