/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.plan.MergeTaskProperties;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobContext;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.mr.hive.HiveIcebergOutputCommitter;
import org.apache.iceberg.mr.hive.TezUtil;

public class IcebergMergeTaskProperties
implements MergeTaskProperties {
    private final Properties properties;

    IcebergMergeTaskProperties(Properties properties) {
        this.properties = properties;
    }

    public Path getTmpLocation() {
        String location = this.properties.getProperty("location");
        return new Path(location + "/data/");
    }

    public Properties getSplitProperties() throws IOException {
        List<JobContext> jobContextList = IcebergMergeTaskProperties.getJobContexts(this.properties);
        if (jobContextList.isEmpty()) {
            return null;
        }
        List<ContentFile<?>> contentFiles = HiveIcebergOutputCommitter.getInstance().getOutputContentFiles(jobContextList);
        Properties pathToContentFile = new Properties();
        contentFiles.forEach(contentFile -> pathToContentFile.put(new Path(String.valueOf(contentFile.path())), contentFile));
        return pathToContentFile;
    }

    static List<JobContext> getJobContexts(Properties properties) {
        String tableName = properties.getProperty("name");
        String snapshotRef = properties.getProperty("snapshot_ref");
        HiveConf configuration = SessionState.getSessionConf();
        return HiveIcebergOutputCommitter.generateJobContext((Configuration)configuration, tableName, snapshotRef).stream().map(TezUtil::enrichContextWithVertexId).collect(Collectors.toList());
    }
}

