/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PartitionListComposingSpec
implements TBase<PartitionListComposingSpec, _Fields>,
Serializable,
Cloneable,
Comparable<PartitionListComposingSpec> {
    private static final TStruct STRUCT_DESC = new TStruct("PartitionListComposingSpec");
    private static final TField PARTITIONS_FIELD_DESC = new TField("partitions", 15, 1);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new PartitionListComposingSpecStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new PartitionListComposingSpecTupleSchemeFactory();
    @Nullable
    private List<Partition> partitions;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PartitionListComposingSpec() {
    }

    public PartitionListComposingSpec(List<Partition> partitions) {
        this();
        this.partitions = partitions;
    }

    public PartitionListComposingSpec(PartitionListComposingSpec other) {
        if (other.isSetPartitions()) {
            ArrayList<Partition> __this__partitions = new ArrayList<Partition>(other.partitions.size());
            for (Partition other_element : other.partitions) {
                __this__partitions.add(new Partition(other_element));
            }
            this.partitions = __this__partitions;
        }
    }

    public PartitionListComposingSpec deepCopy() {
        return new PartitionListComposingSpec(this);
    }

    public void clear() {
        this.partitions = null;
    }

    public int getPartitionsSize() {
        return this.partitions == null ? 0 : this.partitions.size();
    }

    @Nullable
    public Iterator<Partition> getPartitionsIterator() {
        return this.partitions == null ? null : this.partitions.iterator();
    }

    public void addToPartitions(Partition elem) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<Partition>();
        }
        this.partitions.add(elem);
    }

    @Nullable
    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(@Nullable List<Partition> partitions) {
        this.partitions = partitions;
    }

    public void unsetPartitions() {
        this.partitions = null;
    }

    public boolean isSetPartitions() {
        return this.partitions != null;
    }

    public void setPartitionsIsSet(boolean value) {
        if (!value) {
            this.partitions = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PARTITIONS: {
                if (value == null) {
                    this.unsetPartitions();
                    break;
                }
                this.setPartitions((List)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PARTITIONS: {
                return this.getPartitions();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PARTITIONS: {
                return this.isSetPartitions();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof PartitionListComposingSpec) {
            return this.equals((PartitionListComposingSpec)that);
        }
        return false;
    }

    public boolean equals(PartitionListComposingSpec that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_partitions = this.isSetPartitions();
        boolean that_present_partitions = that.isSetPartitions();
        if (this_present_partitions || that_present_partitions) {
            if (!this_present_partitions || !that_present_partitions) {
                return false;
            }
            if (!this.partitions.equals(that.partitions)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetPartitions() ? 131071 : 524287);
        if (this.isSetPartitions()) {
            hashCode = hashCode * 8191 + this.partitions.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(PartitionListComposingSpec other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetPartitions(), other.isSetPartitions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitions() && (lastComparison = TBaseHelper.compareTo(this.partitions, other.partitions)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        PartitionListComposingSpec.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        PartitionListComposingSpec.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionListComposingSpec(");
        boolean first = true;
        sb.append("partitions:");
        if (this.partitions == null) {
            sb.append("null");
        } else {
            sb.append(this.partitions);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PARTITIONS, new FieldMetaData("partitions", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Partition.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PartitionListComposingSpec.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PARTITIONS(1, "partitions");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PARTITIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class PartitionListComposingSpecStandardSchemeFactory
    implements SchemeFactory {
        private PartitionListComposingSpecStandardSchemeFactory() {
        }

        public PartitionListComposingSpecStandardScheme getScheme() {
            return new PartitionListComposingSpecStandardScheme();
        }
    }

    private static class PartitionListComposingSpecTupleSchemeFactory
    implements SchemeFactory {
        private PartitionListComposingSpecTupleSchemeFactory() {
        }

        public PartitionListComposingSpecTupleScheme getScheme() {
            return new PartitionListComposingSpecTupleScheme();
        }
    }

    private static class PartitionListComposingSpecTupleScheme
    extends TupleScheme<PartitionListComposingSpec> {
        private PartitionListComposingSpecTupleScheme() {
        }

        public void write(TProtocol prot, PartitionListComposingSpec struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetPartitions()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetPartitions()) {
                oprot.writeI32(struct.partitions.size());
                for (Partition _iter442 : struct.partitions) {
                    _iter442.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, PartitionListComposingSpec struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                TList _list443 = iprot.readListBegin((byte)12);
                struct.partitions = new ArrayList<Partition>(_list443.size);
                for (int _i445 = 0; _i445 < _list443.size; ++_i445) {
                    Partition _elem444 = new Partition();
                    _elem444.read((TProtocol)iprot);
                    struct.partitions.add(_elem444);
                }
                struct.setPartitionsIsSet(true);
            }
        }
    }

    private static class PartitionListComposingSpecStandardScheme
    extends StandardScheme<PartitionListComposingSpec> {
        private PartitionListComposingSpecStandardScheme() {
        }

        public void read(TProtocol iprot, PartitionListComposingSpec struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list438 = iprot.readListBegin();
                            struct.partitions = new ArrayList<Partition>(_list438.size);
                            for (int _i440 = 0; _i440 < _list438.size; ++_i440) {
                                Partition _elem439 = new Partition();
                                _elem439.read(iprot);
                                struct.partitions.add(_elem439);
                            }
                            iprot.readListEnd();
                            struct.setPartitionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, PartitionListComposingSpec struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.partitions != null) {
                oprot.writeFieldBegin(PARTITIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitions.size()));
                for (Partition _iter441 : struct.partitions) {
                    _iter441.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

