/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="nullif", value="_FUNC_(a1, a2) - shorthand for: case when a1 = a2 then null else a1", extended="Example:\n SELECT _FUNC_(1,1),_FUNC_(1,2)")
public class GenericUDFNullif
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private transient GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.argumentOIs = arguments;
        this.checkArgsSize(arguments, 2, 2);
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        this.returnOIResolver.update(arguments[0]);
        switch (arguments[0].getCategory()) {
            case LIST: 
            case MAP: 
            case STRUCT: 
            case PRIMITIVE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Unsupported Argument type category: " + arguments[0].getCategory());
            }
        }
        boolean isPrimitive = arguments[0] instanceof PrimitiveObjectInspector;
        if (isPrimitive) {
            PrimitiveObjectInspector primitive0 = (PrimitiveObjectInspector)arguments[0];
            PrimitiveObjectInspector primitive1 = (PrimitiveObjectInspector)arguments[1];
            PrimitiveObjectInspectorUtils.PrimitiveGrouping pcat0 = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)primitive0.getPrimitiveCategory());
            PrimitiveObjectInspectorUtils.PrimitiveGrouping pcat1 = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)primitive1.getPrimitiveCategory());
            if (pcat0 == PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP) {
                throw new UDFArgumentTypeException(0, "NULLIF may not accept types belonging to " + pcat0 + " as first argument");
            }
            if (pcat1 != PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP && pcat0 != pcat1) {
                throw new UDFArgumentTypeException(1, "The expressions after NULLIF should belong to the same category: \"" + pcat0 + "\" is expected but \"" + pcat1 + "\" is found");
            }
        } else {
            String typeName1;
            String typeName0 = arguments[0].getTypeName();
            if (!typeName0.equals(typeName1 = arguments[1].getTypeName())) {
                throw new UDFArgumentTypeException(1, "The expressions after NULLIF should all have the same type: \"" + typeName0 + "\" is expected but \"" + typeName1 + "\" is found");
            }
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arg0 = arguments[0].get();
        Object arg1 = arguments[1].get();
        Object value0 = this.returnOIResolver.convertIfNecessary(arg0, this.argumentOIs[0], false);
        if (arg0 == null || arg1 == null) {
            return value0;
        }
        Object value1 = this.returnOIResolver.convertIfNecessary(arg1, this.argumentOIs[1], false);
        ObjectInspector compareOI = this.returnOIResolver.get();
        if (ObjectInspectorUtils.compare((Object)value0, (ObjectInspector)compareOI, (Object)value1, (ObjectInspector)compareOI) == 0) {
            return null;
        }
        return value0;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("NULLIF", children, ",");
    }
}

