/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.lang.reflect.Method;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryProcessing;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_ExteriorRing", value="_FUNC_(polygon) - return linestring which is the exterior ring of the polygon", extended="Example:\n  SELECT _FUNC_(ST_Polygon(1,1, 1,4, 4,1)) FROM src LIMIT 1;  -- LINESTRING(1 1, 4 1, 1 4, 1 1)\n  SELECT _FUNC_(ST_Polygon('polygon ((0 0, 8 0, 0 8, 0 0), (1 1, 1 5, 5 1, 1 1))')) FROM src LIMIT 1;  -- LINESTRING (8 0, 0 8, 0 0, 8 0)\n")
public class ST_ExteriorRing
extends ST_GeometryProcessing {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_ExteriorRing.class.getName());

    public BytesWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        if (GeometryUtils.getType(geomref) == GeometryUtils.OGCType.ST_POLYGON) {
            Method extMethod;
            try {
                extMethod = OGCPolygon.class.getMethod("exteriorRing", new Class[0]);
            }
            catch (Exception e) {
                LogUtils.Log_InternalError(LOG, "ST_ExteriorRing: " + e);
                try {
                    extMethod = OGCPolygon.class.getMethod("exterorRing", new Class[0]);
                }
                catch (Exception x) {
                    LogUtils.Log_InternalError(LOG, "ST_ExteriorRing: " + x);
                    return null;
                }
            }
            try {
                OGCLineString extRing = (OGCLineString)extMethod.invoke((Object)ogcGeometry, new Object[0]);
                return GeometryUtils.geometryToEsriShapeBytesWritable((OGCGeometry)extRing);
            }
            catch (Exception e) {
                LogUtils.Log_InternalError(LOG, "ST_ExteriorRing: " + e);
                return null;
            }
        }
        LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_POLYGON, GeometryUtils.getType(geomref));
        return null;
    }
}

