/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapOutputFormat;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.ddl.DDLDescWithTableProperties;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileInputFormat;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe2;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlanUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PlanUtils.class);
    private static long countForMapJoinDumpFilePrefix = 0L;
    public static final String LLAP_OUTPUT_FORMAT_KEY = "Llap";
    private static final String LLAP_OF_SH_CLASS = "org.apache.hadoop.hive.llap.LlapStorageHandler";
    private static final String[] FILTER_OUT_FROM_EXPLAIN = new String[]{"created_with_ctas"};

    public static synchronized long getCountForMapJoinDumpFilePrefix() {
        return countForMapJoinDumpFilePrefix++;
    }

    public static MapredWork getMapRedWork() {
        return new MapredWork();
    }

    public static TableDesc getDefaultTableDesc(CreateTableDesc directoryDesc, String cols, String colTypes) {
        TableDesc ret = PlanUtils.getDefaultTableDesc(Integer.toString(1), cols, colTypes, false);
        if (directoryDesc == null) {
            return ret;
        }
        try {
            Properties properties = ret.getProperties();
            if (directoryDesc.getFieldDelim() != null) {
                properties.setProperty("field.delim", directoryDesc.getFieldDelim());
                properties.setProperty("serialization.format", directoryDesc.getFieldDelim());
            }
            if (directoryDesc.getLineDelim() != null) {
                properties.setProperty("line.delim", directoryDesc.getLineDelim());
            }
            if (directoryDesc.getCollItemDelim() != null) {
                properties.setProperty("collection.delim", directoryDesc.getCollItemDelim());
            }
            if (directoryDesc.getMapKeyDelim() != null) {
                properties.setProperty("mapkey.delim", directoryDesc.getMapKeyDelim());
            }
            if (directoryDesc.getFieldEscape() != null) {
                properties.setProperty("escape.delim", directoryDesc.getFieldEscape());
            }
            if (directoryDesc.getSerde() != null) {
                properties.setProperty("serialization.lib", directoryDesc.getSerde());
            }
            if (directoryDesc.getSerdeProps() != null) {
                properties.putAll(directoryDesc.getSerdeProps());
            }
            if (directoryDesc.getInputFormat() != null) {
                ret.setInputFileFormatClass(JavaUtils.loadClass((String)directoryDesc.getInputFormat()));
            }
            if (directoryDesc.getOutputFormat() != null) {
                ret.setOutputFileFormatClass(JavaUtils.loadClass((String)directoryDesc.getOutputFormat()));
            }
            if (directoryDesc.getNullFormat() != null) {
                properties.setProperty("serialization.null.format", directoryDesc.getNullFormat());
            }
            if (directoryDesc.getTblProps() != null) {
                properties.putAll(directoryDesc.getTblProps());
            }
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Unable to find class in getDefaultTableDesc: " + e.getMessage(), (Throwable)e);
            return null;
        }
        return ret;
    }

    public static TableDesc getDefaultTableDesc(String separatorCode, String columns) {
        return PlanUtils.getDefaultTableDesc(separatorCode, columns, false);
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, false);
    }

    public static TableDesc getDefaultTableDesc(String separatorCode, String columns, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getDefaultTableDesc(separatorCode, columns, null, lastColumnTakesRestOfTheLine);
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, null, null, lastColumnTakesRestOfTheLine);
    }

    public static TableDesc getDefaultTableDesc(String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(PlanUtils.getDefaultSerDe(), separatorCode, columns, columnTypes, null, lastColumnTakesRestOfTheLine);
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, String columnTypes, List<FieldSchema> partCols, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, columnTypes, partCols, lastColumnTakesRestOfTheLine, "TextFile");
    }

    public static TableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, String columnTypes, List<FieldSchema> partCols, boolean lastColumnTakesRestOfTheLine, String fileFormat) {
        Class outputFormat;
        Class inputFormat;
        Properties properties = Utilities.makeProperties("serialization.format", separatorCode, "columns", columns);
        if (!separatorCode.equals(Integer.toString(1))) {
            properties.setProperty("field.delim", separatorCode);
        }
        if (columnTypes != null) {
            properties.setProperty("columns.types", columnTypes);
        }
        if (CollectionUtils.isNotEmpty(partCols)) {
            properties.setProperty("partition.columns", MetaStoreUtils.getColumnNamesFromFieldSchema(partCols));
            properties.setProperty("partition.columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(partCols, (String)":"));
            properties.setProperty("partition.columns.comments", MetaStoreUtils.getColumnCommentsFromFieldSchema(partCols));
        }
        if (lastColumnTakesRestOfTheLine) {
            properties.setProperty("serialization.last.column.takes.rest", "true");
        }
        if ("HiveSequenceFile".equalsIgnoreCase(fileFormat)) {
            inputFormat = HiveSequenceFileInputFormat.class;
            outputFormat = SequenceFileOutputFormat.class;
        } else if ("SequenceFile".equalsIgnoreCase(fileFormat)) {
            inputFormat = SequenceFileInputFormat.class;
            outputFormat = SequenceFileOutputFormat.class;
        } else if ("RCFile".equalsIgnoreCase(fileFormat)) {
            inputFormat = RCFileInputFormat.class;
            outputFormat = RCFileOutputFormat.class;
            assert (serdeClass == ColumnarSerDe.class);
        } else if (LLAP_OUTPUT_FORMAT_KEY.equalsIgnoreCase(fileFormat)) {
            inputFormat = TextInputFormat.class;
            outputFormat = LlapOutputFormat.class;
            properties.setProperty("storage_handler", LLAP_OF_SH_CLASS);
        } else {
            inputFormat = TextInputFormat.class;
            outputFormat = IgnoreKeyTextOutputFormat.class;
        }
        properties.setProperty("serialization.lib", serdeClass.getName());
        properties.setProperty("bucketing_version", "-1");
        return new TableDesc(inputFormat, outputFormat, properties);
    }

    public static TableDesc getDefaultQueryOutputTableDesc(String cols, String colTypes, String fileFormat, Class<? extends Deserializer> serdeClass) {
        TableDesc tblDesc = PlanUtils.getTableDesc(serdeClass, "1", cols, colTypes, null, false, fileFormat);
        tblDesc.getProperties().setProperty("escape.delim", "\\");
        tblDesc.getProperties().setProperty("serialization.escape.crlf", "true");
        tblDesc.getProperties().setProperty("hive.serialization.extend.additional.nesting.levels", "true");
        return tblDesc;
    }

    public static TableDesc getTableDesc(CreateTableDesc crtTblDesc, String cols, String colTypes) {
        String separatorCode = Integer.toString(1);
        if (crtTblDesc.getFieldDelim() != null) {
            separatorCode = crtTblDesc.getFieldDelim();
        }
        TableDesc ret = PlanUtils.getTableDesc(crtTblDesc, cols, colTypes, separatorCode);
        Properties properties = ret.getProperties();
        if (crtTblDesc.getCollItemDelim() != null) {
            properties.setProperty("collection.delim", crtTblDesc.getCollItemDelim());
        }
        if (crtTblDesc.getMapKeyDelim() != null) {
            properties.setProperty("mapkey.delim", crtTblDesc.getMapKeyDelim());
        }
        if (crtTblDesc.getFieldEscape() != null) {
            properties.setProperty("escape.delim", crtTblDesc.getFieldEscape());
        }
        if (crtTblDesc.getLineDelim() != null) {
            properties.setProperty("line.delim", crtTblDesc.getLineDelim());
        }
        if (crtTblDesc.getNullFormat() != null) {
            properties.setProperty("serialization.null.format", crtTblDesc.getNullFormat());
        }
        if (crtTblDesc.getDbTableName() != null && crtTblDesc.getDatabaseName() != null) {
            properties.setProperty("name", crtTblDesc.getDbTableName());
        }
        return ret;
    }

    public static TableDesc getTableDesc(CreateMaterializedViewDesc crtViewDesc, String cols, String colTypes) {
        TableDesc ret = PlanUtils.getTableDesc(crtViewDesc, cols, colTypes, Integer.toString(1));
        Properties properties = ret.getProperties();
        if (crtViewDesc.getViewName() != null) {
            properties.setProperty("name", crtViewDesc.getViewName());
        }
        return ret;
    }

    private static TableDesc getTableDesc(DDLDescWithTableProperties crtDdlDesc, String cols, String colTypes, String separatorCode) {
        HiveStorageHandler storageHandler = null;
        try {
            if (crtDdlDesc.getStorageHandler() != null) {
                storageHandler = HiveUtils.getStorageHandler((Configuration)SessionState.getSessionConf(), crtDdlDesc.getStorageHandler());
            }
        }
        catch (HiveException e) {
            throw new RuntimeException("Failed to resolve storage handler: " + e.getMessage(), e);
        }
        Class serdeClass = PlanUtils.getDefaultSerDe();
        try {
            if (storageHandler != null) {
                serdeClass = storageHandler.getSerDeClass();
            } else if (crtDdlDesc.getSerde() != null) {
                serdeClass = JavaUtils.loadClass((String)crtDdlDesc.getSerde());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load SerDe class: " + serdeClass, e);
        }
        TableDesc ret = PlanUtils.getTableDesc(serdeClass, separatorCode, cols, colTypes, crtDdlDesc.getPartCols(), false);
        Properties properties = ret.getProperties();
        if (crtDdlDesc.getStorageHandler() != null) {
            properties.setProperty("storage_handler", crtDdlDesc.getStorageHandler());
            if (StringUtils.isNotBlank((CharSequence)crtDdlDesc.getLocation())) {
                properties.setProperty("location", crtDdlDesc.getLocation());
            }
        }
        if (crtDdlDesc.getTblProps() != null) {
            properties.putAll(crtDdlDesc.getTblProps());
        }
        if (crtDdlDesc.getSerdeProps() != null) {
            properties.putAll(crtDdlDesc.getSerdeProps());
        }
        try {
            Class in_class = storageHandler != null ? storageHandler.getInputFormatClass() : JavaUtils.loadClass((String)crtDdlDesc.getInputFormat());
            Class out_class = storageHandler != null ? storageHandler.getOutputFormatClass() : JavaUtils.loadClass((String)crtDdlDesc.getOutputFormat());
            ret.setInputFileFormatClass(in_class);
            ret.setOutputFileFormatClass(out_class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to resolve Input/Output format: " + e.getMessage(), e);
        }
        return ret;
    }

    public static TableDesc getReduceKeyTableDesc(List<FieldSchema> fieldSchemas, String order, String nullOrder) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "column.name.delimiter", MetaStoreUtils.getColumnNameDelimiter(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "serialization.sort.order", order, "serialization.sort.order.null", nullOrder, "serialization.lib", BinarySortableSerDe.class.getName()));
    }

    public static TableDesc getMapJoinKeyTableDesc(Configuration conf, List<FieldSchema> fieldSchemas) {
        if (HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            String order = StringUtils.repeat((String)"+", (int)fieldSchemas.size());
            String nullOrder = StringUtils.repeat((char)NullOrdering.defaultNullOrder(conf).getSign(), (int)fieldSchemas.size());
            return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "column.name.delimiter", MetaStoreUtils.getColumnNameDelimiter(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "serialization.sort.order", order, "serialization.sort.order.null", nullOrder, "serialization.lib", BinarySortableSerDe.class.getName()));
        }
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe.class.getName()));
    }

    public static TableDesc getMapJoinValueTableDesc(List<FieldSchema> fieldSchemas) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "column.name.delimiter", MetaStoreUtils.getColumnNameDelimiter(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe.class.getName()));
    }

    public static TableDesc getIntermediateFileTableDesc(List<FieldSchema> fieldSchemas) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "column.name.delimiter", MetaStoreUtils.getColumnNameDelimiter(fieldSchemas), "column.name.delimiter", MetaStoreUtils.getColumnNameDelimiter(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe.class.getName()));
    }

    public static TableDesc getReduceValueTableDesc(List<FieldSchema> fieldSchemas) {
        return new TableDesc(SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\", "serialization.lib", LazyBinarySerDe2.class.getName()));
    }

    public static List<FieldSchema> getFieldSchemasFromColumnListWithLength(List<ExprNodeDesc> cols, List<List<Integer>> distinctColIndices, List<String> outputColumnNames, int length, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(length + 1);
        for (int i = 0; i < length; ++i) {
            schemas.add(HiveMetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + outputColumnNames.get(i)), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        ArrayList<TypeInfo> unionTypes = new ArrayList<TypeInfo>();
        for (List<Integer> distinctCols : distinctColIndices) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<TypeInfo> types = new ArrayList<TypeInfo>();
            int numExprs = 0;
            for (int i : distinctCols) {
                names.add(HiveConf.getColumnInternalName((int)numExprs));
                types.add(cols.get(i).getTypeInfo());
                ++numExprs;
            }
            unionTypes.add(TypeInfoFactory.getStructTypeInfo(names, types));
        }
        if (outputColumnNames.size() - length > 0) {
            schemas.add(HiveMetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + outputColumnNames.get(length)), (TypeInfo)TypeInfoFactory.getUnionTypeInfo(unionTypes)));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromColumnList(List<ExprNodeDesc> cols, List<String> outputColumnNames, int start, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            schemas.add(HiveMetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + outputColumnNames.get(i + start)), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromColumnList(List<ExprNodeDesc> cols, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            schemas.add(HiveMetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + i), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromRowSchema(RowSchema row, String fieldPrefix) {
        List<ColumnInfo> c = row.getSignature();
        return PlanUtils.getFieldSchemasFromColumnInfo(c, fieldPrefix);
    }

    public static List<FieldSchema> getFieldSchemasFromColumnInfo(List<ColumnInfo> cols, String fieldPrefix) {
        if (CollectionUtils.isEmpty(cols)) {
            return Collections.emptyList();
        }
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            Object name = cols.get(i).getInternalName();
            if (((String)name).equals(String.valueOf(i))) {
                name = fieldPrefix + (String)name;
            }
            schemas.add(HiveMetaStoreUtils.getFieldSchemaFromTypeInfo((String)name, (TypeInfo)cols.get(i).getType()));
        }
        return schemas;
    }

    public static ReduceSinkDesc getReduceSinkDesc(List<ExprNodeDesc> keyCols, List<ExprNodeDesc> valueCols, List<String> outputColumnNames, boolean includeKeyCols, int tag, List<ExprNodeDesc> partitionCols, String order, String nullOrder, NullOrdering defaultNullOrder, int numReducers, AcidUtils.Operation writeType, boolean isCompaction) {
        ReduceSinkDesc reduceSinkDesc = PlanUtils.getReduceSinkDesc(keyCols, keyCols.size(), valueCols, new ArrayList<List<Integer>>(), includeKeyCols ? outputColumnNames.subList(0, keyCols.size()) : new ArrayList(), includeKeyCols ? outputColumnNames.subList(keyCols.size(), outputColumnNames.size()) : outputColumnNames, includeKeyCols, tag, partitionCols, order, nullOrder, defaultNullOrder, numReducers, writeType);
        reduceSinkDesc.setIsCompaction(isCompaction);
        return reduceSinkDesc;
    }

    public static ReduceSinkDesc getReduceSinkDesc(List<ExprNodeDesc> keyCols, int numKeys, List<ExprNodeDesc> valueCols, List<List<Integer>> distinctColIndices, List<String> outputKeyColumnNames, List<String> outputValueColumnNames, boolean includeKeyCols, int tag, List<ExprNodeDesc> partitionCols, String order, String nullOrder, NullOrdering defaultNullOrder, int numReducers, AcidUtils.Operation writeType) {
        TableDesc keyTable;
        ArrayList<String> outputKeyCols = new ArrayList<String>();
        ArrayList<String> outputValCols = new ArrayList<String>();
        if (includeKeyCols) {
            List<FieldSchema> keySchema = PlanUtils.getFieldSchemasFromColumnListWithLength(keyCols, distinctColIndices, outputKeyColumnNames, numKeys, "");
            if (((String)order).length() < outputKeyColumnNames.size()) {
                order = (String)order + "+";
            }
            if (((String)nullOrder).length() < outputKeyColumnNames.size()) {
                nullOrder = (String)nullOrder + defaultNullOrder.getSign();
            }
            keyTable = PlanUtils.getReduceKeyTableDesc(keySchema, (String)order, (String)nullOrder);
            outputKeyCols.addAll(outputKeyColumnNames);
        } else {
            keyTable = PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, "reducesinkkey"), (String)order, (String)nullOrder);
            for (int i = 0; i < keyCols.size(); ++i) {
                outputKeyCols.add("reducesinkkey" + i);
            }
        }
        TableDesc valueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, outputValueColumnNames, 0, ""));
        outputValCols.addAll(outputValueColumnNames);
        return new ReduceSinkDesc(keyCols, numKeys, valueCols, outputKeyCols, distinctColIndices, outputValCols, tag, partitionCols, numReducers, keyTable, valueTable, writeType);
    }

    public static ReduceSinkDesc getReduceSinkDesc(List<ExprNodeDesc> keyCols, List<ExprNodeDesc> valueCols, List<String> outputColumnNames, boolean includeKey, int tag, int numPartitionFields, int numReducers, AcidUtils.Operation writeType, NullOrdering defaultNullOrder) throws SemanticException {
        return PlanUtils.getReduceSinkDesc(keyCols, keyCols.size(), valueCols, new ArrayList<List<Integer>>(), includeKey ? outputColumnNames.subList(0, keyCols.size()) : new ArrayList(), includeKey ? outputColumnNames.subList(keyCols.size(), outputColumnNames.size()) : outputColumnNames, includeKey, tag, numPartitionFields, numReducers, writeType, defaultNullOrder);
    }

    public static ReduceSinkDesc getReduceSinkDesc(List<ExprNodeDesc> keyCols, int numKeys, List<ExprNodeDesc> valueCols, List<List<Integer>> distinctColIndices, List<String> outputKeyColumnNames, List<String> outputValueColumnNames, boolean includeKey, int tag, int numPartitionFields, int numReducers, AcidUtils.Operation writeType, NullOrdering defaultNullOrder) throws SemanticException {
        ArrayList<ExprNodeDesc> partitionCols = new ArrayList<ExprNodeDesc>();
        if (numPartitionFields >= keyCols.size()) {
            partitionCols.addAll(keyCols);
        } else if (numPartitionFields >= 0) {
            partitionCols.addAll(keyCols.subList(0, numPartitionFields));
        } else {
            partitionCols.add((ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("rand", new ExprNodeDesc[0]));
        }
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        for (int i = 0; i < keyCols.size(); ++i) {
            order.append("+");
            nullOrder.append(defaultNullOrder.getSign());
        }
        return PlanUtils.getReduceSinkDesc(keyCols, numKeys, valueCols, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, includeKey, tag, partitionCols, order.toString(), nullOrder.toString(), defaultNullOrder, numReducers, writeType);
    }

    public static void configureInputJobPropertiesForStorageHandler(TableDesc tableDesc) {
        PlanUtils.configureJobPropertiesForStorageHandler(true, tableDesc);
    }

    public static void configureOutputJobPropertiesForStorageHandler(TableDesc tableDesc) {
        PlanUtils.configureJobPropertiesForStorageHandler(false, tableDesc);
    }

    private static void configureJobPropertiesForStorageHandler(boolean input, TableDesc tableDesc) {
        block13: {
            if (tableDesc == null) {
                return;
            }
            try {
                HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)SessionState.getSessionConf(), tableDesc.getProperties().getProperty("storage_handler"));
                if (storageHandler == null) break block13;
                LinkedHashMap<String, String> jobProperties = new LinkedHashMap<String, String>();
                LinkedHashMap<String, String> jobSecrets = new LinkedHashMap<String, String>();
                if (input) {
                    try {
                        storageHandler.configureInputJobProperties(tableDesc, jobProperties);
                    }
                    catch (AbstractMethodError e) {
                        LOG.info("configureInputJobProperties not found using configureTableJobProperties", (Throwable)e);
                        storageHandler.configureTableJobProperties(tableDesc, jobProperties);
                    }
                    try {
                        storageHandler.configureInputJobCredentials(tableDesc, jobSecrets);
                    }
                    catch (AbstractMethodError e) {
                        LOG.info("configureInputJobSecrets not found");
                    }
                } else {
                    try {
                        storageHandler.configureOutputJobProperties(tableDesc, jobProperties);
                    }
                    catch (AbstractMethodError e) {
                        LOG.info("configureOutputJobProperties not foundusing configureTableJobProperties", (Throwable)e);
                        storageHandler.configureTableJobProperties(tableDesc, jobProperties);
                    }
                }
                if (!jobProperties.isEmpty()) {
                    tableDesc.setJobProperties(jobProperties);
                }
                if (!jobSecrets.isEmpty()) {
                    tableDesc.setJobSecrets(jobSecrets);
                }
            }
            catch (HiveException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        try {
            HiveStorageHandler storageHandler = HiveUtils.getStorageHandler((Configuration)jobConf, tableDesc.getProperties().getProperty("storage_handler"));
            if (storageHandler != null) {
                storageHandler.configureJobConf(tableDesc, jobConf);
            }
            if (tableDesc.getJobSecrets() != null) {
                for (Map.Entry<String, String> entry : tableDesc.getJobSecrets().entrySet()) {
                    String key = "TABLE_SECRET#" + tableDesc.getTableName() + "#" + entry.getKey();
                    jobConf.getCredentials().addSecretKey(new Text(key), entry.getValue().getBytes());
                }
                tableDesc.getJobSecrets().clear();
            }
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    public static String stripQuotes(String val) {
        if (val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'' || val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static String removePrefixFromWarehouseConfig(String origiKey) {
        int index;
        String prefix = SessionState.get().getConf().getVar(HiveConf.ConfVars.METASTORE_WAREHOUSE);
        if (StringUtils.isNotBlank((CharSequence)prefix) && (index = origiKey.indexOf(prefix = prefix.replace("pfile:///", "pfile:/"))) > -1) {
            origiKey = origiKey.substring(index + prefix.length());
        }
        return origiKey;
    }

    private PlanUtils() {
    }

    public static ReadEntity addInput(Set<ReadEntity> inputs, ReadEntity newInput) {
        return PlanUtils.addInput(inputs, newInput, false);
    }

    public static ReadEntity addInput(Set<ReadEntity> inputs, ReadEntity newInput, boolean mergeIsDirectFlag) {
        if (inputs.contains(newInput)) {
            for (ReadEntity input : inputs) {
                if (!input.equals(newInput)) continue;
                if (newInput.getParents() != null && !newInput.getParents().isEmpty()) {
                    input.getParents().addAll(newInput.getParents());
                    input.setDirect(input.isDirect() || newInput.isDirect());
                } else if (mergeIsDirectFlag) {
                    input.setDirect(input.isDirect() || newInput.isDirect());
                }
                return input;
            }
            assert (false);
        } else {
            inputs.add(newInput);
            return newInput;
        }
        return null;
    }

    public static String getExprListString(Collection<? extends ExprNodeDesc> exprs) {
        return PlanUtils.getExprListString(exprs, false, false);
    }

    public static String getExprListString(Collection<? extends ExprNodeDesc> exprs, boolean userLevelExplain) {
        return PlanUtils.getExprListString(exprs, userLevelExplain, false);
    }

    public static String getExprListString(Collection<? extends ExprNodeDesc> exprs, boolean userLevelExplain, boolean sortExpressions) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ExprNodeDesc exprNodeDesc : exprs) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            PlanUtils.addExprToStringBuffer(exprNodeDesc, sb, userLevelExplain, sortExpressions);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public static void addExprToStringBuffer(ExprNodeDesc expr, Appendable sb, boolean userLevelExplain, boolean sortExpressions) {
        try {
            sb.append(expr.getExprString(sortExpressions));
            if (!userLevelExplain) {
                sb.append(" (type: ");
                sb.append(expr.getTypeString());
                sb.append(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isValuesTempTable(String tableName) {
        return tableName.toLowerCase().startsWith("Values__Tmp__Table__".toLowerCase());
    }

    public static void addPartitionInputs(Collection<Partition> parts, Collection<ReadEntity> inputs, ReadEntity parentViewInfo, boolean isDirectRead) {
        LinkedHashMap<ReadEntity, ReadEntity> readEntityMap = new LinkedHashMap<ReadEntity, ReadEntity>(inputs.size());
        for (ReadEntity input : inputs) {
            readEntityMap.put(input, input);
        }
        for (Partition part : parts) {
            if (PlanUtils.isValuesTempTable(part.getTable().getTableName())) continue;
            ReadEntity newInput = part.getTable().isPartitioned() && !part.getTable().hasNonNativePartitionSupport() ? new ReadEntity(part, parentViewInfo, isDirectRead) : new ReadEntity(part.getTable(), parentViewInfo, isDirectRead);
            if (readEntityMap.containsKey(newInput)) {
                ReadEntity input = (ReadEntity)readEntityMap.get(newInput);
                if (newInput.getParents() == null || newInput.getParents().isEmpty()) continue;
                input.getParents().addAll(newInput.getParents());
                input.setDirect(input.isDirect() || newInput.isDirect());
                continue;
            }
            readEntityMap.put(newInput, newInput);
        }
        if (inputs.size() != readEntityMap.size()) {
            inputs.addAll(readEntityMap.keySet());
        }
    }

    public static ReadEntity getParentViewInfo(String alias_id, Map<String, ReadEntity> viewAliasToInput) {
        String[] aliases = alias_id.split(":");
        String currentAlias = null;
        ReadEntity currentInput = null;
        for (int pos = 0; pos < aliases.length - 1; ++pos) {
            currentAlias = currentAlias == null ? aliases[pos] : currentAlias + ":" + aliases[pos];
            ReadEntity input = viewAliasToInput.get(currentAlias = currentAlias.replace("-subquery1", "").replace("-subquery2", ""));
            if (input == null && currentInput != null) {
                return currentInput;
            }
            currentInput = input;
        }
        return currentInput;
    }

    public static Class<? extends AbstractSerDe> getDefaultSerDe() {
        return LazySimpleSerDe.class;
    }

    static Map<Object, Object> getPropertiesForExplain(Properties properties) {
        if (properties != null) {
            HashMap<Object, Object> clone = null;
            String value = properties.getProperty("columns.comments");
            if (value != null) {
                clone = new HashMap<Object, Object>(properties);
                clone.put("columns.comments", HiveStringUtils.quoteComments((String)value));
            }
            if ("0".equals(value = properties.getProperty("numFilesErasureCoded"))) {
                if (clone == null) {
                    clone = new HashMap<Object, Object>(properties);
                }
                clone.remove("numFilesErasureCoded");
            }
            for (String key : FILTER_OUT_FROM_EXPLAIN) {
                if (!properties.containsKey(key)) continue;
                if (clone == null) {
                    clone = new HashMap<Object, Object>(properties);
                }
                clone.remove(key);
            }
            if (clone != null) {
                return clone;
            }
        }
        return properties;
    }

    public static Map<String, String> getPropertiesForExplain(Map<String, String> properties, String ... propertiesToRemove) {
        if (properties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> clone = new HashMap<String, String>(properties);
        for (String key : propertiesToRemove) {
            clone.remove(key);
        }
        return clone;
    }
}

