/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.VectorLimitDesc;

@Explain(displayName="Limit", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class LimitDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private int offset = 0;
    private int limit;
    private int leastRows = -1;

    public LimitDesc() {
    }

    public LimitDesc(int limit) {
        this.limit = limit;
    }

    public LimitDesc(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
    }

    public LimitDesc(LimitDesc conf) {
        this(conf.getOffset() == null ? 0 : conf.getOffset(), conf.getLimit());
        this.leastRows = conf.leastRows;
    }

    @Explain(displayName="Offset of rows", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Integer getOffset() {
        return this.offset == 0 ? null : Integer.valueOf(this.offset);
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @Signature
    @Explain(displayName="Number of rows", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLeastRows() {
        return this.leastRows;
    }

    public void setLeastRows(int leastRows) {
        this.leastRows = leastRows;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Limit Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public LimitOperatorExplainVectorization getLimitVectorization() {
        VectorLimitDesc vectorLimitDesc = (VectorLimitDesc)this.getVectorDesc();
        if (vectorLimitDesc == null) {
            return null;
        }
        return new LimitOperatorExplainVectorization(this, vectorLimitDesc);
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            LimitDesc otherDesc = (LimitDesc)other;
            return this.getLimit() == otherDesc.getLimit();
        }
        return false;
    }

    public class LimitOperatorExplainVectorization
    extends OperatorExplainVectorization {
        public LimitOperatorExplainVectorization(LimitDesc limitDesc, VectorLimitDesc vectorLimitDesc) {
            super(vectorLimitDesc, true);
        }
    }
}

