/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.SubqueryType;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ExprNodeSubQueryDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RelNode rexSubQuery;
    private ExprNodeDesc subQueryLhs;
    private SubqueryType type;
    private ASTNode comparisonOp;

    public ExprNodeSubQueryDesc(TypeInfo typeInfo, RelNode subQuery, SubqueryType type) {
        super(typeInfo);
        this.rexSubQuery = subQuery;
        this.subQueryLhs = null;
        this.type = type;
        this.comparisonOp = null;
    }

    public ExprNodeSubQueryDesc(TypeInfo typeInfo, RelNode subQuery, SubqueryType type, ExprNodeDesc lhs) {
        super(typeInfo);
        this.rexSubQuery = subQuery;
        this.subQueryLhs = lhs;
        this.type = type;
        this.comparisonOp = null;
    }

    public ExprNodeSubQueryDesc(TypeInfo typeInfo, RelNode subQuery, SubqueryType type, ExprNodeDesc lhs, ASTNode comparisonOp) {
        super(typeInfo);
        this.rexSubQuery = subQuery;
        this.subQueryLhs = lhs;
        this.type = type;
        this.comparisonOp = comparisonOp;
    }

    public ASTNode getComparisonOp() {
        return this.comparisonOp;
    }

    public SubqueryType getType() {
        return this.type;
    }

    public ExprNodeDesc getSubQueryLhs() {
        return this.subQueryLhs;
    }

    public RelNode getRexSubQuery() {
        return this.rexSubQuery;
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeSubQueryDesc(this.typeInfo, this.rexSubQuery, this.type, this.subQueryLhs);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeSubQueryDesc)) {
            return false;
        }
        ExprNodeSubQueryDesc dest = (ExprNodeSubQueryDesc)o;
        if (this.subQueryLhs != null && dest.getSubQueryLhs() != null && !this.subQueryLhs.equals(dest.getSubQueryLhs())) {
            return false;
        }
        if (!this.typeInfo.equals((Object)dest.getTypeInfo())) {
            return false;
        }
        if (!this.rexSubQuery.equals(dest.getRexSubQuery())) {
            return false;
        }
        return this.type == dest.getType();
    }
}

