/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeSubQueryDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMurmurHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeDescUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(ExprNodeDescUtils.class);

    public static int indexOf(ExprNodeDesc origin, List<ExprNodeDesc> sources) {
        return ExprNodeDescUtils.indexOf(origin, sources, 0);
    }

    public static int indexOf(ExprNodeDesc origin, List<ExprNodeDesc> sources, int startIndex) {
        for (int i = startIndex; i < sources.size(); ++i) {
            if (!origin.isSame(sources.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static ExprNodeDesc replace(ExprNodeDesc origin, List<ExprNodeDesc> sources, List<ExprNodeDesc> targets) {
        int index = ExprNodeDescUtils.indexOf(origin, sources);
        if (index >= 0) {
            return targets.get(index);
        }
        if (origin instanceof ExprNodeColumnDesc || origin instanceof ExprNodeFieldDesc) {
            return null;
        }
        if (origin instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)origin;
            if (!FunctionRegistry.isConsistentWithinQuery(func.getGenericUDF())) {
                return null;
            }
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            for (int i = 0; i < origin.getChildren().size(); ++i) {
                ExprNodeDesc child = ExprNodeDescUtils.replace(origin.getChildren().get(i), sources, targets);
                if (child == null) {
                    return null;
                }
                children.add(child);
            }
            ExprNodeGenericFuncDesc clone = (ExprNodeGenericFuncDesc)func.clone();
            clone.setChildren(children);
            return clone;
        }
        return origin;
    }

    private static boolean isDefaultPartition(ExprNodeDesc origin, String defaultPartitionName) {
        return origin instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)origin).getValue() != null && ((ExprNodeConstantDesc)origin).getValue() instanceof String && ((ExprNodeConstantDesc)origin).getValue().equals(defaultPartitionName);
    }

    public static void replaceEqualDefaultPartition(ExprNodeDesc origin, String defaultPartitionName) throws SemanticException {
        ExprNodeColumnDesc column = null;
        ExprNodeConstantDesc defaultPartition = null;
        if (origin instanceof ExprNodeGenericFuncDesc && (((ExprNodeGenericFuncDesc)origin).getGenericUDF() instanceof GenericUDFOPEqual || ((ExprNodeGenericFuncDesc)origin).getGenericUDF() instanceof GenericUDFOPNotEqual)) {
            if (ExprNodeDescUtils.isDefaultPartition(origin.getChildren().get(0), defaultPartitionName)) {
                defaultPartition = (ExprNodeConstantDesc)origin.getChildren().get(0);
                column = (ExprNodeColumnDesc)origin.getChildren().get(1);
            } else if (ExprNodeDescUtils.isDefaultPartition(origin.getChildren().get(1), defaultPartitionName)) {
                column = (ExprNodeColumnDesc)origin.getChildren().get(0);
                defaultPartition = (ExprNodeConstantDesc)origin.getChildren().get(1);
            }
        }
        if (column != null) {
            origin.getChildren().remove(defaultPartition);
            String fnName = ((ExprNodeGenericFuncDesc)origin).getGenericUDF() instanceof GenericUDFOPEqual ? "isnull" : "isnotnull";
            ((ExprNodeGenericFuncDesc)origin).setGenericUDF(FunctionRegistry.getFunctionInfo(fnName).getGenericUDF());
        } else if (origin.getChildren() != null) {
            for (ExprNodeDesc child : origin.getChildren()) {
                ExprNodeDescUtils.replaceEqualDefaultPartition(child, defaultPartitionName);
            }
        }
    }

    public static void replaceNullFiltersWithDefaultPartition(ExprNodeDesc origin, String defaultPartitionName) throws SemanticException {
        String fnName = null;
        if (origin instanceof ExprNodeGenericFuncDesc) {
            if (((ExprNodeGenericFuncDesc)origin).getGenericUDF() instanceof GenericUDFOPNull) {
                fnName = "=";
            } else if (((ExprNodeGenericFuncDesc)origin).getGenericUDF() instanceof GenericUDFOPNotNull) {
                fnName = "<>";
            }
        }
        if (fnName != null) {
            List<ExprNodeDesc> children = origin.getChildren();
            assert (children.size() == 1);
            ExprNodeConstantDesc defaultPartition = new ExprNodeConstantDesc(defaultPartitionName);
            children.add(defaultPartition);
            ((ExprNodeGenericFuncDesc)origin).setChildren(children);
            ((ExprNodeGenericFuncDesc)origin).setGenericUDF(FunctionRegistry.getFunctionInfo(fnName).getGenericUDF());
        } else if (origin.getChildren() != null) {
            for (ExprNodeDesc child : origin.getChildren()) {
                ExprNodeDescUtils.replaceNullFiltersWithDefaultPartition(child, defaultPartitionName);
            }
        }
    }

    public static boolean containsPredicate(ExprNodeDesc source, ExprNodeDesc predicate) {
        if (source.isSame(predicate)) {
            return true;
        }
        return FunctionRegistry.isOpAnd(source) && (ExprNodeDescUtils.containsPredicate(source.getChildren().get(0), predicate) || ExprNodeDescUtils.containsPredicate(source.getChildren().get(1), predicate));
    }

    public static ExprNodeGenericFuncDesc and(ExprNodeDesc e1, ExprNodeDesc e2) {
        return ExprNodeDescUtils.and(Arrays.asList(e1, e2));
    }

    public static ExprNodeGenericFuncDesc and(List<ExprNodeDesc> exps) {
        ArrayList<ExprNodeDesc> flatExps = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc e : exps) {
            ExprNodeDescUtils.split(e, flatExps);
        }
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPAnd(), "and", flatExps);
    }

    public static ExprNodeGenericFuncDesc murmurHash(List<ExprNodeDesc> exps) {
        assert (exps.size() >= 2);
        ExprNodeDesc hashExp = exps.get(0);
        for (int i = 1; i < exps.size(); ++i) {
            List<ExprNodeDesc> hArgs = Arrays.asList(hashExp, exps.get(i));
            hashExp = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFMurmurHash(), "hash", hArgs);
        }
        return (ExprNodeGenericFuncDesc)hashExp;
    }

    public static ExprNodeGenericFuncDesc mergePredicates(ExprNodeDesc prev, ExprNodeDesc next) {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
        if (FunctionRegistry.isOpAnd(prev)) {
            children.addAll(prev.getChildren());
        } else {
            children.add(prev);
        }
        if (FunctionRegistry.isOpAnd(next)) {
            children.addAll(next.getChildren());
        } else {
            children.add(next);
        }
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
    }

    public static ExprNodeDesc mergePredicates(List<ExprNodeDesc> exprs) {
        ExprNodeDesc prev = null;
        for (ExprNodeDesc expr : exprs) {
            if (prev == null) {
                prev = expr;
                continue;
            }
            prev = ExprNodeDescUtils.mergePredicates(prev, expr);
        }
        return prev;
    }

    public static List<ExprNodeDesc> split(ExprNodeDesc current) {
        return ExprNodeDescUtils.split(current, new ArrayList<ExprNodeDesc>());
    }

    public static List<ExprNodeDesc> split(ExprNodeDesc current, List<ExprNodeDesc> splitted) {
        if (FunctionRegistry.isOpAnd(current)) {
            for (ExprNodeDesc child : current.getChildren()) {
                ExprNodeDescUtils.split(child, splitted);
            }
            return splitted;
        }
        if (ExprNodeDescUtils.indexOf(current, splitted) < 0) {
            splitted.add(current);
        }
        return splitted;
    }

    public static String recommendInputName(ExprNodeDesc desc) {
        if (desc instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)desc).getColumn();
        }
        List<ExprNodeDesc> children = desc.getChildren();
        if (FunctionRegistry.isOpPreserveInputName(desc) && !children.isEmpty() && children.get(0) instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)children.get(0)).getColumn();
        }
        return null;
    }

    public static boolean isDeterministic(ExprNodeDesc desc) {
        if (desc instanceof ExprNodeGenericFuncDesc && !FunctionRegistry.isDeterministic(((ExprNodeGenericFuncDesc)desc).getGenericUDF())) {
            return false;
        }
        if (desc.getChildren() != null) {
            for (ExprNodeDesc child : desc.getChildren()) {
                if (ExprNodeDescUtils.isDeterministic(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static ArrayList<ExprNodeDesc> clone(List<ExprNodeDesc> sources) {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc expr : sources) {
            result.add(expr.clone());
        }
        return result;
    }

    public static ArrayList<ExprNodeDesc> backtrack(List<ExprNodeDesc> sources, Operator<?> current, Operator<?> terminal) throws SemanticException {
        return ExprNodeDescUtils.backtrack(sources, current, terminal, false);
    }

    public static ArrayList<ExprNodeDesc> backtrack(List<ExprNodeDesc> sources, Operator<?> current, Operator<?> terminal, boolean foldExpr) throws SemanticException {
        return ExprNodeDescUtils.backtrack(sources, current, terminal, foldExpr, false);
    }

    public static ArrayList<ExprNodeDesc> backtrack(List<ExprNodeDesc> sources, Operator<?> current, Operator<?> terminal, boolean foldExpr, boolean stayInSameVertex) throws SemanticException {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc expr : sources) {
            result.add(ExprNodeDescUtils.backtrack(expr, current, terminal, foldExpr, stayInSameVertex));
        }
        return result;
    }

    public static ExprNodeDesc backtrack(ExprNodeDesc source, Operator<?> current, Operator<?> terminal) throws SemanticException {
        return ExprNodeDescUtils.backtrack(source, current, terminal, false);
    }

    public static ExprNodeDesc backtrack(ExprNodeDesc source, Operator<?> current, Operator<?> terminal, boolean foldExpr) throws SemanticException {
        return ExprNodeDescUtils.backtrack(source, current, terminal, foldExpr, false);
    }

    public static ExprNodeDesc backtrack(ExprNodeDesc source, Operator<?> current, Operator<?> terminal, boolean foldExpr, boolean stayInSameVertex) throws SemanticException {
        Operator<?> parent;
        Operator<?> operator = parent = stayInSameVertex ? ExprNodeDescUtils.getSameVertexParent(current, terminal) : ExprNodeDescUtils.getSingleParent(current, terminal);
        if (parent == null) {
            return source;
        }
        if (!foldExpr && ExprNodeDescUtils.isConstant(source)) {
            return source;
        }
        if (source instanceof ExprNodeGenericFuncDesc) {
            ExprNodeDesc foldedFunction;
            ExprNodeGenericFuncDesc function = (ExprNodeGenericFuncDesc)source.clone();
            ArrayList<ExprNodeDesc> children = ExprNodeDescUtils.backtrack(function.getChildren(), current, terminal, foldExpr, stayInSameVertex);
            for (ExprNodeDesc child : children) {
                if (child != null) continue;
                return null;
            }
            function.setChildren(children);
            if (foldExpr && (foldedFunction = ConstantPropagateProcFactory.foldExpr(function)) != null) {
                return foldedFunction;
            }
            return function;
        }
        if (source instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc column = (ExprNodeColumnDesc)source;
            return ExprNodeDescUtils.backtrack(column, parent, terminal, stayInSameVertex);
        }
        if (source instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc field = (ExprNodeFieldDesc)source.clone();
            ExprNodeDesc fieldDesc = ExprNodeDescUtils.backtrack(field.getDesc(), current, terminal, foldExpr, stayInSameVertex);
            if (fieldDesc == null) {
                return null;
            }
            field.setDesc(fieldDesc);
            return field;
        }
        return source;
    }

    private static ExprNodeDesc backtrack(ExprNodeColumnDesc column, Operator<?> current, Operator<?> terminal, boolean stayInSameVertex) throws SemanticException {
        Map<String, ExprNodeDesc> mapping = current.getColumnExprMap();
        if (mapping == null) {
            return ExprNodeDescUtils.backtrack(column, current, terminal, false, stayInSameVertex);
        }
        ExprNodeDesc mapped = mapping.get(column.getColumn());
        return mapped == null ? null : ExprNodeDescUtils.backtrack(mapped, current, terminal, false, stayInSameVertex);
    }

    public static Operator<?> getSingleParent(Operator<?> current, Operator<?> terminal) throws SemanticException {
        if (current == terminal) {
            return null;
        }
        List<Operator<OperatorDesc>> parents = current.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            if (terminal != null) {
                throw new SemanticException("Failed to meet terminal operator");
            }
            return null;
        }
        if (parents.size() == 1) {
            return parents.get(0);
        }
        if (terminal != null && parents.contains(terminal)) {
            return terminal;
        }
        throw new SemanticException("Met multiple parent operators");
    }

    public static Operator<?> getSameVertexParent(Operator<?> current, Operator<?> terminal) {
        if (current == terminal) {
            return null;
        }
        List<Operator<OperatorDesc>> parents = current.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        if (parents.size() == 1) {
            return parents.get(0);
        }
        if (terminal != null && parents.contains(terminal)) {
            return terminal;
        }
        return parents.stream().filter(op -> !(op instanceof ReduceSinkOperator)).findFirst().get();
    }

    public static List<ExprNodeDesc> resolveJoinKeysAsRSColumns(List<ExprNodeDesc> sourceList, Operator<?> reduceSinkOp) {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>(sourceList.size());
        for (ExprNodeDesc source : sourceList) {
            ExprNodeDesc newExpr = ExprNodeDescUtils.resolveJoinKeysAsRSColumns(source, reduceSinkOp);
            if (newExpr == null) {
                return null;
            }
            result.add(newExpr);
        }
        return result;
    }

    public static ExprNodeDesc resolveJoinKeysAsRSColumns(ExprNodeDesc source, Operator<?> reduceSinkOp) {
        if (source == null) {
            return null;
        }
        for (Map.Entry<String, ExprNodeDesc> mapEntry : reduceSinkOp.getColumnExprMap().entrySet()) {
            String columnInternalName;
            if (!mapEntry.getValue().equals(source) || (columnInternalName = mapEntry.getKey()).startsWith(Utilities.ReduceField.VALUE.toString())) continue;
            ColumnInfo columnInfo = reduceSinkOp.getSchema().getColumnInfo(columnInternalName);
            if (source instanceof ExprNodeColumnDesc && columnInfo != null) {
                return new ExprNodeColumnDesc(columnInfo);
            }
            String tabAlias = "";
            if (source instanceof ExprNodeConstantDesc) {
                tabAlias = ((ExprNodeConstantDesc)source).getFoldedFromTab();
            }
            return new ExprNodeColumnDesc(source.getTypeInfo(), columnInternalName, tabAlias, false);
        }
        return null;
    }

    public static ExprNodeDesc[] extractComparePair(ExprNodeDesc expr1, ExprNodeDesc expr2) {
        expr1 = ExprNodeDescUtils.extractConstant(expr1);
        expr2 = ExprNodeDescUtils.extractConstant(expr2);
        if (expr1 instanceof ExprNodeColumnDesc && expr2 instanceof ExprNodeConstantDesc) {
            return new ExprNodeDesc[]{expr1, expr2};
        }
        if (expr1 instanceof ExprNodeConstantDesc && expr2 instanceof ExprNodeColumnDesc) {
            return new ExprNodeDesc[]{expr1, expr2};
        }
        if (expr1 instanceof ExprNodeFieldDesc && expr2 instanceof ExprNodeConstantDesc) {
            ExprNodeDesc[] exprNodeDescArray;
            ExprNodeColumnDesc columnDesc = ExprNodeDescUtils.extractColumn(expr1);
            if (columnDesc != null) {
                ExprNodeDesc[] exprNodeDescArray2 = new ExprNodeDesc[3];
                exprNodeDescArray2[0] = columnDesc;
                exprNodeDescArray2[1] = expr2;
                exprNodeDescArray = exprNodeDescArray2;
                exprNodeDescArray2[2] = expr1;
            } else {
                exprNodeDescArray = null;
            }
            return exprNodeDescArray;
        }
        if (expr1 instanceof ExprNodeConstantDesc && expr2 instanceof ExprNodeFieldDesc) {
            ExprNodeDesc[] exprNodeDescArray;
            ExprNodeColumnDesc columnDesc = ExprNodeDescUtils.extractColumn(expr2);
            if (columnDesc != null) {
                ExprNodeDesc[] exprNodeDescArray3 = new ExprNodeDesc[3];
                exprNodeDescArray3[0] = expr1;
                exprNodeDescArray3[1] = columnDesc;
                exprNodeDescArray = exprNodeDescArray3;
                exprNodeDescArray3[2] = expr2;
            } else {
                exprNodeDescArray = null;
            }
            return exprNodeDescArray;
        }
        return null;
    }

    public static String[] extractFields(ExprNodeFieldDesc expr) {
        return ExprNodeDescUtils.extractFields(expr, new ArrayList<String>()).toArray(new String[0]);
    }

    private static List<String> extractFields(ExprNodeDesc expr, List<String> fields) {
        if (expr instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc field = (ExprNodeFieldDesc)expr;
            fields.add(field.getFieldName());
            return ExprNodeDescUtils.extractFields(field.getDesc(), fields);
        }
        if (expr instanceof ExprNodeColumnDesc) {
            return fields;
        }
        throw new IllegalStateException("Unexpected exception while extracting fields from ExprNodeDesc");
    }

    private static ExprNodeColumnDesc extractColumn(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeColumnDesc) {
            return (ExprNodeColumnDesc)expr;
        }
        if (expr instanceof ExprNodeFieldDesc) {
            return ExprNodeDescUtils.extractColumn(((ExprNodeFieldDesc)expr).getDesc());
        }
        return null;
    }

    private static ExprNodeDesc extractConstant(ExprNodeDesc expr) {
        if (!(expr instanceof ExprNodeGenericFuncDesc)) {
            return expr;
        }
        ExprNodeConstantDesc folded = ExprNodeDescUtils.foldConstant((ExprNodeGenericFuncDesc)expr);
        return folded == null ? expr : folded;
    }

    private static ExprNodeConstantDesc foldConstant(ExprNodeGenericFuncDesc func) {
        GenericUDF udf = func.getGenericUDF();
        if (!FunctionRegistry.isConsistentWithinQuery(udf)) {
            return null;
        }
        try {
            Object internal;
            if (udf instanceof GenericUDFBridge ? (internal = (UDF)ReflectionUtils.newInstance(((GenericUDFBridge)udf).getUdfClass(), null)).getRequiredFiles() != null || internal.getRequiredJars() != null : udf.getRequiredFiles() != null || udf.getRequiredJars() != null) {
                return null;
            }
            if (func.getChildren() != null) {
                for (ExprNodeDesc child : func.getChildren()) {
                    if (child instanceof ExprNodeConstantDesc || child instanceof ExprNodeGenericFuncDesc && ExprNodeDescUtils.foldConstant((ExprNodeGenericFuncDesc)child) != null) continue;
                    return null;
                }
            }
            ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(func);
            ObjectInspector output = evaluator.initialize(null);
            Object constant = evaluator.evaluate(null);
            Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
            return new ExprNodeConstantDesc(java);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void getExprNodeColumnDesc(List<ExprNodeDesc> exprDescList, Multimap<Integer, ExprNodeColumnDesc> hashCodeTocolumnDescMap) {
        for (ExprNodeDesc exprNodeDesc : exprDescList) {
            ExprNodeDescUtils.getExprNodeColumnDesc(exprNodeDesc, hashCodeTocolumnDescMap);
        }
    }

    public static void getExprNodeColumnDesc(ExprNodeDesc exprDesc, Multimap<Integer, ExprNodeColumnDesc> hashCodeToColumnDescMap) {
        if (exprDesc instanceof ExprNodeColumnDesc) {
            Collection nodes = hashCodeToColumnDescMap.get((Object)exprDesc.hashCode());
            boolean insert = true;
            for (ExprNodeColumnDesc node : nodes) {
                if (!node.isSame(exprDesc)) continue;
                insert = false;
                break;
            }
            if (insert) {
                nodes.add((ExprNodeColumnDesc)exprDesc);
            }
        } else if (exprDesc instanceof ExprNodeColumnListDesc) {
            for (ExprNodeDesc child : exprDesc.getChildren()) {
                ExprNodeDescUtils.getExprNodeColumnDesc(child, hashCodeToColumnDescMap);
            }
        } else if (exprDesc instanceof ExprNodeGenericFuncDesc) {
            for (ExprNodeDesc child : exprDesc.getChildren()) {
                ExprNodeDescUtils.getExprNodeColumnDesc(child, hashCodeToColumnDescMap);
            }
        } else if (exprDesc instanceof ExprNodeFieldDesc) {
            ExprNodeDescUtils.getExprNodeColumnDesc(((ExprNodeFieldDesc)exprDesc).getDesc(), hashCodeToColumnDescMap);
        } else if (exprDesc instanceof ExprNodeSubQueryDesc) {
            ExprNodeDescUtils.getExprNodeColumnDesc(((ExprNodeSubQueryDesc)exprDesc).getSubQueryLhs(), hashCodeToColumnDescMap);
        }
    }

    public static boolean isConstant(ExprNodeDesc value) {
        if (value instanceof ExprNodeConstantDesc) {
            return true;
        }
        if (value instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)value;
            if (!FunctionRegistry.isConsistentWithinQuery(func.getGenericUDF())) {
                return false;
            }
            for (ExprNodeDesc child : func.getChildren()) {
                if (ExprNodeDescUtils.isConstant(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllConstants(List<ExprNodeDesc> value) {
        for (ExprNodeDesc expr : value) {
            if (expr instanceof ExprNodeConstantDesc) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullConstant(ExprNodeDesc value) {
        return value instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)value).getValue() == null;
    }

    public static PrimitiveTypeInfo deriveMinArgumentCast(ExprNodeDesc childExpr, TypeInfo targetType) {
        return ExprNodeDescUtils.deriveMinArgumentCast(childExpr.getTypeInfo(), targetType);
    }

    public static PrimitiveTypeInfo deriveMinArgumentCast(TypeInfo childTi, TypeInfo targetType) {
        assert (targetType instanceof PrimitiveTypeInfo) : "Not a primitive type" + targetType;
        PrimitiveTypeInfo pti = (PrimitiveTypeInfo)targetType;
        if (pti.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL || !(childTi instanceof PrimitiveTypeInfo)) {
            return pti;
        }
        return HiveDecimalUtils.getDecimalTypeForPrimitiveCategory((PrimitiveTypeInfo)((PrimitiveTypeInfo)childTi));
    }

    public static ArrayList<ExprNodeDesc> genExprNodeDesc(Operator inputOp, int startPos, int endPos, boolean addEmptyTabAlias, boolean setColToNonVirtual) {
        ArrayList<ExprNodeDesc> exprColLst = new ArrayList<ExprNodeDesc>();
        List<ColumnInfo> colInfoLst = inputOp.getSchema().getSignature();
        for (int i = startPos; i <= endPos; ++i) {
            ColumnInfo ci = colInfoLst.get(i);
            String tabAlias = ci.getTabAlias();
            if (addEmptyTabAlias) {
                tabAlias = "";
            }
            boolean vc = ci.getIsVirtualCol();
            if (setColToNonVirtual) {
                vc = false;
            }
            exprColLst.add(new ExprNodeColumnDesc(ci.getType(), ci.getInternalName(), tabAlias, vc));
        }
        return exprColLst;
    }

    public static List<ExprNodeDesc> flattenExprList(List<ExprNodeDesc> sourceList) {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>(sourceList.size());
        for (ExprNodeDesc source : sourceList) {
            result.add(ExprNodeDescUtils.flattenExpr(source));
        }
        return result;
    }

    public static ExprNodeDesc flattenExpr(ExprNodeDesc source) {
        if (source instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc function = (ExprNodeGenericFuncDesc)source.clone();
            List<ExprNodeDesc> newChildren = ExprNodeDescUtils.flattenExprList(function.getChildren());
            for (ExprNodeDesc newChild : newChildren) {
                if (newChild != null) continue;
                return null;
            }
            function.setChildren(newChildren);
            return function;
        }
        if (source instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc column = (ExprNodeColumnDesc)source;
            String newColumn = column.getColumn().replace('.', '_');
            return new ExprNodeColumnDesc(source.getTypeInfo(), newColumn, column.getTabAlias(), false);
        }
        if (source instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc field = (ExprNodeFieldDesc)source.clone();
            ExprNodeDesc fieldDesc = ExprNodeDescUtils.flattenExpr(field.getDesc());
            if (fieldDesc == null) {
                return null;
            }
            field.setDesc(fieldDesc);
            return field;
        }
        return source;
    }

    public static String extractColName(ExprNodeDesc root) {
        if (root instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)root).getColumn();
        }
        if (root.getChildren() == null) {
            return null;
        }
        String column = null;
        for (ExprNodeDesc d : root.getChildren()) {
            String candidate = ExprNodeDescUtils.extractColName(d);
            if (column != null && candidate != null) {
                return null;
            }
            if (candidate == null) continue;
            column = candidate;
        }
        return column;
    }

    public static ExprNodeColumnDesc getColumnExpr(ExprNodeDesc expr) {
        while (FunctionRegistry.isOpCast(expr)) {
            expr = expr.getChildren().get(0);
        }
        return expr instanceof ExprNodeColumnDesc ? (ExprNodeColumnDesc)expr : null;
    }

    public static Set<ExprNodeColumnDesc> findAllColumnDescs(ExprNodeDesc expr) {
        HashSet<ExprNodeColumnDesc> ret = new HashSet<ExprNodeColumnDesc>();
        ExprNodeDescUtils.findAllColumnDescs(ret, expr);
        return ret;
    }

    private static void findAllColumnDescs(Set<ExprNodeColumnDesc> ret, ExprNodeDesc expr) {
        if (expr instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)expr;
            for (ExprNodeDesc c : func.getChildren()) {
                ExprNodeDescUtils.findAllColumnDescs(ret, c);
            }
        }
        if (expr instanceof ExprNodeColumnDesc) {
            ret.add((ExprNodeColumnDesc)expr);
        }
    }

    public static ExprNodeDesc findConstantExprOrigin(String dpCol, Operator<? extends OperatorDesc> op) {
        ExprNodeDesc foldedExpr;
        ExprNodeDesc expr = op.getColumnExprMap().get(dpCol);
        if (expr instanceof ExprNodeGenericFuncDesc) {
            foldedExpr = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)expr);
            if (foldedExpr == null) {
                foldedExpr = expr;
            }
        } else {
            foldedExpr = expr;
        }
        if (foldedExpr instanceof ExprNodeColumnDesc) {
            Operator<OperatorDesc> originOp = null;
            for (Operator<OperatorDesc> parentOp : op.getParentOperators()) {
                if (parentOp.getColumnExprMap() == null) continue;
                originOp = parentOp;
                break;
            }
            if (originOp != null) {
                return ExprNodeDescUtils.findConstantExprOrigin(((ExprNodeColumnDesc)foldedExpr).getColumn(), originOp);
            }
        }
        return foldedExpr;
    }

    public static boolean checkPrefixKeys(List<ExprNodeDesc> childKeys, List<ExprNodeDesc> parentKeys, Operator<? extends OperatorDesc> childOp, Operator<? extends OperatorDesc> parentOp) throws SemanticException {
        return ExprNodeDescUtils.checkPrefixKeys(childKeys, parentKeys, childOp, parentOp, false);
    }

    public static boolean checkPrefixKeysUpstream(List<ExprNodeDesc> childKeys, List<ExprNodeDesc> parentKeys, Operator<? extends OperatorDesc> childOp, Operator<? extends OperatorDesc> parentOp) throws SemanticException {
        return ExprNodeDescUtils.checkPrefixKeys(childKeys, parentKeys, childOp, parentOp, true);
    }

    private static boolean checkPrefixKeys(List<ExprNodeDesc> childKeys, List<ExprNodeDesc> parentKeys, Operator<? extends OperatorDesc> childOp, Operator<? extends OperatorDesc> parentOp, boolean upstream) throws SemanticException {
        int size;
        if (childKeys == null || childKeys.isEmpty()) {
            return parentKeys == null || parentKeys.isEmpty();
        }
        if (parentKeys == null || parentKeys.isEmpty()) {
            return false;
        }
        if (upstream) {
            if (childKeys.size() > parentKeys.size()) {
                return false;
            }
            size = childKeys.size();
        } else {
            if (parentKeys.size() > childKeys.size()) {
                return false;
            }
            size = parentKeys.size();
        }
        for (int i = 0; i < size; ++i) {
            ExprNodeDesc expr = ExprNodeDescUtils.backtrack(childKeys.get(i), childOp, parentOp);
            if (expr == null) {
                return false;
            }
            if (expr.isSame(parentKeys.get(i))) continue;
            return false;
        }
        return true;
    }

    private static ExprNodeDesc findParentExpr(ExprNodeColumnDesc col, Operator<?> op) {
        ExprNodeDesc parentExpr = col;
        Map<String, ExprNodeDesc> mapping = op.getColumnExprMap();
        if (mapping != null && (parentExpr = mapping.get(col.getColumn())) == null && op instanceof ReduceSinkOperator) {
            return col;
        }
        return parentExpr;
    }

    public static ColumnOrigin findColumnOrigin(ExprNodeDesc expr, Operator<?> op) {
        if (expr == null || op == null) {
            return null;
        }
        ExprNodeColumnDesc col = ExprNodeDescUtils.getColumnExpr(expr);
        if (col == null) {
            return null;
        }
        Operator<OperatorDesc> parentOp = null;
        int numParents = op.getNumParent();
        if (numParents == 0) {
            return new ColumnOrigin(col, op);
        }
        ExprNodeDesc parentExpr = ExprNodeDescUtils.findParentExpr(col, op);
        if (parentExpr == null) {
            return null;
        }
        if (numParents == 1) {
            parentOp = op.getParentOperators().get(0);
        } else {
            ExprNodeColumnDesc parentCol = ExprNodeDescUtils.getColumnExpr(parentExpr);
            if (parentCol != null) {
                for (Operator<OperatorDesc> currParent : op.getParentOperators()) {
                    RowSchema schema = currParent.getSchema();
                    if (schema == null) {
                        return null;
                    }
                    if (!schema.getTableNames().contains(parentCol.getTabAlias())) continue;
                    parentOp = currParent;
                    break;
                }
            }
        }
        if (parentOp == null) {
            return null;
        }
        return ExprNodeDescUtils.findColumnOrigin(parentExpr, parentOp);
    }

    public static boolean isSame(ExprNodeDesc desc1, ExprNodeDesc desc2) {
        return desc1 == desc2 || desc1 != null && desc1.isSame(desc2);
    }

    public static boolean isSame(List<ExprNodeDesc> first, List<ExprNodeDesc> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null || first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i).isSame(second.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isIntegerType(ExprNodeDesc expr) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        TypeInfo typeInfo = expr.getTypeInfo();
        return typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) == PrimitiveObjectInspector.PrimitiveCategory.INT || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.SHORT || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.BYTE || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.LONG);
    }

    public static boolean isConstantStruct(ExprNodeDesc valueDesc) {
        return valueDesc instanceof ExprNodeConstantDesc && valueDesc.getTypeInfo() instanceof StructTypeInfo;
    }

    public static boolean isStructUDF(ExprNodeDesc columnDesc) {
        if (columnDesc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)columnDesc;
            return exprNodeGenericFuncDesc.getGenericUDF() instanceof GenericUDFStruct;
        }
        return false;
    }

    public static ExprNodeDesc conjunction(List<ExprNodeDesc> inputExpr) throws UDFArgumentException {
        ArrayList<ExprNodeDesc> operands = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc e : inputExpr) {
            ExprNodeDescUtils.conjunctiveDecomposition(e, operands);
        }
        for (int i = 0; i < operands.size(); ++i) {
            ExprNodeDesc curr = (ExprNodeDesc)operands.get(i);
            if (!ExprNodeDescUtils.isOr(curr) || !ExprNodeDescUtils.deterministicIntersection(curr.getChildren(), operands)) continue;
            operands.remove(i);
            --i;
        }
        if (operands.isEmpty()) {
            return null;
        }
        if (operands.size() > 1) {
            return ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPAnd(), operands);
        }
        return (ExprNodeDesc)operands.get(0);
    }

    private static boolean deterministicIntersection(List<ExprNodeDesc> li1, List<ExprNodeDesc> li2) {
        for (ExprNodeDesc e1 : li1) {
            if (!ExprNodeDescUtils.isDeterministic(e1)) continue;
            for (ExprNodeDesc e2 : li2) {
                if (!e1.isSame(e2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void conjunctiveDecomposition(ExprNodeDesc expr, List<ExprNodeDesc> operands) {
        if (ExprNodeDescUtils.isAnd(expr)) {
            for (ExprNodeDesc c : expr.getChildren()) {
                ExprNodeDescUtils.conjunctiveDecomposition(c, operands);
            }
        } else {
            if (ExprNodeDescUtils.isTrue(expr)) {
                return;
            }
            for (ExprNodeDesc o : operands) {
                if (!o.isSame(expr)) continue;
                return;
            }
            operands.add(expr);
        }
    }

    private static boolean isTrue(ExprNodeDesc expr) {
        ExprNodeConstantDesc c;
        return expr instanceof ExprNodeConstantDesc && Boolean.TRUE.equals((c = (ExprNodeConstantDesc)expr).getValue());
    }

    public static ExprNodeDesc conjunction(ExprNodeDesc node1, ExprNodeDesc node2) throws UDFArgumentException {
        ArrayList operands = Lists.newArrayList((Object[])new ExprNodeDesc[]{node1, node2});
        return ExprNodeDescUtils.conjunction(operands);
    }

    public static ExprNodeDesc conjunction(List<ExprNodeDesc> nodes, ExprNodeDesc exprNode) throws UDFArgumentException {
        if (nodes == null) {
            return exprNode;
        }
        ArrayList<ExprNodeDesc> operands = new ArrayList<ExprNodeDesc>();
        if (exprNode != null) {
            operands.add(exprNode);
        }
        operands.addAll(nodes);
        return ExprNodeDescUtils.conjunction(operands);
    }

    public static ExprNodeDesc disjunction(ExprNodeDesc e1, ExprNodeDesc e2) throws UDFArgumentException {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        if (e1.isSame(e2)) {
            return e1;
        }
        ArrayList<ExprNodeDesc> operands = new ArrayList<ExprNodeDesc>();
        ExprNodeDescUtils.disjunctiveDecomposition(e1, operands);
        ExprNodeDescUtils.disjunctiveDecomposition(e2, operands);
        return ExprNodeDescUtils.disjunction(operands);
    }

    public static ExprNodeDesc disjunction(List<ExprNodeDesc> operands) throws UDFArgumentException {
        if (operands.size() == 0) {
            return null;
        }
        if (operands.size() == 1) {
            return operands.get(0);
        }
        return ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPOr(), operands);
    }

    public static void disjunctiveDecomposition(ExprNodeDesc expr, List<ExprNodeDesc> operands) {
        if (ExprNodeDescUtils.isOr(expr)) {
            for (ExprNodeDesc c : expr.getChildren()) {
                ExprNodeDescUtils.disjunctiveDecomposition(c, operands);
            }
        } else {
            for (ExprNodeDesc o : operands) {
                if (!o.isSame(expr)) continue;
                return;
            }
            operands.add(expr);
        }
    }

    public static boolean isOr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)expr;
            return exprNodeGenericFuncDesc.getGenericUDF() instanceof GenericUDFOPOr;
        }
        return false;
    }

    public static boolean isAnd(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)expr;
            return exprNodeGenericFuncDesc.getGenericUDF() instanceof GenericUDFOPAnd;
        }
        return false;
    }

    public static ExprNodeDesc replaceTabAlias(ExprNodeDesc expr, String oldAlias, String newAlias) {
        ExprNodeColumnDesc exprNodeColumnDesc;
        if (expr == null) {
            return null;
        }
        if (expr.getChildren() != null) {
            for (ExprNodeDesc c : expr.getChildren()) {
                ExprNodeDescUtils.replaceTabAlias(c, oldAlias, newAlias);
            }
        }
        if (expr instanceof ExprNodeColumnDesc && (exprNodeColumnDesc = (ExprNodeColumnDesc)expr).getTabAlias() != null && exprNodeColumnDesc.getTabAlias().equals(oldAlias)) {
            exprNodeColumnDesc.setTabAlias(newAlias);
        }
        return expr;
    }

    public static void replaceTabAlias(Map<String, ExprNodeDesc> exprMap, String oldAlias, String newAlias) {
        if (exprMap != null) {
            ExprNodeDescUtils.replaceTabAlias(exprMap.values(), oldAlias, newAlias);
        }
    }

    public static void replaceTabAlias(Collection<ExprNodeDesc> exprs, String oldAlias, String newAlias) {
        if (exprs != null) {
            for (ExprNodeDesc expr : exprs) {
                ExprNodeDescUtils.replaceTabAlias(expr, oldAlias, newAlias);
            }
        }
    }

    public static class ColumnOrigin {
        public ExprNodeColumnDesc col;
        public Operator<?> op;

        public ColumnOrigin(ExprNodeColumnDesc col, Operator<?> op) {
            this.col = col;
            this.op = op;
        }
    }
}

