/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class DynamicPartitionCtx
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> partSpec;
    private int numDPCols;
    private int numSPCols;
    private String spPath;
    private Path rootPath;
    private int numBuckets;
    private List<String> spNames;
    private List<String> dpNames;
    private String defaultPartName;
    private int maxPartsPerNode;
    private Pattern whiteListPattern;
    private boolean hasCustomSortExpr = false;
    private transient List<Function<List<ExprNodeDesc>, ExprNodeDesc>> customSortExpressions;
    private transient List<Integer> customSortOrder;
    private transient List<Integer> customSortNullOrder;

    public DynamicPartitionCtx() {
    }

    public DynamicPartitionCtx(List<String> partColNames, String defaultPartName, int maxParts) throws SemanticException {
        String confVal;
        this.partSpec = new LinkedHashMap<String, String>();
        this.spNames = new ArrayList<String>();
        this.dpNames = new ArrayList<String>();
        for (String colName : partColNames) {
            this.partSpec.put(colName, null);
            this.dpNames.add(colName);
        }
        this.numBuckets = 0;
        this.maxPartsPerNode = maxParts;
        this.defaultPartName = defaultPartName;
        this.numDPCols = this.dpNames.size();
        this.numSPCols = this.spNames.size();
        this.spPath = null;
        try {
            confVal = Hive.get().getMetaConf(MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN.getHiveName());
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        this.whiteListPattern = confVal == null || confVal.isEmpty() ? null : Pattern.compile(confVal);
        this.customSortExpressions = new LinkedList<Function<List<ExprNodeDesc>, ExprNodeDesc>>();
        this.customSortOrder = new LinkedList<Integer>();
        this.customSortNullOrder = new LinkedList<Integer>();
    }

    public DynamicPartitionCtx(Map<String, String> partSpec, String defaultPartName, int maxParts) throws SemanticException {
        String confVal;
        this.partSpec = partSpec;
        this.spNames = new ArrayList<String>();
        this.dpNames = new ArrayList<String>();
        this.numBuckets = 0;
        this.maxPartsPerNode = maxParts;
        this.defaultPartName = defaultPartName;
        for (Map.Entry<String, String> me : partSpec.entrySet()) {
            if (me.getValue() == null) {
                this.dpNames.add(me.getKey());
                continue;
            }
            this.spNames.add(me.getKey());
        }
        this.numDPCols = this.dpNames.size();
        this.numSPCols = this.spNames.size();
        this.spPath = this.numSPCols > 0 ? Warehouse.makeDynamicPartName(partSpec) : null;
        try {
            confVal = Hive.get().getMetaConf(MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN.getHiveName());
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        this.whiteListPattern = confVal == null || confVal.isEmpty() ? null : Pattern.compile(confVal);
        this.customSortExpressions = new LinkedList<Function<List<ExprNodeDesc>, ExprNodeDesc>>();
        this.customSortOrder = new LinkedList<Integer>();
        this.customSortNullOrder = new LinkedList<Integer>();
    }

    public DynamicPartitionCtx(DynamicPartitionCtx dp) {
        this.partSpec = dp.partSpec;
        this.numDPCols = dp.numDPCols;
        this.numSPCols = dp.numSPCols;
        this.spPath = dp.spPath;
        this.rootPath = dp.rootPath;
        this.numBuckets = dp.numBuckets;
        this.spNames = dp.spNames;
        this.dpNames = dp.dpNames;
        this.defaultPartName = dp.defaultPartName;
        this.maxPartsPerNode = dp.maxPartsPerNode;
        this.whiteListPattern = dp.whiteListPattern;
        this.customSortExpressions = new LinkedList<Function<List<ExprNodeDesc>, ExprNodeDesc>>();
        this.addCustomSortExpressions(dp.customSortExpressions);
        this.customSortOrder = dp.customSortOrder;
        this.customSortNullOrder = dp.customSortNullOrder;
    }

    public Pattern getWhiteListPattern() {
        return this.whiteListPattern;
    }

    public int getMaxPartitionsPerNode() {
        return this.maxPartsPerNode;
    }

    public void setMaxPartitionsPerNode(int maxParts) {
        this.maxPartsPerNode = maxParts;
    }

    public String getDefaultPartitionName() {
        return this.defaultPartName;
    }

    public void setDefaultPartitionName(String pname) {
        this.defaultPartName = pname;
    }

    public void setNumBuckets(int bk) {
        this.numBuckets = bk;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setRootPath(Path root) {
        this.rootPath = root;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public List<String> getDPColNames() {
        return this.dpNames;
    }

    public void setDPColNames(List<String> dp) {
        this.dpNames = dp;
    }

    public List<String> getSPColNames() {
        return this.spNames;
    }

    public void setPartSpec(Map<String, String> ps) {
        this.partSpec = ps;
    }

    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public void setSPColNames(List<String> sp) {
        this.spNames = sp;
    }

    public void setNumDPCols(int dp) {
        this.numDPCols = dp;
    }

    public int getNumDPCols() {
        return this.numDPCols;
    }

    public void setNumSPCols(int sp) {
        this.numSPCols = sp;
    }

    public int getNumSPCols() {
        return this.numSPCols;
    }

    public void setSPPath(String sp) {
        this.spPath = sp;
    }

    public String getSPPath() {
        return this.spPath;
    }

    public List<Function<List<ExprNodeDesc>, ExprNodeDesc>> getCustomSortExpressions() {
        return this.customSortExpressions;
    }

    public void addCustomSortExpressions(List<Function<List<ExprNodeDesc>, ExprNodeDesc>> customSortExpressions) {
        if (!CollectionUtils.isEmpty(customSortExpressions)) {
            this.hasCustomSortExpr = true;
            this.customSortExpressions.addAll(customSortExpressions);
        }
    }

    public List<Integer> getCustomSortOrder() {
        return this.customSortOrder;
    }

    public void setCustomSortOrder(List<Integer> customSortOrder) {
        this.customSortOrder = customSortOrder;
    }

    public List<Integer> getCustomSortNullOrder() {
        return this.customSortNullOrder;
    }

    public void setCustomSortNullOrder(List<Integer> customSortNullOrder) {
        this.customSortNullOrder = customSortNullOrder;
    }

    public boolean hasCustomSortExpression() {
        return this.hasCustomSortExpr;
    }
}

