/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.SkewJoinProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkewJoinResolver
implements PhysicalPlanResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SkewJoinResolver.class);

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        SkewJoinTaskDispatcher disp = new SkewJoinTaskDispatcher(pctx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    class SkewJoinTaskDispatcher
    implements SemanticDispatcher {
        private PhysicalContext physicalContext;

        public SkewJoinTaskDispatcher(PhysicalContext context) {
            this.physicalContext = context;
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task task = (Task)nd;
            if (!task.isMapRedTask() || task instanceof ConditionalTask || ((MapredWork)task.getWork()).getReduceWork() == null) {
                return null;
            }
            ParseContext pc = this.physicalContext.getParseContext();
            if (pc.getLoadTableWork() != null) {
                for (LoadTableDesc ltd : pc.getLoadTableWork()) {
                    if (!ltd.isMmTable()) continue;
                    LOG.debug("Not using skew join because the destination table " + ltd.getTable().getTableName() + " is an insert_only table");
                    return null;
                }
            }
            if (pc.getLoadFileWork() != null) {
                for (LoadFileDesc lfd : pc.getLoadFileWork()) {
                    if (!lfd.isMmCtas()) continue;
                    LOG.debug("Not using skew join because the destination table is an insert_only table");
                    return null;
                }
            }
            SkewJoinProcCtx skewJoinProcContext = new SkewJoinProcCtx(task, pc);
            LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
            opRules.put(new RuleRegExp("R1", CommonJoinOperator.getOperatorName() + "%"), SkewJoinProcFactory.getJoinProc());
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(SkewJoinProcFactory.getDefaultProc(), opRules, skewJoinProcContext);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            if (((MapredWork)task.getWork()).getReduceWork() != null) {
                topNodes.add(((MapredWork)task.getWork()).getReduceWork().getReducer());
            }
            ogw.startWalking(topNodes, null);
            return null;
        }

        public PhysicalContext getPhysicalContext() {
            return this.physicalContext;
        }

        public void setPhysicalContext(PhysicalContext physicalContext) {
            this.physicalContext = physicalContext;
        }
    }

    public static class SkewJoinProcCtx
    implements NodeProcessorCtx {
        private Task<?> currentTask;
        private ParseContext parseCtx;

        public SkewJoinProcCtx(Task<?> task, ParseContext parseCtx) {
            this.currentTask = task;
            this.parseCtx = parseCtx;
        }

        public Task<?> getCurrentTask() {
            return this.currentTask;
        }

        public void setCurrentTask(Task<?> currentTask) {
            this.currentTask = currentTask;
        }

        public ParseContext getParseCtx() {
            return this.parseCtx;
        }

        public void setParseCtx(ParseContext parseCtx) {
            this.parseCtx = parseCtx;
        }
    }
}

