/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.NullScanFileSystem;
import org.apache.hadoop.hive.ql.io.OneNullRowInputFormat;
import org.apache.hadoop.hive.ql.io.ZeroRowsInputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.PreOrderOnceWalker;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.NullStructSerDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullScanTaskDispatcher
implements SemanticDispatcher {
    static final Logger LOG = LoggerFactory.getLogger(NullScanTaskDispatcher.class);
    private final int maxAsyncLookupCount;
    private final PhysicalContext physicalContext;
    private final Map<SemanticRule, SemanticNodeProcessor> rules;

    public NullScanTaskDispatcher(PhysicalContext context, Map<SemanticRule, SemanticNodeProcessor> rules) {
        this.physicalContext = context;
        this.rules = rules;
        this.maxAsyncLookupCount = this.physicalContext.getConf().getIntVar(HiveConf.ConfVars.HIVE_COMPUTE_SPLITS_NUM_THREADS);
    }

    private String getAliasForTableScanOperator(MapWork work, TableScanOperator tso) {
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : work.getAliasToWork().entrySet()) {
            if (entry.getValue() != tso) continue;
            return entry.getKey();
        }
        return null;
    }

    private void lookupAndProcessPath(MapWork work, Path path, Collection<String> aliasesToOptimize) {
        try {
            boolean isEmpty = Utilities.listNonHiddenFileStatus((Configuration)this.physicalContext.getConf(), path).length == 0;
            this.processPath(work, path, aliasesToOptimize, isEmpty);
        }
        catch (IOException e) {
            LOG.warn("Could not determine if path {} was empty.Cannot use null scan optimization for this path.", (Object)path, (Object)e);
        }
    }

    private synchronized void processPath(MapWork work, Path path, Collection<String> aliasesToOptimize, boolean isEmpty) {
        PartitionDesc partDesc = work.getPathToPartitionInfo().get(path).clone();
        partDesc.setInputFileFormatClass(isEmpty ? ZeroRowsInputFormat.class : OneNullRowInputFormat.class);
        partDesc.setOutputFileFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        partDesc.getProperties().setProperty("serialization.lib", NullStructSerDe.class.getName());
        Path fakePath = new Path(NullScanFileSystem.getBase() + partDesc.getTableName() + "/part" + this.encode(partDesc.getPartSpec()));
        StringInternUtils.internUriStringsInPath((Path)fakePath);
        work.addPathToPartitionInfo(fakePath, partDesc);
        work.addPathToAlias(fakePath, new ArrayList<String>(aliasesToOptimize));
        Collection aliasesContainingPath = work.getPathToAliases().get(path);
        aliasesContainingPath.removeAll(aliasesToOptimize);
        if (aliasesContainingPath.isEmpty()) {
            work.removePathToAlias(path);
            work.removePathToPartitionInfo(path);
        }
    }

    private void processTableScans(MapWork work, Set<TableScanOperator> tableScans) {
        HashMap<Path, Boolean> managedEmptyPathMap = new HashMap<Path, Boolean>();
        HashMap<Path, Collection> candidatePathsToAliases = new HashMap<Path, Collection>();
        HashMap<String, Boolean> aliasTypeMap = new HashMap<String, Boolean>();
        HashMap<String, Map<Path, Partition>> allowedAliasesToPartitions = new HashMap<String, Map<Path, Partition>>();
        int numberOfUnmanagedPaths = 0;
        for (TableScanOperator tso : tableScans) {
            if (((TableScanDesc)tso.getConf()).getTableMetadata().getStorageHandler() != null) continue;
            String alias = this.getAliasForTableScanOperator(work, tso);
            boolean isManagedTable = !MetaStoreUtils.isExternalTable((Table)((TableScanDesc)tso.getConf()).getTableMetadata().getTTable());
            aliasTypeMap.put(alias, isManagedTable);
            allowedAliasesToPartitions.put(alias, this.getPathToPartitionMap(alias, tso));
            ((TableScanDesc)tso.getConf()).setIsMetadataOnly(true);
        }
        for (Path path : work.getPaths()) {
            List<String> aliases = work.getPathToAliases().get(path);
            for (String string : aliases) {
                Map map = (Map)allowedAliasesToPartitions.get(string);
                if (map == null) continue;
                candidatePathsToAliases.computeIfAbsent(path, k -> new ArrayList()).add(string);
                Partition partitionObject = (Partition)map.get(path);
                Map<String, String> partitionParameters = partitionObject != null ? partitionObject.getParameters() : null;
                boolean isManagedTable = (Boolean)aliasTypeMap.get(string);
                if (isManagedTable && partitionParameters != null && StatsSetupConst.areBasicStatsUptoDate(partitionParameters)) {
                    long rwCount = Long.parseLong(partitionParameters.get("numRows"));
                    if (rwCount == 0L) {
                        managedEmptyPathMap.put(path, true);
                        continue;
                    }
                    managedEmptyPathMap.put(path, false);
                    continue;
                }
                ++numberOfUnmanagedPaths;
            }
        }
        int fetcherPoolParallelism = Math.min(this.maxAsyncLookupCount, numberOfUnmanagedPaths);
        ExecutorService executorService = null;
        if (fetcherPoolParallelism > 1) {
            executorService = Executors.newFixedThreadPool(fetcherPoolParallelism, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NullScanOptimizer_lookup#%d").build());
        }
        ArrayList lookupFutures = new ArrayList(numberOfUnmanagedPaths);
        for (Map.Entry entry : candidatePathsToAliases.entrySet()) {
            Path path = (Path)entry.getKey();
            Collection allowed = (Collection)entry.getValue();
            Boolean isEmpty = (Boolean)managedEmptyPathMap.get(path);
            if (isEmpty == null) {
                if (executorService != null) {
                    Future<?> f = executorService.submit(() -> this.lookupAndProcessPath(work, path, allowed));
                    lookupFutures.add(f);
                    continue;
                }
                this.lookupAndProcessPath(work, path, allowed);
                continue;
            }
            this.processPath(work, path, allowed, isEmpty);
        }
        try {
            for (Future future : lookupFutures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            for (Future future : lookupFutures) {
                future.cancel(true);
            }
            LOG.error("NullScanOptimizer could not complete. It may miss eliminating some null scans", (Throwable)e);
        }
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    private Map<Path, Partition> getPathToPartitionMap(String alias, TableScanOperator tso) {
        HashMap<Path, Partition> pathToPartitionMap = new HashMap<Path, Partition>();
        try {
            Set<Partition> partitions = this.physicalContext.getParseContext().getPrunedPartitions(alias, tso).getPartitions();
            for (Partition partition : partitions) {
                pathToPartitionMap.put(partition.getPartitionPath(), partition);
            }
        }
        catch (SemanticException e) {
            LOG.warn("Error while determining partitions of {}.We cannot determine its empty partitions from stats.", (Object)alias, (Object)e);
        }
        return pathToPartitionMap;
    }

    private String encode(Map<String, String> partSpec) {
        return partSpec.toString().replaceAll("[{}:/#\\?, ]+", "_");
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
        Task task = (Task)nd;
        ParseContext parseContext = this.physicalContext.getParseContext();
        MetadataOnlyOptimizer.WalkerCtx walkerCtx = new MetadataOnlyOptimizer.WalkerCtx();
        ArrayList<MapWork> mapWorks = new ArrayList<MapWork>(task.getMapWork());
        Collections.sort(mapWorks, new Comparator<MapWork>(){

            @Override
            public int compare(MapWork o1, MapWork o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (MapWork mapWork : mapWorks) {
            LOG.debug("Looking at: {}", (Object)mapWork.getName());
            Collection<Operator<? extends OperatorDesc>> topOperators = mapWork.getAliasToWork().values();
            if (topOperators.isEmpty()) {
                LOG.debug("No top operators");
                return null;
            }
            LOG.debug("Looking for table scans where optimization is applicable");
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, this.rules, walkerCtx);
            PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            Collection<TableScanOperator> topOps = parseContext.getTopOps().values();
            for (Operator<? extends OperatorDesc> workOperator : topOperators) {
                if (!topOps.contains(workOperator)) continue;
                topNodes.add(workOperator);
            }
            Operator<OperatorDesc> reducer = task.getReducer(mapWork);
            if (reducer != null) {
                topNodes.add(reducer);
            }
            ogw.startWalking(topNodes, null);
            int scanTableSize = walkerCtx.getMetadataOnlyTableScans().size();
            LOG.debug("Found {} null table scans", (Object)scanTableSize);
            if (scanTableSize <= 0) continue;
            this.processTableScans(mapWork, walkerCtx.getMetadataOnlyTableScans());
        }
        return null;
    }
}

