/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewsCache;
import org.apache.hadoop.hive.ql.metadata.RewriteAlgorithm;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.IncrementalRebuildMode;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.MaterializedViewIncrementalRewritingRelVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CBOPlan;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QueryTables;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveMaterializedViewsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMaterializedViewsRegistry.class);
    private static final String CLASS_NAME = HiveMaterializedViewsRegistry.class.getName();
    private static final HiveMaterializedViewsRegistry SINGLETON = new HiveMaterializedViewsRegistry();
    private final MaterializedViewsCache materializedViewsCache = new MaterializedViewsCache();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    private HiveMaterializedViewsRegistry() {
    }

    public static HiveMaterializedViewsRegistry get() {
        return SINGLETON;
    }

    public void init() {
        try {
            HiveConf conf = new HiveConf();
            conf.set(MetastoreConf.ConfVars.FILTER_HOOK.getVarname(), DefaultMetaStoreFilterHookImpl.class.getName());
            this.init(Hive.get(conf));
        }
        catch (HiveException e) {
            LOG.error("Problem connecting to the metastore when initializing the view registry", (Throwable)e);
        }
    }

    public void init(Hive db) {
        boolean dummy = db.getConf().get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (dummy) {
            this.initialized.set(true);
            LOG.info("Using dummy materialized views registry");
        } else {
            long period = HiveConf.getTimeVar((Configuration)db.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_REFRESH, (TimeUnit)TimeUnit.SECONDS);
            ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HiveMaterializedViewsRegistry-%d").build());
            pool.scheduleAtFixedRate(new Loader(db), 0L, period, TimeUnit.SECONDS);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public HiveRelOptMaterialization createMaterialization(HiveConf conf, Table materializedViewTable) {
        CBOPlan plan;
        String viewQuery = materializedViewTable.getViewExpandedText();
        RelNode viewScan = HiveMaterializedViewsRegistry.createMaterializedViewScan(conf, materializedViewTable);
        if (viewScan == null) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error creating view replacement");
            return null;
        }
        try {
            plan = ParseUtils.parseQuery(this.createContext(conf), viewQuery);
        }
        catch (Exception e) {
            LOG.warn("Materialized view " + materializedViewTable.getCompleteName() + " ignored; error parsing original query; " + e);
            return null;
        }
        return new HiveRelOptMaterialization(viewScan, plan.getPlan(), null, viewScan.getTable().getQualifiedName(), plan.getSupportedRewriteAlgorithms(), this.determineIncrementalRebuildMode(plan.getPlan()), plan.getAst());
    }

    private IncrementalRebuildMode determineIncrementalRebuildMode(RelNode definitionPlan) {
        return new MaterializedViewIncrementalRewritingRelVisitor().go(definitionPlan).getIncrementalRebuildMode();
    }

    public void createMaterializedView(HiveConf conf, Table materializedViewTable) {
        boolean cache;
        boolean bl = cache = !conf.get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (!cache) {
            return;
        }
        if (!materializedViewTable.isRewriteEnabled()) {
            LOG.debug("Materialized view " + materializedViewTable.getCompleteName() + " ignored; it is not rewrite enabled");
            return;
        }
        HiveRelOptMaterialization materialization = this.createMaterialization(conf, materializedViewTable);
        if (materialization == null || materialization.getScope().isEmpty()) {
            return;
        }
        this.materializedViewsCache.putIfAbsent(materializedViewTable, materialization);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created materialized view for rewriting: " + materializedViewTable.getFullyQualifiedName());
        }
    }

    public void refreshMaterializedView(HiveConf conf, Table materializedViewTable) {
        HiveRelOptMaterialization cached = this.materializedViewsCache.get(materializedViewTable.getDbName(), materializedViewTable.getTableName());
        if (cached == null) {
            return;
        }
        Table cachedTable = HiveMaterializedViewUtils.extractTable(cached);
        this.refreshMaterializedView(conf, cachedTable, materializedViewTable);
    }

    public void refreshMaterializedView(HiveConf conf, Table oldMaterializedViewTable, Table materializedViewTable) {
        boolean cache;
        boolean bl = cache = !conf.get(HiveConf.ConfVars.HIVE_SERVER2_MATERIALIZED_VIEWS_REGISTRY_IMPL.varname).equals("DUMMY");
        if (!cache) {
            return;
        }
        if (!materializedViewTable.isRewriteEnabled()) {
            this.dropMaterializedView(oldMaterializedViewTable);
            LOG.debug("Materialized view " + materializedViewTable.getCompleteName() + " dropped; it is not rewrite enabled");
            return;
        }
        HiveRelOptMaterialization newMaterialization = this.createMaterialization(conf, materializedViewTable);
        if (newMaterialization == null) {
            return;
        }
        this.materializedViewsCache.refresh(oldMaterializedViewTable, materializedViewTable, newMaterialization);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Materialized view refreshed: " + materializedViewTable.getFullyQualifiedName());
        }
    }

    public void dropMaterializedView(Table materializedViewTable) {
        this.materializedViewsCache.remove(materializedViewTable);
    }

    public void dropMaterializedView(String dbName, String tableName) {
        this.materializedViewsCache.remove(dbName, tableName);
    }

    List<HiveRelOptMaterialization> getRewritingMaterializedViews() {
        return this.materializedViewsCache.values().stream().filter(materialization -> materialization.getScope().contains((Object)RewriteAlgorithm.CALCITE)).collect(Collectors.toList());
    }

    public HiveRelOptMaterialization getRewritingMaterializedView(String dbName, String viewName, EnumSet<RewriteAlgorithm> scope) {
        HiveRelOptMaterialization materialization = this.materializedViewsCache.get(dbName, viewName);
        if (materialization == null) {
            return null;
        }
        if (!materialization.isSupported(scope)) {
            return null;
        }
        return materialization;
    }

    public List<HiveRelOptMaterialization> getRewritingMaterializedViews(ASTNode ast) {
        return this.materializedViewsCache.get(ast);
    }

    private Context createContext(HiveConf conf) {
        Context ctx = new Context((Configuration)conf);
        ctx.setIsLoadingMaterializedView(true);
        ctx.setHDFSCleanup(true);
        return ctx;
    }

    public boolean isEmpty() {
        return this.materializedViewsCache.isEmpty();
    }

    private static RelNode createMaterializedViewScan(HiveConf conf, Table viewTable) {
        HiveTableScan tableRel;
        ColumnInfo colInfo;
        String colName;
        StructObjectInspector rowObjectInspector;
        RelOptPlanner planner = CalcitePlanner.createPlanner(conf);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystemImpl()));
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        RowResolver rr = new RowResolver();
        try {
            rowObjectInspector = (StructObjectInspector)viewTable.getDeserializer().getObjectInspector();
        }
        catch (SerDeException e) {
            return null;
        }
        List fields = rowObjectInspector.getAllStructFieldRefs();
        ArrayList<ColumnInfo> cInfoLst = new ArrayList<ColumnInfo>();
        for (StructField structField : fields) {
            colName = structField.getFieldName();
            colInfo = new ColumnInfo(structField.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)structField.getFieldObjectInspector()), null, false);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
        }
        ArrayList<ColumnInfo> nonPartitionColumns = new ArrayList<ColumnInfo>(cInfoLst);
        ArrayList<ColumnInfo> partitionColumns = new ArrayList<ColumnInfo>();
        for (FieldSchema part_col : viewTable.getPartCols()) {
            colName = part_col.getName();
            colInfo = new ColumnInfo(colName, (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)part_col.getType()), null, true);
            rr.put(null, colName, colInfo);
            cInfoLst.add(colInfo);
            partitionColumns.add(colInfo);
        }
        RelDataType rowType = TypeConverter.getType(cluster, rr, null);
        ArrayList<String> fullyQualifiedTabName = new ArrayList<String>();
        if (viewTable.getDbName() != null && !viewTable.getDbName().isEmpty()) {
            fullyQualifiedTabName.add(viewTable.getDbName());
        }
        fullyQualifiedTabName.add(viewTable.getTableName());
        if (HiveMaterializedViewsRegistry.obtainTableType(viewTable) == TableType.DRUID) {
            String address = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS);
            String dataSource = viewTable.getParameters().get("druid.datasource");
            HashSet<String> metrics = new HashSet<String>();
            ArrayList<RelDataType> druidColTypes = new ArrayList<RelDataType>();
            ArrayList<String> druidColNames = new ArrayList<String>();
            RelDataTypeFactory dtFactory = cluster.getRexBuilder().getTypeFactory();
            for (RelDataTypeField field : rowType.getFieldList()) {
                if ("__time".equals(field.getName())) {
                    druidColTypes.add(dtFactory.createTypeWithNullability(field.getType(), false));
                } else {
                    druidColTypes.add(field.getType());
                }
                druidColNames.add(field.getName());
                if (field.getName().equals("__time") || field.getType().getSqlTypeName() == SqlTypeName.VARCHAR) continue;
                metrics.add(field.getName());
            }
            List<Interval> intervals = Collections.singletonList(DruidTable.DEFAULT_INTERVAL);
            rowType = dtFactory.createStructType(druidColTypes, druidColNames);
            RelOptHiveTable optTable = new RelOptHiveTable(null, cluster.getTypeFactory(), fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, partitionColumns, new ArrayList<VirtualColumn>(), conf, new QueryTables(true), new HashMap<String, PrunedPartitionList>(), new HashMap<String, ColumnStatsList>(), new AtomicInteger());
            DruidTable druidTable = new DruidTable(new DruidSchema(address, address, false), dataSource, RelDataTypeImpl.proto((RelDataType)rowType), metrics, "__time", intervals, null, null);
            HiveTableScan scan = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
            tableRel = DruidQuery.create((RelOptCluster)cluster, (RelTraitSet)cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), (RelOptTable)optTable, (DruidTable)druidTable, (List)ImmutableList.of((Object)scan), (Map)ImmutableMap.of());
        } else {
            RelOptHiveTable optTable = new RelOptHiveTable(null, cluster.getTypeFactory(), fullyQualifiedTabName, rowType, viewTable, nonPartitionColumns, partitionColumns, new ArrayList<VirtualColumn>(), conf, new QueryTables(true), new HashMap<String, PrunedPartitionList>(), new HashMap<String, ColumnStatsList>(), new AtomicInteger());
            tableRel = new HiveTableScan(cluster, cluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), optTable, viewTable.getTableName(), null, false, false);
        }
        return tableRel;
    }

    private static TableType obtainTableType(Table tabMetaData) {
        if (tabMetaData.getStorageHandler() != null) {
            String storageHandlerStr = tabMetaData.getStorageHandler().toString();
            if (storageHandlerStr.equals("org.apache.hadoop.hive.druid.DruidStorageHandler")) {
                return TableType.DRUID;
            }
            if (storageHandlerStr.equals("org.apache.hive.storage.jdbc.JdbcStorageHandler")) {
                return TableType.JDBC;
            }
        }
        return TableType.NATIVE;
    }

    private class Loader
    implements Runnable {
        private final Hive db;

        private Loader(Hive db) {
            this.db = db;
        }

        @Override
        public void run() {
            PerfLogger perfLogger = SessionState.getPerfLogger();
            try {
                DriverUtils.setUpAndStartSessionState(this.db.getConf());
                perfLogger.perfLogBegin(CLASS_NAME, "MaterializedViewsRegistryRefresh");
                if (HiveMaterializedViewsRegistry.this.initialized.get()) {
                    for (Table mvTable : this.db.getAllMaterializedViewObjectsForRewriting()) {
                        HiveRelOptMaterialization existingMV = HiveMaterializedViewsRegistry.this.getRewritingMaterializedView(mvTable.getDbName(), mvTable.getTableName(), RewriteAlgorithm.ALL);
                        if (existingMV != null) {
                            Table existingMVTable = HiveMaterializedViewUtils.extractTable(existingMV);
                            if (existingMVTable.getCreateTime() >= mvTable.getCreateTime() && (existingMVTable.getCreateTime() != mvTable.getCreateTime() || existingMVTable.getMVMetadata().getMaterializationTime() > mvTable.getMVMetadata().getMaterializationTime())) continue;
                            HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), existingMVTable, mvTable);
                            continue;
                        }
                        HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), null, mvTable);
                    }
                    LOG.info("Materialized views registry has been refreshed");
                } else {
                    for (Table mvTable : this.db.getAllMaterializedViewObjectsForRewriting()) {
                        HiveMaterializedViewsRegistry.this.refreshMaterializedView(this.db.getConf(), null, mvTable);
                    }
                    HiveMaterializedViewsRegistry.this.initialized.set(true);
                    LOG.info("Materialized views registry has been initialized");
                }
            }
            catch (HiveException e) {
                if (HiveMaterializedViewsRegistry.this.initialized.get()) {
                    LOG.error("Problem connecting to the metastore when refreshing the view registry", (Throwable)e);
                }
                LOG.error("Problem connecting to the metastore when initializing the view registry", (Throwable)e);
            }
            perfLogger.perfLogEnd(CLASS_NAME, "MaterializedViewsRegistryRefresh");
        }
    }

    private static enum TableType {
        DRUID,
        NATIVE,
        JDBC;

    }
}

